/*
 * loader/screen.S
 *
 * Printing routines for Choose-OS.
 *
 * Copyright (c) Tuomo Valkonen 1997-1998.
 */
 
// prints Null-terminated string at SI at cursor pos with default color...
print:	
	mov	bl,chos_color
	
	// Fall thru 

// Same with color in bl...
print_color:
        mov     al,(si)
      	mov	cx,#1
        xor	bh,bh
print_it_color:
	cmp	al,#0x0d
	je	next_line
        mov     ah,#0x09
        int     #0x10
        call	inc_cursor
nl_ret:
        inc     si
        mov     al,(si)
        cmp     al,#0
        jne     print_it_color

        ret

next_line:
	call	crlf
	jmp	nl_ret

inc_cursor:
	pusha
	mov	ah,#0x03
	int	#0x10
	inc	dl
	cmp	dl,#80
	jb	inc_ok
	xor	dl,dl
	inc	dh
	cmp	dh,#24
	ja	scroll_up
inc_ok:
	mov	ah,#0x02
	int	#0x10
	popa
	ret
scroll_up:
	mov	ah,#6
	mov	al,#1
	mov	bh,chos_color
	mov	ch,#0
	mov	cl,#0
	mov	dh,#24
	mov	dl,#79
	int	#0x10
	xor	bh,bh
	mov	ax,#0x0e0d
	int	#0x10
	popa
	ret

// Print nextline
crlf:
	pusha
	mov	ah,#0x03
	xor	bh,bh
	int	#0x10
	cmp	dh,#24
	jae	scroll_up

	xor	bh,bh
	mov	ax,#0x0e0a
	int	#0x10
	mov	al,#0x0d
	int	#0x10
	popa
	ret

// Print character in AL
putch:
	pusha
	xor	bh,bh
	mov	bl,chos_color
	mov	cx,#1
	mov	ah,#0x09
	int	0x10
	call	inc_cursor
	popa
	ret

// Move cursor to dl,dh
set_cursor_pos:
	mov	ah,#2			! int 10h,2 = move cursor
	xor	bh,bh			! video page 0
	int	0x10
	ret

// clear line dh
clear_line:
	xor	dl,dl
	call	set_cursor_pos
	mov	ax,#0x0900
	mov	bx,#0x0007
	mov	cx,#80
	int	0x10
	
	ret

// Print a period ('.') on screen
print_period:
	push	ax
	mov	al,#46
	call	putch
	pop	ax
	ret


// select an image and reprint 'em all
select:
	xor	ah,ah
	mov	selected,al

// Print all image namez...
print_images:
	mov	cx,#0
	mov	si,#boot_images
pi_loop:
	
	mov	dl,byte ptr (si+BID_X_OFF)
	mov	dh,byte ptr (si+BID_Y_OFF)
	call	set_cursor_pos

	test	word ptr (si+BID_FLAGS_OFF),#CF_HOT_HIDDEN
	jnz	no_hot_print
	
	mov	bl,byte ptr (si+BID_COLOR_OFF)
	cmp	cl,selected
	jne	print_number
	and	bl,#0xf
	cmp	bl,chos_sel
	jne	sel_aint_same
	or	bl,#0x08		! Set high-bit
sel_aint_same:
	mov	bh,chos_sel
	shl	bh,#4
	or	bl,bh
	
print_number:
	mov	al,byte ptr (si+BID_HOTKEY_OFF)
	push	si
	mov	si,#hot_string
	mov	(si),al
	push	cx
	call	print_color
	pop	cx
	pop	si

no_hot_print:

	mov	bl,(si+BID_COLOR_OFF)
	cmp	cl,selected
	jne	print_the_image
	and	bl,#0xf
	cmp	bl,chos_sel
	jne	sel_aint_same2
	or	bl,#0x08
sel_aint_same2:
	mov	bh,chos_sel
	shl	bh,#4
	or	bl,bh
print_the_image:
	push	si
	push	cx
	call	print_color
	pop	cx
	pop	si

	add	si,#BID_DATA_SIZE
	inc	cl
	cmp	cl,chos_images
	jb	pi_loop

	ret

// Data
/////////
hot_string:	.ascii	"0. "
		.byte	0
