static char dqsusage_c_rcsid[]="dqsusage.c,v 1.1.1.1 1994/06/18 19:43:29 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * dqsusage.c,v
 * Revision 1.1.1.1  1994/06/18  19:43:29  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/AsciiText.h>
#include "h.h"
#include "def.h"
#include "struct.h"
#include "dqs.h"
#include "globals.h"
#include "cpu.h"
#include "help.h"
#include "about.h"
#include "xgui.h"
#include "queusage.h"
#include "stdstuff.h"
#include "dqsusage.h"

extern Display *XDisplay;
extern Widget TopLevelW;

static void
DQSUsageQuit (W, ClientData, CallData)
     Widget W;
     caddr_t ClientData;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageQuit"));

  XtCloseDisplay (XDisplay);

  DEXIT;
  exit (EXIT_SUCCESS);
}

static void
DQSUsageHelp (W, ClientData, CallData)
     Widget W;
     caddr_t ClientData;
     caddr_t CallData;
{
  DENTER ((DQS_EVENT, "DQSUsageHelp"));

  Help ("Using qusage");

  DEXIT;
}

void
DQSUsage ()
{
  static Widget DQSUsageFormW;
  static Widget DQSUsageTitleLabelW;
  static Widget DQSUsageQueueButtonW;
  static Widget DQSUsageCPUButtonW;
  static Widget DQSUsageHelpButtonW;
  static Widget DQSUsageAboutButtonW;
  static Widget DQSUsageQuitButtonW; 

  DENTER ((DQS_EVENT, "DQSUsage"));

  DQSUsageFormW =
    XtCreateManagedWidget ("DQSUsageForm", formWidgetClass, TopLevelW,
			   NULL, ZERO);
  
  DQSUsageTitleLabelW =
    XtCreateManagedWidget ("DQSUsageTitle", labelWidgetClass, DQSUsageFormW,
			   NULL, ZERO);
  
  DQSUsageCPUButtonW =
    XtCreateManagedWidget ("DQSUsageCPU", commandWidgetClass, DQSUsageFormW,
			   NULL, ZERO);
  XtAddCallback (DQSUsageCPUButtonW, XtNcallback,
		 (XtCallbackProc) DQSUsageCPU, DQSUsageFormW);
  
  DQSUsageHelpButtonW =
    XtCreateManagedWidget ("DQSUsageHelp", commandWidgetClass, DQSUsageFormW,
			   NULL, ZERO);
  XtAddCallback (DQSUsageHelpButtonW, XtNcallback,
		 (XtCallbackProc) DQSUsageHelp, DQSUsageFormW);
  
  DQSUsageAboutButtonW =
    XtCreateManagedWidget ("DQSUsageAbout", commandWidgetClass, DQSUsageFormW,
			   NULL, ZERO);
  XtAddCallback (DQSUsageAboutButtonW, XtNcallback,
		 (XtCallbackProc) DQSUsageAbout, DQSUsageFormW);
  
  DQSUsageQuitButtonW =
    XtCreateManagedWidget ("DQSUsageQuit", commandWidgetClass, DQSUsageFormW,
			   NULL, ZERO);
  XtAddCallback (DQSUsageQuitButtonW, XtNcallback,
		 (XtCallbackProc) DQSUsageQuit, DQSUsageFormW);
  
  DEXIT;
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
