;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Coerce/funcall.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jan 20 17:21:26 1995                          */
;*    Last change :  Wed Aug 21 16:11:00 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `funcall' coercion                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_funcall
   (include "Tools/trace.sch"
	    "Tools/location.sch")
   (import  engine_param
	    tools_shape
	    tools_error
	    tools_location
	    type_type
	    type_cache
	    ast_var
	    ast_node
	    ast_sexp
	    ast_local
	    coerce_coerce
	    coerce_convert))

;*---------------------------------------------------------------------*/
;*    coerce! ::funcall ...                                            */
;*---------------------------------------------------------------------*/
(define-method (coerce! node::funcall to)
   (trace coerce "coerce-funcall!: " (shape node) #\Newline)
   (let ((error-msg (list 'quote (shape node)))
	 (strength  (funcall-strength node)))
      ;; we coerce the arguments
      (coerce-funcall-args! node to)
      (if (memq strength '(light elight))
	  (convert! node *obj* to)
	  ;; we coerce the procedure
	  (let ((c-fun (coerce! (funcall-fun node) *procedure*)))
	     ;; we check arity
	     (if *unsafe-arity*
		 (begin
		    (funcall-fun-set! node c-fun)
		    (convert! node *obj* to))
		 (let* ((fun    (make-local-svar 'fun *procedure*))
			(loc    (node-loc node))
			(len    (-fx (length (funcall-args node)) 2))
			(a-len  (gensym 'len))
			(a-tlen (symbol-append a-len '::long))
			(lnode  (instantiate::let-var
				   (loc loc)
				   (type *obj*)
				   (bindings (list (cons fun c-fun)))
				   (body (top-level-sexp->node
					  `(let ((,a-tlen ,len))
					      (if (correct-arity? ,fun ,a-len)
						  ,(convert! node *obj* to)
						  ,(make-error-node fun
								    error-msg
								    loc
								    to)))
					  loc)))))
		    (funcall-fun-set! node (instantiate::var
					      (loc loc)
					      (type *obj*)
					      (variable fun)))
		    lnode))))))

;*---------------------------------------------------------------------*/
;*    make-error-node ...                                              */
;*---------------------------------------------------------------------*/
(define (make-error-node fun error-msg loc to)
   (let ((ut *unsafe-type*))
      (set! *unsafe-type* #t)
      (let ((node (coerce!
		   (top-level-sexp->node 
		    (if (and (>fx *compiler-debug* 0) (location? loc))
			`(begin
			    ((@ error/location __error)
			     ,(string-append (symbol->string
					      (current-function))
					     ":Wrong number of arguments")
			     ,error-msg
			     ,fun
			     ,(location-full-fname loc)
			     ,(location-pos loc))
			    (failure '_ '_ '_))
			`(failure ,(string-append (symbol->string
						   (current-function))
						  ":Wrong number of arguments")
				  ,error-msg
				  ,fun))
		    loc)
		   to)))
	 (set! *unsafe-type* ut)
	 node)))

;*---------------------------------------------------------------------*/
;*    coerce-funcall-args! ...                                         */
;*---------------------------------------------------------------------*/
(define (coerce-funcall-args! node to)
   (if (null? (funcall-args node))
       (funcall-args-set! node (list (top-level-sexp->node
				      '__eoa__
				      (node-loc node))))
       (let loop ((actuals (funcall-args node))
		  (prev    'dummy))
	  (if (null? actuals)
	      (set-cdr! prev (list (top-level-sexp->node
				    '__eoa__
				    (node-loc node))))
	      (begin
		 (set-car! actuals (coerce! (car actuals) *obj*))
		 (loop (cdr actuals) actuals))))))
