;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Coerce/typeof.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jul  1 09:35:30 1996                          */
;*    Last change :  Thu Apr  3 14:17:54 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The node typeof generic function.                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module coerce_typeof
   (import  type_type
	    type_cache
	    type_typeof
	    tools_shape
	    ast_var
	    ast_node)
   (export  (generic typeof::type ::node)))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-generic (typeof::type node::node))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::atom)
   (with-access::atom node (value)
      (typeof-atom value)))
 
;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::kwote)
   (with-access::kwote node (value)
      (typeof-kwote value)))

;*---------------------------------------------------------------------*/
;*    typeof ...                                                       */
;*---------------------------------------------------------------------*/
(define-method (typeof node::var)
   (with-access::var node (variable)
      (let ((value (variable-value variable)))
	 (cond
	    ((sfun? value)
	     *procedure*)
	    ((cfun? value)
	     (error "typeof" "Je n'ai pas encore fait ce truc" (shape node)))
	    (else
	     (variable-type variable))))))

;*---------------------------------------------------------------------*/
;*    typeof ::closure ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::closure)
   *procedure*)

;*---------------------------------------------------------------------*/
;*    typeof ::sequence ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::sequence)
   (with-access::sequence node (nodes)
      (typeof (car (last-pair nodes)))))

;*---------------------------------------------------------------------*/
;*    typeof ::pragma ...                                              */
;*---------------------------------------------------------------------*/
(define-method (typeof node::pragma)
   (with-access::pragma node (type)
      type))

;*---------------------------------------------------------------------*/
;*    typeof ::cast ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::cast)
   (with-access::cast node (type)
      type))

;*---------------------------------------------------------------------*/
;*    typeof ::setq ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::setq)
   *unspec*)

;*---------------------------------------------------------------------*/
;*    typeof ::conditional ...                                         */
;*---------------------------------------------------------------------*/
(define-method (typeof node::conditional)
   (with-access::conditional node (test true false)
      (let ((ttrue (typeof true))
	    (tfalse (typeof false)))
	 (if (not (eq? ttrue tfalse))
	     *obj*
	     ttrue))))

;*---------------------------------------------------------------------*/
;*    typeof ::fail ...                                                */
;*---------------------------------------------------------------------*/
(define-method (typeof node::fail)
   (with-access::fail node (proc msg obj)
      *magic*))

;*---------------------------------------------------------------------*/
;*    typeof ::select ...                                              */
;*---------------------------------------------------------------------*/
(define-method (typeof node::select)
   (with-access::select node (clauses test)
      (let loop ((clauses (cdr clauses))
		 (type    (typeof (cdr (car clauses)))))
	 (if (null? clauses)
	     type
	     (if (eq? (typeof (cdr (car clauses))) type)
		 (loop (cdr clauses) type)
		 *obj*)))))

;*---------------------------------------------------------------------*/
;*    typeof ::let-fun ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::let-fun)
   (with-access::let-fun node (body)
      (typeof body)))

;*---------------------------------------------------------------------*/
;*    typeof ::let-var ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::let-var)
   (with-access::let-var node (body)
      (typeof body)))
 
;*---------------------------------------------------------------------*/
;*    typeof ::set-ex-it ...                                           */
;*---------------------------------------------------------------------*/
(define-method (typeof node::set-ex-it)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::jump-ex-it ...                                          */
;*---------------------------------------------------------------------*/
(define-method (typeof node::jump-ex-it)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::make-box ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::make-box)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::box-ref ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::box-ref)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::box-set! ...                                            */
;*---------------------------------------------------------------------*/
(define-method (typeof node::box-set!)
   *unspec*)

;*---------------------------------------------------------------------*/
;*    typeof ::app-ly ...                                               */
;*---------------------------------------------------------------------*/
(define-method (typeof node::app-ly)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::funcall ...                                             */
;*---------------------------------------------------------------------*/
(define-method (typeof node::funcall)
   *obj*)

;*---------------------------------------------------------------------*/
;*    typeof ::app ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (typeof node::app)
   (with-access::app node (fun)
      (variable-type (var-variable fun))))
		
		
