;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Engine/interp.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 08:03:39 1996                          */
;*    Last change :  Sun Nov 16 19:11:03 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inner interpreter.                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module engine_interp
   (import engine_param
	   tools_file)
   (export (interp version verbose file startup path args)))

;*---------------------------------------------------------------------*/
;*    interp ...                                                       */
;*---------------------------------------------------------------------*/
(define (interp version verbose files startup path args)
   (set! *bigloo-interpreter* #t)
   (if (and (>=fx verbose 0) (not (pair? files)))
       (begin
	  (version)
	  (print "Welcome to the interpreter")))
   ;; on definie la variable `(command-line)'
   (set! *the-command-line* (interp-parse-args args))
   ;; on charge le fichier de startup
   (if (string? startup)
       (let ((path (let ((home (getenv "HOME")))
		      (if (string? home)
			  (cons home path)
			  path))))
	  (let ((fstartup (find-file/path startup path)))
	     (if fstartup
		 (loadq startup)
		 (warning "interp"
			  #\Newline
			  "Can't file startup file -- " startup)))))
   ;; on rentre dans l'interprete
   (if (pair? files)
       (for-each loadq files)
       (repl))
   0)

;*---------------------------------------------------------------------*/
;*    interp-parse-args ...                                            */
;*---------------------------------------------------------------------*/
(define (interp-parse-args args)
   (let loop ((args (cdr args))
	      (res  '()))
      (cond
	 ((null? args)
	  (append *src-files* (reverse res)))
	 ((string=? (car args) "-i")
	  (loop (cdr args) res))
	 ((member (car args) *src-files*)
	  (loop (cdr args) res))
	 (else
	  (loop (cdr args) (cons (car args) res))))))
			   

