;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/rgc-eval.scm ...             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Mar 28 08:54:00 1994                          */
;*    Last change :  Mon Mar 28 09:07:45 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On test rgc sous eval                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module rgc-eval
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-rgc-eval)))

;*---------------------------------------------------------------------*/
;*    Le test                                                          */
;*---------------------------------------------------------------------*/
(eval '(begin (define *char* 0)
	      (define *line* 0)
	      (define *word* 0)
	      (define g (regular-grammar ()
			   ((+ #\Newline)
			    (set! *char* (+fx *char* (the-length)))
			    (set! *line* (+fx *line* (the-length)))
			    'keep)
			   ((+ (in #\space #\tab))
			    (set! *char* (+fx *char* (the-length)))
			    'keep)
			   ((+ (out #\newline #\space #\tab))
			    (set! *char* (+fx *char* (the-length)))
			    (set! *word* (+fx 1 *word*))
			    'keep)))))

;*---------------------------------------------------------------------*/
;*    test-rgc-eval ...                                                */
;*---------------------------------------------------------------------*/
(define (test-rgc-eval)
   (test-module "rgc-eval" "rgc-eval.scm" #f)
   (test "rgc-eval"
	 (eval '(let ((p (open-input-string #"toto \ntiti \ntutu")))
		   (let loop ((exp (read/rp g p)))
		      (if (eof-object? exp)
			  (list *char* *line* *word*)
			  (loop (read/rp g p))))))
	 '(16 2 3)))
 
 
