;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/input.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Sat Feb 14 09:35:38 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.2 Input (page 30, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2

   (import  (__error                   "Llib/error.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")

	    (__evenv                   "Eval/evenv.scm"))
   
   (extern  (macro c-eof-object?::bool (::obj) "EOF_OBJECTP"))
    
   (export  (inline read/rp    ::procedure ::input-port)
	    (inline read/lalrp ::procedure ::procedure ::input-port . obj)
	    
	    (read-char                   . port)
	    (peek-char                   . port)
	    (inline eof-object?::bool    ::obj)
	    (char-ready?::bool)
	    (inline read-string::obj     ::input-port ::long)
	    (read-line::obj              ::input-port)
	    (read-of-strings::obj        ::input-port)
	    *about-to-read*)

   (pragma  (eof-object? side-effect-free)
	    (char-ready? side-effect-free)))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (read/rp grammar port)
   (grammar port))

;*---------------------------------------------------------------------*/
;*    read/lalr ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (read/lalrp lalr rgc port . eof-fun?)
   (if (null? eof-fun?)
       (lalr rgc port eof-object?)
       (lalr rgc port (car eof-fun?))))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char . port)
   (let ((port (if (null? port) (current-input-port) (car port))))
      (letrec ((return (lambda ()
			  (let ((c (input-port-read-char port)))
			     (if (rgc-=? c 0)
				 (if (input-port-fill-buffer port)
				     (return)
				     (input-port-steal-char port))
				 (begin
				    (input-port-reset-annexe! port)
				    (input-port-remember-ref port)
				    (input-port-ajust-cursor port)
				    (integer->char c)))))))
	 (return))))

;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (peek-char  . port)
   (let ((port (if (null? port) (current-input-port) (car port))))
      (letrec ((return (lambda ()
			  (let ((c (input-port-read-char port)))
			     (if (rgc-=? c 0)
				 (if (input-port-fill-buffer port)
				     (return)
				     (input-port-steal-char port))
				 (begin
				    (c-input-port-unread-char port)
				    (integer->char c)))))))
	 (return))))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    char-ready? ...                                                  */
;*---------------------------------------------------------------------*/
(define (char-ready?)
   #t)

;*---------------------------------------------------------------------*/
;*    read-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (read-string input-port number)
   (c-input-port-read-string input-port number))

;*---------------------------------------------------------------------*/
;*    *read-line-grammar* ...                                          */
;*---------------------------------------------------------------------*/
(define *read-line-grammar*
   (regular-grammar ()
      ((* (all))
       (let ((string (the-string)))
	  (input-port-steal-char input-port)
	  string))
      ((#\Newline)
       "")))
 
;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-line input-port)
   (read/rp *read-line-grammar* input-port))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define *read-of-strings-grammar*
   (regular-grammar ()
      ((+ (in #\space #\tab #\newline))
       (ignore))
      ((+ (out #\space #\tab #\newline))
       (the-string))))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define (read-of-strings input-port)
   (read/rp *read-of-strings-grammar* input-port))

;*---------------------------------------------------------------------*/
;*    *about-to-read* ...                                              */
;*---------------------------------------------------------------------*/
(define *about-to-read* #unspecified)

