;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/intext.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano & Pierre Weis                      */
;*    Creation    :  Tue Jan 18 08:11:58 1994                          */
;*    Last change :  Mon Jan 19 18:21:35 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The serialization process does not make hypothesis on word's     */
;*    size.                                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __intext

   (import  (__error                   "Llib/error.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bit                     "Llib/bit.scm")
	    (__object                  "Llib/object.scm")
	    (__dsssl                   "Llib/dsssl.scm")
	    (__ucs2                    "Llib/ucs2.scm")
	    (__unicode                 "Llib/unicode.scm")
	    (__hash                    "Llib/hash.scm")
	    (__process                 "Llib/process.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")

	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__evenv                   "Eval/evenv.scm"))

   (foreign (macro long  cnst->integer          (obj)  "CCNST")
	    (macro obj   integer->cnst          (long) "BCNST")
	    (macro bool  pointer?               (obj)  "POINTERP")
	    (macro long  size-of-long                 "sizeof( long )")
	    (macro long  string-mark-offset           "STRING_MARK_OFFSET")
	    (macro long  struct-mark-offset           "STRUCTURE_MARK_OFFSET")
	    (macro obj   inverse-string-length! (obj) "INVERSE_STRING_LENGTH")
	    (macro obj   inverse-ucs2-string-length! (obj) "INVERSE_UCS2_STRING_LENGTH")
	    (export string->obj "string_to_obj")
	    (export obj->string "obj_to_string"))
   
   (export  (string->obj          ::bstring)
	    (obj->string::bstring ::obj))
   
   (pragma  (string->obj side-effect-free)
	    (obj->string side-effect-free)))
  
;*---------------------------------------------------------------------*/
;*    unsafe                                                           */
;*---------------------------------------------------------------------*/
(define-macro (unsafe)
   (set! *unsafe-type*   #t)
   (set! *unsafe-arity*  #t)
   (set! *unsafe-range*  #t)
   (set! *unsafe-struct* #t)
   '#unspecified)

(unsafe)

;*---------------------------------------------------------------------*/
;*    for  ....                                                        */
;*---------------------------------------------------------------------*/
(define-macro (for var min max . body)
   (let ((loop (gensym 'for)))
      `(let ,loop ((,var ,min))
	    (if (<=fx ,var ,max)
		(begin
		   ,@body
		   (,loop (+fx ,var 1)))
		'done))))

;*---------------------------------------------------------------------*/
;*    Les variables de controle de `string->obj'                       */
;*---------------------------------------------------------------------*/
(define *ref-vector* '#())
(define *defining*    #f)
(define *pointeur*    0)
(define *nb-ref*      0)
(define *ref*         0)

;*---------------------------------------------------------------------*/
;*    string->obj ...                                                  */
;*---------------------------------------------------------------------*/
(define (string->obj s)
   (define (read-taille)
      (let ((accu-entier 0))
	 (let ((taille (char->integer (string-ref s *pointeur*))))
	    (set! *pointeur* (+fx *pointeur* 1))
	    (for i 0 (-fx taille 1)
		 (let ((d (string-ref s *pointeur*)))
		    (set! accu-entier (+fx (*fx 256 accu-entier)
					   (char->integer d)))
		    (set! *pointeur* (+fx *pointeur* 1))))
	    accu-entier)))
   (define (read-nombre-entier)
      (read-taille))
   (define (read-nombre-flottant)
      (let* ((taille (read-taille))
	     (res    (string->real (substring s
					      *pointeur*
					      (+fx *pointeur* taille)))))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-definition)
      (set! *defining* (read-item))
      (read-item))
   (define (read-reference)
      (vector-ref *ref-vector* (read-item)))
   (define (read-symbol)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (res      (string->symbol (read-string))))
	 (if (integer? defining)
	     (vector-set! *ref-vector* defining res))
	 res))
   (define (read-keyword)
      (string->keyword (read-string)))
   (define (read-cnst)
      (integer->cnst (read-nombre-entier)))
   (define (read-char)
      (integer->char (read-nombre-entier)))
   (define (read-ucs2)
      (integer->ucs2 (read-nombre-entier)))
   (define (read-string)
      (let* ((taille (read-taille))
	     (res    (substring s *pointeur* (+fx *pointeur* taille))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (set! *pointeur* (+fx *pointeur* taille))
	 res))
   (define (read-ucs2-string)
      (utf8-string->ucs2-string (read-item)))
   (define (read-vecteur)
      (let* ((taille (read-taille))
	     (res    (c-create-vector taille)))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-tague)
      (let* ((tag    (read-item))
	     (taille (read-taille))
	     (res    (c-create-vector taille)))
	 (vector-tag-set! res tag)
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (for i 0 (-fx taille 1)
	      (vector-set! res i (read-item)))
	 res))
   (define (read-vecteur-type)
      (let* ((id (read-item))
	     (v  (read-item))
	     (tv (vector->tvector id v)))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* tv)
		(set! *defining* #f)))
	 tv))
   (define (read-liste)
      (let* ((taille (read-taille))
	     (res    (cons '() '())))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (let loop ((i  0)
		    (hd res))
	    (if (=fx i (-fx taille 2))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (read-item)))
		(begin
		   (set-car! hd (read-item))
		   (set-cdr! hd (cons '() '()))
		   (loop (+fx i 1) (cdr hd)))))
	 res))
   (define (read-cellule)
      (let ((res (make-cell (unspecified))))
	 (if (integer? *defining*)
	     (begin
		(vector-set! *ref-vector* *defining* res)
		(set! *defining* #f)))
	 (cell-set! res (read-item))
	 res))
   (define (read-structure)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (key      (read-item))
	     (taille   (read-taille))
	     (res      (make-struct key taille (unspecified))))
	 (if (integer? defining)
	     (vector-set! *ref-vector* defining res))
	 (for i 0 (-fx taille 1)
	      (begin
		 (struct-set! res i (read-item))))
	 res))
   (define (read-object)
      (let* ((defining (let ((old *defining*))
			  (set! *defining* #f)
			  old))
	     (key      (read-item))
	     (taille   (read-taille))
	     (struct   (make-struct key taille (unspecified)))
	     (object   (allocate-instance key)))
	 (if (integer? defining)
	     (vector-set! *ref-vector* defining object))
	 (for i 0 (-fx taille 1)
	      (begin
		 (struct-set! struct i (read-item))))
	 (let ((hash (read-item)))
	    (if (=fx hash (class-hash (object-class object)))
		(struct+object->object object struct)
		(error "string->obj" "corrupted class" object)))))
   (define (read-item)
      (let ((d (string-ref s *pointeur*)))
	 (set! *pointeur* (+fx *pointeur* 1))
	 (case d
	    ((#\=)  (read-definition))
	    ((#\#)  (read-reference))
	    ((#\')  (read-symbol))
	    ((#\:)  (read-keyword))
	    ((#\a)  (read-char))
	    ((#\u)  (read-ucs2))
	    ((#\<)  (read-cnst))
	    ((#\F)  #f)
	    ((#\")  (read-string))
	    ((#\U)  (read-ucs2-string))
	    ((#\[)  (read-vecteur))
	    ((#\t)  (read-vecteur-tague))
	    ((#\V)  (read-vecteur-type))
	    ((#\()  (read-liste))
	    ((#\{)  (read-structure))
	    ((#\|)  (read-object))
	    ((#\f)  (read-nombre-flottant))
	    ((#\-)  (negfx (read-nombre-entier)))
	    ((#\!)  (read-cellule))
	    (else   (set! *pointeur* (-fx *pointeur* 1))
		    (read-nombre-entier)))))
   (set! *pointeur* 0)
   (let ((d (string-ref s *pointeur*)))
      (if (char=? d #\c)
	  (begin
	     (set! *pointeur* (+fx *pointeur* 1))
	     (set! *ref-vector* (make-vector (read-taille))))))
   (read-item))

;*---------------------------------------------------------------------*/
;*    les structures de marks                                          */
;*---------------------------------------------------------------------*/
(define-struct mark obj old-value ref defined? ref-count aux)

;*---------------------------------------------------------------------*/
;*    incr-mark-ref-count! ...                                         */
;*---------------------------------------------------------------------*/
(define (incr-mark-ref-count! mark ref)
   (let ((old-mark (mark-ref-count mark)))
      (mark-ref-count-set! mark (+fx 1 old-mark))
      (if (=fx old-mark 0)
	  (+fx ref 1)
	  ref)))

;*---------------------------------------------------------------------*/
;*    pair-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-unmark! pair)
   (let ((old-value (mark-old-value (get-pair-mark pair))))
      (set-cdr! pair old-value)))

;*---------------------------------------------------------------------*/
;*    pair-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (pair-mark! pair)
   (let ((new (make-mark)))
      (mark-obj-set!       new pair)
      (mark-old-value-set! new (cdr pair))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (set-cdr! pair new)
      new))

;*---------------------------------------------------------------------*/
;*    pair-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (pair-marked? pair)
   (mark? (cdr pair)))

;*---------------------------------------------------------------------*/
;*    get-pair-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-pair-mark pair)
   (cdr pair))

;*---------------------------------------------------------------------*/
;*    pointer-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-unmark! ptr)
   (let ((old-value (mark-old-value (get-pointer-mark ptr))))
      (poke! ptr 1 old-value)))

;*---------------------------------------------------------------------*/
;*    pointer-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (pointer-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr 1))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr 1 new)
      new))

;*---------------------------------------------------------------------*/
;*    pointer-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (pointer-marked? ptr)
   (mark? (get-pointer-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-pointer-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-pointer-mark ptr)
   (peek ptr 1))

;*---------------------------------------------------------------------*/
;*    cell-unmark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-unmark! cell)
   (let ((old-value (mark-old-value (get-cell-mark cell))))
      (cell-set! cell old-value)))

;*---------------------------------------------------------------------*/
;*    cell-mark! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cell-mark! cell)
   (let ((new (make-mark)))
      (mark-obj-set!       new cell)
      (mark-old-value-set! new (cell-ref cell))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (cell-set! cell new)
      new))

;*---------------------------------------------------------------------*/
;*    cell-marked? ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-marked? cell)
   (mark? (cell-ref cell)))

;*---------------------------------------------------------------------*/
;*    get-cell-mark ...                                                */
;*---------------------------------------------------------------------*/
(define (get-cell-mark cell)
   (cell-ref cell))

;*---------------------------------------------------------------------*/
;*    symbol-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (symbol-mark! symbol)
   (let ((new (make-mark)))
      (mark-obj-set!       new symbol)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (putprop! symbol 'mark new)
      new))

;*---------------------------------------------------------------------*/
;*    symbol-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (symbol-unmark! symbol)
   (remprop! symbol 'mark))

;*---------------------------------------------------------------------*/
;*    symbol-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (symbol-marked? symbol)
   (mark? (getprop symbol 'mark)))

;*---------------------------------------------------------------------*/
;*    get-symbol-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-symbol-mark symbol)
   (getprop symbol 'mark))

;*---------------------------------------------------------------------*/
;*    *string-mark-table* ...                                          */
;*---------------------------------------------------------------------*/
(define *string-mark-table* '())

;*---------------------------------------------------------------------*/
;*    string-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (string-unmark! ptr)
   (inverse-string-length! ptr))

;*---------------------------------------------------------------------*/
;*    string-mark! ...                                                 */
;*    -------------------------------------------------------------    */
;*    Strings have been allocated has atomic (i.e. not containing      */
;*    pointers). The marking process stores a pointer into the string  */
;*    length field thus, this pointer is not traced by the collector.  */
;*    To fix this, we also put this pointer into a table: the          */
;*    *string-mark-table*                                              */
;*---------------------------------------------------------------------*/
(define (string-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-old-value-set! new (string-length ptr))
      (put-hash! (cons ptr new) *string-mark-table*)
      (inverse-string-length! ptr)
      new))

;*---------------------------------------------------------------------*/
;*    string-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (string-marked? ptr)
   (<fx (string-length ptr) 0))

;*---------------------------------------------------------------------*/
;*    get-string-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-string-mark ptr)
   (let ((cell (get-hash ptr *string-mark-table*)))
      (if (not (pair? cell))
	  (error "obj->string" "Illegal string" #unspecified)
	  (cdr cell))))

;*---------------------------------------------------------------------*/
;*    ucs2-string-unmark! ...                                          */
;*---------------------------------------------------------------------*/
(define (ucs2-string-unmark! ptr)
   (inverse-ucs2-string-length! ptr))

;*---------------------------------------------------------------------*/
;*    ucs2-string-mark! ...                                            */
;*    -------------------------------------------------------------    */
;*    See the remark of string-mark! about garbage collector           */
;*    and string marks.                                                */
;*---------------------------------------------------------------------*/
(define (ucs2-string-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-old-value-set! new (ucs2-string-length ptr))
      (mark-aux-set!       new (ucs2-string->utf8-string ptr))
      (put-hash! (cons ptr new) *string-mark-table*)
      (inverse-ucs2-string-length! ptr)
      new))

;*---------------------------------------------------------------------*/
;*    ucs2-string-marked? ...                                          */
;*---------------------------------------------------------------------*/
(define (ucs2-string-marked? ptr)
   (<fx (ucs2-string-length ptr) 0))

;*---------------------------------------------------------------------*/
;*    get-ucs2-string-mark ...                                         */
;*---------------------------------------------------------------------*/
(define (get-ucs2-string-mark ptr)
   (let ((cell (get-hash ptr *string-mark-table*)))
      (if (not (pair? cell))
	  (error "obj->string" "Illegal ucs2-string" #unspecified)
	  (cdr cell))))

;*---------------------------------------------------------------------*/
;*    mark-ucs2-string->string ...                                     */
;*---------------------------------------------------------------------*/
(define (mark-ucs2-string->string ptr)
   (mark-aux (get-ucs2-string-mark ptr)))

;*---------------------------------------------------------------------*/
;*    vector-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-unmark! ptr)
   (let ((old-value (mark-old-value (get-vector-mark ptr))))
      (vector-set! ptr 0 old-value)))

;*---------------------------------------------------------------------*/
;*    vector-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (vector-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (vector-ref ptr 0))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (vector-set! ptr 0 new)
      new))

;*---------------------------------------------------------------------*/
;*    vector-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (vector-marked? ptr)
   (mark? (get-vector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-vector-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-vector-mark ptr)
   (vector-ref ptr 0))

;*---------------------------------------------------------------------*/
;*    tvector-unmark! ...                                              */
;*---------------------------------------------------------------------*/
(define (tvector-unmark! ptr)
   (let ((old-value (mark-old-value (get-tvector-mark ptr))))
      (poke! ptr 2 old-value)))

;*---------------------------------------------------------------------*/
;*    tvector-mark! ...                                                */
;*---------------------------------------------------------------------*/
(define (tvector-mark! ptr v)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr 2))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (mark-aux-set!       new v)
      (poke! ptr 2 new)
      new))

;*---------------------------------------------------------------------*/
;*    tvector-marked? ...                                              */
;*---------------------------------------------------------------------*/
(define (tvector-marked? ptr)
   (mark? (get-tvector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-tvector-mark ...                                             */
;*---------------------------------------------------------------------*/
(define (get-tvector-mark ptr)
   (peek ptr 2))

;*---------------------------------------------------------------------*/
;*    mark-tvector->vector ...                                         */
;*---------------------------------------------------------------------*/
(define (mark-tvector->vector ptr)
   (mark-aux (get-tvector-mark ptr)))

;*---------------------------------------------------------------------*/
;*    struct-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-unmark! ptr)
   (let ((old-value (mark-old-value (get-struct-mark ptr))))
      (poke! ptr struct-mark-offset old-value)))

;*---------------------------------------------------------------------*/
;*    struct-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (struct-mark! ptr)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (peek ptr struct-mark-offset))
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (poke! ptr struct-mark-offset new)
      new))

;*---------------------------------------------------------------------*/
;*    struct-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (struct-marked? ptr)
   (mark? (get-struct-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-struct-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-struct-mark ptr)
   (peek ptr struct-mark-offset))

;*---------------------------------------------------------------------*/
;*    object-mark! ...                                                 */
;*---------------------------------------------------------------------*/
(define (object-mark! ptr struct)
   (let ((new (make-mark)))
      (mark-obj-set!       new ptr)
      (mark-old-value-set! new (object-widening ptr))
      (mark-aux-set!       new struct)
      (mark-ref-count-set! new 0)
      (mark-defined?-set!  new #f)
      (object-widening-set! ptr new)
      new))

;*---------------------------------------------------------------------*/
;*    object-unmark! ...                                               */
;*---------------------------------------------------------------------*/
(define (object-unmark! ptr)
   (let ((old-value (mark-old-value (get-object-mark ptr))))
      (object-widening-set! ptr old-value)))

;*---------------------------------------------------------------------*/
;*    object-marked? ...                                               */
;*---------------------------------------------------------------------*/
(define (object-marked? ptr)
   (mark? (get-object-mark ptr)))

;*---------------------------------------------------------------------*/
;*    get-object-mark ...                                              */
;*---------------------------------------------------------------------*/
(define (get-object-mark ptr)
   (object-widening ptr))

;*---------------------------------------------------------------------*/
;*    mark-object->struct ...                                          */
;*---------------------------------------------------------------------*/
(define (mark-object->struct ptr)
   (mark-aux (get-object-mark ptr)))

;*---------------------------------------------------------------------*/
;*    *taille-du-mot-maximum* ...                                      */
;*---------------------------------------------------------------------*/
(define *taille-du-mot-maximum* size-of-long)

;*---------------------------------------------------------------------*/
;*    taille-du-mot ...                                                */
;*---------------------------------------------------------------------*/
(define (taille-du-mot m)
   (let loop ((taille 0)
	      (m      m))
      (if (=fx m 0)
	  taille
	  (loop (+fx taille 1)
		(bit-rsh m 8)))))

;*---------------------------------------------------------------------*/
;*    obj->string ...                                                  */
;*---------------------------------------------------------------------*/
(define (obj->string obj)
   (set! *ref*      -1)
   (set! *nb-ref*   0)
   (set! *pointeur* 0)
   (let* ((length-buffer 100)
	  (buffer        (make-string length-buffer #\space)))
      (define (get-new-ref)
	 (set! *ref* (+fx *ref* 1))
	 *ref*)
      (define (verifie-taille-buffer! taille)
	 (let ((l (+fx *pointeur* (+fx taille
				       (+fx *taille-du-mot-maximum* 1)))))
	    (if (>=fx l length-buffer)
		(begin
		   (let ((vieille-longeur length-buffer)
			 (vieux-buffer    buffer))
		      (set! length-buffer (*fx 2 (+fx l 100)))
		      (set! buffer (make-string length-buffer))
		      (blit-string! vieux-buffer 0 buffer
				    0 vieille-longeur))))))
      (define (print-marqueur c)
	 (verifie-taille-buffer! 0)
	 (string-set! buffer *pointeur* c)
	 (set! *pointeur* (+fx *pointeur* 1)))
      (define (print-int-as-char c)
	 (print-marqueur (integer->char c)))
      (define (print-mot m)
	 (let ((taille (taille-du-mot m)))
	    (if (=fx taille 0)
		(print-int-as-char 0)
		(begin
		   (print-int-as-char taille)
		   (let loop ((i (-fx taille 1)))
		      (if (=fx i -1)
			  'done
			  (begin
			     (let ((d (bit-and (bit-rsh m (*fx 8 i)) #xff)))
				(print-int-as-char d)
				(loop (-fx i 1))))))))))
      (define (print-taille taille)
	 (verifie-taille-buffer! taille)     
	 (print-mot taille))
      (define (print-chars s len)
	 (let ((taille len))
	    (print-taille taille)
	    (blit-string! s 0 buffer *pointeur* taille)
	    (set! *pointeur* (+fx *pointeur* taille))))
      (define (print-ds s len)
	 (print-chars s len))
      (define (print-df f)
	 (let ((s (real->string f)))
	    (print-chars s (string-length s))))
      (define (print-di i)
	 (verifie-taille-buffer! 0)
	 (if (<fx i 0)
	     (begin
		(string-set! buffer *pointeur* #\-)
		(set! *pointeur* (+fx *pointeur* 1))
		(print-mot (negfx i)))
	     (print-mot i)))
      (define (print-dv v ref0 len)
	 (print-taille len)
	 (print-item ref0)
	 (for i 1 (-fx len 1)
	      (print-item (vector-ref-ur v i))))
      (define (print-du v len)
	 (print-taille len)
	 (for i 0 (-fx len 1)
	      (print-item (struct-ref v i))))
      (define (pair-mark-gc! p)
	 (let ((mark (get-pair-mark p)))
 	    (if (and (mark-defined? mark)
		     (>fx (mark-ref-count mark) 0))
		(mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		(pair-unmark! p))))
      (define (print-dl p len)
	 (print-taille len)
	 (let loop ((i 0)
		    (p p))
	    (cond
	       ((=fx i (-fx len 1))
		(if (pair? p)
		    (begin
		       (print-item (car p))
		       (print-item '())
		       (pair-mark-gc! p))
		    (print-item p)))
	       (else
		(let* ((mark (get-pair-mark p))
		       (vcdr (mark-old-value mark)))
		   (print-item (car p))
		   (pair-mark-gc! p)
		   (if (and (pair? vcdr)
			    (let ((mark (get-pair-mark vcdr)))
			       (or (> (mark-ref-count mark) 0)
				   (mark-defined? mark))))
		       (print-item vcdr)
		       (loop (+fx i 1) vcdr)))))))
      (define (print-struct marqueur item)
	 (cond
	    ((mark-defined? (get-struct-mark item))
	     (print-marqueur #\#)
	     (print-di (mark-ref (get-struct-mark item)))
	     (mark-ref-count-set! (get-struct-mark item)
				  (-fx (mark-ref-count
					(get-struct-mark item))
				       1))
	     (if (=fx (mark-ref-count (get-struct-mark item)) 0)
		 (struct-unmark! item)))
	    ((=fx (mark-ref-count (get-struct-mark item)) 0)
	     (struct-unmark! item)
	     (print-marqueur marqueur)
	     (print-item (struct-key item))
	     (print-du item (struct-length item)))
	    (else
	     (let* ((ref  (get-new-ref))
		    (mark (get-struct-mark item))
		    (len  (struct-length item))
		    key
		    tag)
		(begin
		   ;; il faut momentanement restorer la structure
		   (poke! item struct-mark-offset (mark-old-value mark))
		   (set! key (struct-key item))
		   ;; on restore
		   (poke! item struct-mark-offset mark))
		(mark-ref-set! mark ref)
		(mark-defined?-set! mark #t)
		(print-marqueur #\=)
		(print-di ref)
		(print-marqueur marqueur)
		(print-item key)
		(print-du item len)))))
      (define (print-string marqueur item)
	 (let ((mark (get-string-mark item)))
	    (cond
	       ((mark-defined? mark)
		(print-marqueur #\#)
		(print-di (mark-ref mark))
		(mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		(if (=fx (mark-ref-count mark) 0)
		    (string-unmark! item)))
	       ((=fx (mark-ref-count mark) 0)
		(string-unmark! item)
		(print-marqueur marqueur)
		(print-ds item (string-length item)))
	       (else
		(let ((ref  (get-new-ref)))
		   (mark-ref-set! mark ref)
		   (mark-defined?-set! mark #t)
		   (print-marqueur #\=)
		   (print-di ref)
		   (print-marqueur marqueur)
		   (print-ds item (mark-old-value mark)))))))
      (define (print-ucs2-string marqueur item)
	 (let ((mark (get-ucs2-string-mark item)))
	    (cond
	       ((mark-defined? mark)
		(print-marqueur #\#)
		(print-di (mark-ref mark))
		(mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		(if (=fx (mark-ref-count mark) 0)
		    (ucs2-string-unmark! item)))
	       ((=fx (mark-ref-count mark) 0)
		(let ((string (mark-ucs2-string->string item)))
		   (ucs2-string-unmark! item)
		   (print-string #\U string)))
	       (else
		(let ((ref    (get-new-ref))
		      (string (mark-ucs2-string->string item)))
		   (mark-ref-set! mark ref)
		   (mark-defined?-set! mark #t)
		   (print-marqueur #\=)
		   (print-di ref)
		   (print-string #\U string))))))
      (define (print-item item)
	 (cond
	    ((object? item)
	     (let ((mark (get-object-mark item)))
		(cond
		   ((mark-defined? mark)
		    (print-marqueur #\#)
		    (print-di (mark-ref mark))
		    (mark-ref-count-set! mark (-fx (mark-ref-count mark) 1))
		    (if (=fx (mark-ref-count mark) 0)
			(object-unmark! item)))
		   ((=fx (mark-ref-count mark) 0)
		    (let ((struct (mark-object->struct item)))
		       (object-unmark! item)
		       (print-struct #\| struct)
		       (print-item (class-hash (object-class item)))))
		   (else
		    (let ((ref    (get-new-ref))
			  (struct (mark-object->struct item)))
		       (mark-ref-set! mark ref)
		       (mark-defined?-set! mark #t)
		       (print-marqueur #\=)
		       (print-di ref)
		       (print-struct #\| struct)
		       (print-item (class-hash (object-class item))))))))
	    ((struct? item)
	     (print-struct #\{ item))
	    ((symbol? item)
	     (cond
		((mark-defined? (get-symbol-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-symbol-mark item)))
		 (mark-ref-count-set! (get-symbol-mark item)
				      (-fx (mark-ref-count
					    (get-symbol-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-symbol-mark item)) 0)
		     (symbol-unmark! item)))
		((=fx (mark-ref-count (get-symbol-mark item)) 0)
		 (symbol-unmark! item)
		 (print-marqueur #\')
		 (let ((s (symbol->string item)))
		    (print-ds s (string-length s))))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-symbol-mark item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\')
		    (let ((s (symbol->string item)))
		       (print-ds s (string-length s)))))))
	    ((keyword? item)
	     (print-marqueur #\:)
	     (let ((s (keyword->string item)))
		(print-ds s (string-length s))))
	    ((char? item)
	     (print-marqueur #\a)
	     (print-di (char->integer item)))
	    ((ucs2? item)
	     (print-marqueur #\u)
	     (print-di (ucs2->integer item)))
	    ((cnst? item)
	     (print-marqueur #\<)
	     (print-di (cnst->integer item)))
	    ((eq? item #f)
	     ;; #f is not bound to be a constant. It can be a special
	     ;; value.
	     (print-marqueur #\F))
	    ((integer? item)
	     (print-di item))
	    ((real? item)
	     (print-marqueur #\f)
	     (print-df item))
	    ((string? item)
	     (print-string #\" item))
	    ((ucs2-string? item)
	     (print-ucs2-string #\U item))
	    ((cell? item)
	     (cond
		((mark-defined? (get-cell-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-cell-mark item)))
		 (mark-ref-count-set! (get-cell-mark item)
				      (-fx (mark-ref-count
					    (get-cell-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-cell-mark item)) 0)
		     (cell-unmark! item)))
		((=fx (mark-ref-count (get-cell-mark item)) 0)
		 (cell-unmark! item)
		 (print-marqueur #\!)
		 (print-item (cell-ref item)))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-cell-mark item))
			tag
			len) 
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\!)
		    (print-item (mark-old-value mark))))))
	    ((pair? item)
	     (cond
		((mark-defined? (get-pair-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-pair-mark item)))
		 (pair-mark-gc! item))
		((=fx (mark-ref-count (get-pair-mark item)) 0)
		 (let ((len (marked-pair-length item)))
		    (print-marqueur #\()
		    (mark-defined?-set! (get-pair-mark item) #t)
		    (print-dl item len)))
		(else
		 (let ((ref  (get-new-ref))
		       (mark (get-pair-mark item))
		       (len  (marked-pair-length item)))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (print-marqueur #\()
		    (print-dl item len)))))
	    ((vector? item)
	     (cond
		((=fx (vector-length item) 0)
		 (let ((tag (vector-tag item)))
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item '() 0))
			(begin
			   (print-marqueur #\[)
			   (print-dv item '() 0)))))
		((mark-defined? (get-vector-mark item))
		 (print-marqueur #\#)
		 (print-di (mark-ref (get-vector-mark item)))
		 (mark-ref-count-set! (get-vector-mark item)
				      (-fx (mark-ref-count
					    (get-vector-mark item))
					   1))
		 (if (=fx (mark-ref-count (get-vector-mark item)) 0)
		     (vector-unmark! item)))
		((=fx (mark-ref-count (get-vector-mark item)) 0)
		 (vector-unmark! item)
		 (let ((tag (vector-tag item)))
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item
				     (vector-ref item 0)
				     (vector-length item)))
			(begin
			   (print-marqueur #\[)
			   (print-dv item
				     (vector-ref item 0)
				     (vector-length item))))))
		(else
		 (let* ((ref  (get-new-ref))
			(mark (get-vector-mark item))
			(tag  (vector-tag item))
			(len  (vector-length item))
			ref0)
		    (begin
		       ;; il faut momentanement restorer le vecteur
		       (vector-set! item 0 (mark-old-value mark))
		       (set! ref0 (vector-ref item 0))
		       ;; on restore
		       (vector-set! item 0 mark))
		    (mark-ref-set! mark ref)
		    (mark-defined?-set! mark #t)
		    (print-marqueur #\=)
		    (print-di ref)
		    (if (>fx tag 0)
			(begin
			   (print-marqueur #\t)
			   (print-di tag)
			   (print-dv item ref0 len))
			(begin
			   (print-marqueur #\[)
			   (print-dv item ref0 len)))))))
	    ((tvector? item)
	     (let ((mark (get-tvector-mark item)))
		(cond
		   ((mark-defined? mark)
		    (print-marqueur #\#)
		    (print-di (mark-ref (get-tvector-mark item)))
		    (mark-ref-count-set! (get-tvector-mark item)
					 (-fx (mark-ref-count
					       (get-tvector-mark item))
					      1))
		    (if (=fx (mark-ref-count (get-tvector-mark item)) 0)
			(tvector-unmark! item)))
		   ((=fx (mark-ref-count mark) 0)
		    (let ((v (mark-tvector->vector item)))
		       (tvector-unmark! item)
		       (print-marqueur #\V)
		       (print-item (tvector-id item))
		       (print-item v)))
		   (else
		    (let* ((ref  (get-new-ref))
			   (len  (tvector-length item))
			   (v    (mark-tvector->vector item))
			   id)
		       (begin
			  ;; il faut momentanement restorer le vecteur
			  (poke! item 2 (mark-old-value mark))
			  (set! id (tvector-id item))
			  ;; on restore
			  (poke! item 2 mark))
		       (mark-ref-set! mark ref)
		       (mark-defined?-set! mark #t)
		       (print-marqueur #\=)
		       (print-di ref)
		       (print-marqueur #\V)
		       (print-item id)
		       (print-item v))))))
	    ((procedure? item)
	     (error "obj->string" "can't extern procedure" item))
	    ((process? item)
	     (error "obj->string" "can't extern process" item))
	    (else
	     (error "obj->string" "Unknown object" item))))
      (set! *string-mark-table*
	    (make-hash-table 1024
			     (lambda (s)
				(get_hash_power_number_from_pointer s 10))
			     car
			     (lambda (x y)
				(pragma::bool "(($1)==($2))" x y))))
      (mark-item! obj)
      (set! *pointeur* 0)
      (if (>fx *nb-ref* 0)
	  (begin
	     (print-marqueur #\c)
	     (print-di *nb-ref*)))
      (print-item obj)
      (set! *string-mark-table* #unspecified)
      (substring buffer 0 *pointeur*)))

;*---------------------------------------------------------------------*/
;*    mark-item! ...                                                   */
;*---------------------------------------------------------------------*/
(define (mark-item! obj)
   (let loop ((obj obj))
      (cond
	 ((object? obj)
	  (if (object-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-object-mark obj)
						   *nb-ref*))
	      (let ((struct (object->struct obj)))
		 (object-mark! obj struct)
		 (loop struct))))
 	 ((struct? obj)
	  (if (struct-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-struct-mark obj)
						   *nb-ref*))
	      (let ((key (struct-key obj))
		    (len (struct-length obj)))
		 ;; on marque la cle
		 (loop key)
		 ;; on marque la structure
		 (struct-mark! obj)
		 (let liip ((i 0))
		    (if (=fx i len)
			'done
			(begin
			   (loop (struct-ref obj i))
			   (liip (+fx i 1))))))))
	 ((pair? obj)
	  (if (pair-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-pair-mark obj)
						   *nb-ref*))
	      (let ((ocar (car obj))
		    (ocdr (cdr obj)))
		 ;; on marque la paire
		 (pair-mark! obj)
		 ;; on l'ecrit
		 (loop ocar)
		 (loop ocdr))))
	 ((cell? obj)
	  (if (cell-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-cell-mark obj)
						   *nb-ref*))
	      (let ((oref (cell-ref obj)))
		 ;; on marque la cellule
		 (cell-mark! obj)
		 ;; on l'ecrit
		 (loop oref))))
	 ((symbol? obj)
	  (if (symbol-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-symbol-mark obj)
						   *nb-ref*))
	      (symbol-mark! obj)))
	 ((keyword? obj)
	  'done)
	 ((real? obj)
	  'done)
	 ((string? obj)
	  (if (string-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-string-mark obj)
						   *nb-ref*))
	      (string-mark! obj)))
	 ((ucs2-string? obj)
	  (if (ucs2-string-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-ucs2-string-mark obj)
						   *nb-ref*))
	      (ucs2-string-mark! obj)))
	 ((vector? obj)
	  (if (=fx (vector-length obj) 0)
	      'done
	      (if (vector-marked? obj)
		  (set! *nb-ref* (incr-mark-ref-count! (get-vector-mark obj)
						       *nb-ref*))
		  (let ((len (vector-length obj))
			(tag (vector-tag obj)))
		     (loop (vector-ref-ur obj 0))
		     (vector-mark! obj)
		     (let liip ((i 1))
			(if (>=fx i len)
			    'done
			    (begin
			       (loop (vector-ref-ur obj i))
			       (liip (+fx i 1)))))))))
	 ((tvector? obj)
	  (if (tvector-marked? obj)
	      (set! *nb-ref* (incr-mark-ref-count! (get-vector-mark obj)
						   *nb-ref*))
	      (let ((v (tvector->vector obj)))
		 (loop (tvector-id obj))
		 (loop v)
		 (tvector-mark! obj v))))
	 ((not (pointer? obj))
	  'done)
	 ((pointer-marked? obj) 
	  (set! *nb-ref* (incr-mark-ref-count! (get-pointer-mark obj)
					       *nb-ref*)))
	 (else
	  'done))))

;*---------------------------------------------------------------------*/
;*    marked-pair-length ...                                           */
;*---------------------------------------------------------------------*/
(define (marked-pair-length l)
   (let loop ((l l)
	      (r 1))
      (let* ((mark (get-pair-mark l))
	     (vcdr (mark-old-value mark)))
	 (if (pair? vcdr)
	     (let ((mark (get-pair-mark vcdr)))
		(if (or (> (mark-ref-count mark) 0)
			(mark-defined? mark))
		    (+fx r 1)
		    (loop vcdr (+fx r 1))))
	     (+fx r 1)))))
