;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Rgc/runtime.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar 26 08:42:14 1995                          */
;*    Last change :  Sat Feb 14 17:38:48 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The regular grammar runtime.                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc

   (import  (__error                   "Llib/error.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__evenv                   "Eval/evenv.scm"))
 
   (foreign (macro obj c-input-port-ajust-cursor       (obj)
		   "INPUT_PORT_AJUST_CURSOR")
	    (macro obj c-input-port-reset-annexe!      (input-port)
		   "INPUT_PORT_RESET_ANNEXE")
	    (obj c-input-port-get-string               (obj)
		 "input_port_get_string")
	    (obj c-input-port-get-small-string         (obj)
		 "input_port_get_small_string")
	    (obj c-input-port-get-symbol               (obj)
		 "input_port_get_symbol")
	    (obj c-input-port-get-keyword              (obj)
		 "input_port_get_keyword")
	    (macro long c-input-port-get-length        (obj)
		   "INPUT_PORT_GET_LENGTH")
	    (obj c-input-port-get-fixnum               (obj)
		 "input_port_get_fixnum")
	    (obj c-input-port-get-flonum               (obj)
		 "input_port_get_flonum")
	    (macro obj c-input-port-steal-char         (obj)
		   "INPUT_PORT_STEAL_CHAR")
	    (bool c-input-port-fill-buffer             (obj)
		  "input_port_fill_buffer")
	    (macro obj c-input-port-throw-char         (obj long)
		   "INPUT_PORT_THROW_CHAR")
	    (macro int c-input-port-read-char          (obj)
		   "INPUT_PORT_READ_CHAR")
	    (macro int c-input-port-unread-char        (obj)
		   "INPUT_PORT_UNREAD_CHAR")	   
	    (macro obj c-input-port-remember-back-ref  (obj)
		   "INPUT_PORT_REMEMBER_BACK_REF")
	    (macro obj c-input-port-remember-ref       (obj)
		   "INPUT_PORT_REMEMBER_REF") 
	    (macro bool c-input-port-eof?              (obj) 
		   "INPUT_PORT_EOFP")
	    (macro bool c-input-port-eol?              (obj)
		   "INPUT_PORT_EOLP")
	    (macro bool c-input-port-bol?              (obj)
		   "INPUT_PORT_BOLP")
	    (bstring c-input-port-read-string          (obj int)
		     "intput_port_read_string")
	    (obj c-input-port-display-error            (input-port output-port)
		 "input_port_display_error")
	    (macro bool c-input-port-token-too-large?  (obj)
		   "INPUT_PORT_TOKEN_TOO_LARGEP")
	    (obj c-input-port-debug                    (obj obj)
		 "input_port_debug")
	    (macro bstring c-input-port-name           (input-port)
		   "INPUT_PORT_NAME")
	    (macro long c-input-port-filepos           (input-port)
		   "INPUT_PORT_FILEPOS")
	    (macro bool c-input-port-on-file?          (input-port)
		   "INPUT_PORT_ON_FILEP")
	    (macro bool c-input-port-on-string?        (input-port)
		   "INPUT_PORT_ON_STRINGP")
	    (macro string input-port-buffer            (input-port)
		   "BUFFER")
	    
	    (infix macro bool c-rgc-=?  (int int) "==")
	    (infix macro bool c-rgc-<?  (int int) "<")
	    (infix macro bool c-rgc-<=? (int int) "<=")
	    (infix macro bool c-rgc->?  (int int) ">")
	    (infix macro bool c-rgc->=? (int int) ">="))
   
   (export  (inline input-port-ajust-cursor              ::input-port)
	    (inline input-port-reset-annexe!             ::input-port)
	    (inline input-port-get-string::bstring       ::input-port)
	    (inline input-port-get-small-string::bstring ::input-port)
	    (inline input-port-get-keyword::keyword      ::input-port)
	    (inline input-port-get-symbol::symbol        ::input-port)
	    (inline input-port-get-fixnum::bint          ::input-port)
	    (inline input-port-get-flonum::real          ::input-port)
	    (inline input-port-get-length::long          ::input-port)
	    (inline input-port-steal-char                ::input-port)
	    (inline input-port-fill-buffer::bool         ::input-port)
	    (inline input-port-throw-char                ::input-port ::long)
	    (inline input-port-read-char::int            ::input-port)
	    (inline input-port-remember-ref              ::input-port)
	    (inline input-port-remember-back-ref         ::input-port)
	    (inline input-port-eof?::bool                ::input-port)
	    (inline input-port-eol?::bool                ::input-port)
	    (inline input-port-bol?::bool                ::input-port)
	    (inline input-port-display-error        ::input-port ::output-port)
	    (inline input-port-name::bstring             ::input-port)
	    (inline input-port-filepos::long             ::input-port)
	    (inline rgc-=?::bool                         ::int ::int)
	    (inline rgc-<?::bool                         ::int ::int)
	    (inline rgc-<=?::bool                        ::int ::int)
	    (inline rgc->?::bool                         ::int ::int)
	    (inline rgc->=?::bool                        ::int ::int)
	    (inline input-port-token-too-large?::bool    ::input-port)

	    *rgc-last-char* 
	    *rgc-first-char*
	    *rgc-compact*
	    *rgc-optim*))

;*---------------------------------------------------------------------*/
;*    Default Rgc parameters                                           */
;*---------------------------------------------------------------------*/
(define *rgc-last-char*     255)
(define *rgc-first-char*    1)
(define *rgc-compact*       50)
(define *rgc-optim*         #f)

;*---------------------------------------------------------------------*/
;*    input-port-ajust-cursor ...                                      */
;*    -------------------------------------------------------------    */
;*    Cette fonction trippote tous les curseurs (`forward', `backward' */
;*    et `remember').                                                  */
;*---------------------------------------------------------------------*/
(define-inline (input-port-ajust-cursor input-port)
   (c-input-port-ajust-cursor input-port))

;*---------------------------------------------------------------------*/
;*    input-port-reset-annexe! ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (input-port-reset-annexe! input-port)
   (c-input-port-reset-annexe! input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-string ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une string `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `mark' et `backward'     */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-string input-port)
   (c-input-port-get-string input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-small-string ...                                  */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une string `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `mark' + 1 et            */
;*    `backward' - 1. Le decalage est la pour supprimer les '"' tapes  */
;*    par l'utilisateur lors d'une lecture.                            */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-small-string input-port)
   (c-input-port-get-small-string input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-symbol ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une symbol `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `backward' et            */
;*    `remember'                                                       */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-symbol input-port)
   (c-input-port-get-symbol input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-keyword ...                                       */
;*    -------------------------------------------------------------    */
;*    Cette fonction retourne une symbol `bigloo' qui est extraite     */
;*    du buffer du lecteur entre les curseurs `backward' et            */
;*    `remember'                                                       */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-keyword input-port)
   (c-input-port-get-keyword input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-fixnum ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-fixnum input-port)
   (c-input-port-get-fixnum input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-flonum ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-flonum input-port)
   (c-input-port-get-flonum input-port))

;*---------------------------------------------------------------------*/
;*    input-port-get-length ...                                        */
;*    -------------------------------------------------------------    */
;*    Quasiment idem a ci-dessus mais on retourne un int qui est la    */
;*    difference entre les curseurs                                    */
;*---------------------------------------------------------------------*/
(define-inline (input-port-get-length input-port)
   (c-input-port-get-length input-port))

;*---------------------------------------------------------------------*/
;*    input-port-steal-char ...                                        */
;*    -------------------------------------------------------------    */
;*    Cette fonction permet de supprimer le char du buffer qui est     */
;*    pointe par `backward'                                            */
;*---------------------------------------------------------------------*/
(define-inline (input-port-steal-char input-port)
   (c-input-port-steal-char input-port))

;*---------------------------------------------------------------------*/
;*    input-port-remember-ref ...                                      */
;*---------------------------------------------------------------------*/
(define-inline (input-port-remember-ref input-port)
   (c-input-port-remember-ref input-port))

;*---------------------------------------------------------------------*/
;*    input-port-remember-back-ref ...                                 */
;*---------------------------------------------------------------------*/
(define-inline (input-port-remember-back-ref input-port)
   (c-input-port-remember-back-ref input-port))

;*---------------------------------------------------------------------*/
;*    input-port-fill-buffer ...                                       */
;*---------------------------------------------------------------------*/
(define-inline (input-port-fill-buffer input-port)
   (if (procedure? *about-to-read*)
       (*about-to-read* input-port))
   (c-input-port-fill-buffer input-port))

;*---------------------------------------------------------------------*/
;*    input-port-throw-char ...                                        */
;*---------------------------------------------------------------------*/
(define-inline (input-port-throw-char input-port n)
   (c-input-port-throw-char input-port n))

;*---------------------------------------------------------------------*/
;*    input-port-read-char ...                                         */
;*    input-port --> int                                               */
;*---------------------------------------------------------------------*/
(define-inline (input-port-read-char input-port)
   (c-input-port-read-char input-port))

;*---------------------------------------------------------------------*/
;*    input-port-eof? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-eof? input-port)
   (c-input-port-eof? input-port))

;*---------------------------------------------------------------------*/
;*    input-port-eol? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-eol? input-port)
   (c-input-port-eol? input-port))
 
;*---------------------------------------------------------------------*/
;*    input-port-bol? ...                                              */
;*    input-port --> { t, f }                                          */
;*---------------------------------------------------------------------*/
(define-inline (input-port-bol? input-port)
   (c-input-port-bol? input-port))

;*---------------------------------------------------------------------*/
;*    input-port-debug ...                                             */
;*---------------------------------------------------------------------*/
(define (input-port-debug input-port . file)
   (if (null? file)
       (c-input-port-debug input-port (current-output-port))
       (c-input-port-debug input-port (car file))))

;*---------------------------------------------------------------------*/
;*    input-port-display-error ...                                     */
;*---------------------------------------------------------------------*/
(define-inline (input-port-display-error ip op)
   (c-input-port-display-error ip op))

;*---------------------------------------------------------------------*/
;*    input-port-name ...                                              */
;*---------------------------------------------------------------------*/
(define-inline (input-port-name input-port)
   (c-input-port-name input-port))

;*---------------------------------------------------------------------*/
;*    input-port-filepos ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (input-port-filepos input-port)
   (c-input-port-filepos input-port))

;*---------------------------------------------------------------------*/
;*    rgc-=? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc-=? a b)
   (c-rgc-=? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc-<? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc-<? a b)
   (c-rgc-<? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc-<=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (rgc-<=? a b)
   (c-rgc-<=? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc->? ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (rgc->? a b)
   (c-rgc->? a b))
   
;*---------------------------------------------------------------------*/
;*    rgc->=? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (rgc->=? a b)
   (c-rgc->=? a b))
   
;*---------------------------------------------------------------------*/
;*    input-port-token-too-large? ...                                  */
;*---------------------------------------------------------------------*/
(define-inline (input-port-token-too-large? obj)
   (c-input-port-token-too-large? obj))
 
