/* file: "gambit.h" */

/*
 * Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.
 */

#ifndef ___GAMBIT_H
#define ___GAMBIT_H

#ifndef ___VERSION
@error "___VERSION has not been set by includer"
#endif

#if ___VERSION != 21
@error "Incompatible version of gambit.h include file"
#endif

/*---------------------------------------------------------------------------*/

/*
 * DETERMINE PROGRAMMING ENVIRONMENT'S CHARACTERISTICS
 *
 * The following symbols need to be defined to reflect the
 * programming environment's characteristics:
 *
 *  define one of the following symbols depending on the processor type
 *    ___CPU_alpha     DEC Alpha AXP processor
 *    ___CPU_hppa      HP PA-RISC processor
 *    ___CPU_m68k      Motorola 68k family processor
 *    ___CPU_mips      MIPS Rx000 family processor
 *    ___CPU_ppc       PowerPC processor
 *    ___CPU_rs6k      IBM RS6000 processor
 *    ___CPU_sony_news Christian Queinnec's processor!
 *    ___CPU_sparc     SUN SPARC processor
 *    ___CPU_x86       Intel x86 family processor
 *
 *  define ___CPU_BIGEND if integers are stored in "big-endian" format
 *  define ___CPU_LITEND if integers are stored in "little-endian" format
 *
 *  define ___FORCE_32 to force the use of 32 bit words even if 64 bit
 *            words are available
 *
 *  define ___SCHAR to "char" if the C compiler does not support
 *            signed characters (e.g. SunOS 4.1 cc).
 *
 *  define ___IMPORTED_ID_PREFIX to the prefix that the C compiler puts on
 *            imported functions (for example "_" if an underscore is needed)
 *  define ___IMPORTED_ID_SUFFIX to the suffix that the C compiler puts on
 *            imported functions
 *
 *  define ___o as the extension for object files (e.g. "o", "obj")
 *  define ___CC_O as the command that compiles a C file to an object file
 *  define ___CC_O_SH like ___CC_O except that object file is for a shared lib
 *  define ___CLIBS as the libraries to use (e.g. "-lm", "-ldl")
 *  define ___CC_CMD as the command that invokes the C compiler for a
 *            dynamic Scheme compilation
 *  define ___LD_CMD as the command that invokes the linker for a
 *            dynamic Scheme compilation
 *  define ___LD_FLIP to flip the two arguments to the linker
 *  define ___CANT_IMPORT_CLIB_DYNAMICALLY if the dynamic loader can not load
 *            files that import C library functions such as "sqrt"
 *  define ___CANT_IMPORT_SETJMP_DYNAMICALLY if the dynamic loader can not load
 *            files that use "setjmp"
 *  define ___CANT_IMPORT_DYNAMICALLY if the dynamic loader can not load
 *            files that import functions defined in other files
 *  define ___CANT_IMPORT_EXPORTED if exported data/functions in an
 *            executable/library can't be imported in that executable/library
 *  define ___IMPORTED_ADR_NOT_CONST if address-of operator (&) applied to
 *            imported data/functions can't be used in a constant initializer
 *  define ___SETDLPATH as the variable definition that sets up the path
 *            to search for shared libraries in "../lib"
 *  define ___USE_ISNAN if the test "x!=x" does not return true when x
 *            is a NaN
 */

#define ___FORCE_32  /* remove this line to use 64 bit words if available */

#ifdef sparc
#ifndef __linux__
#define ___CPU_sparc
#define ___CPU_BIGEND
#ifdef __SVR4
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fPIC -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "gcc -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#else
#define ___CC_O "cc -xO1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "cc -Kpic -xO1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "cc -G -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cc -Kpic -xO1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#endif
#define ___CLIBS "-lm -ldl"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so.1.1"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___LD_CMD "/usr/ccs/bin/ld -G %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#else
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#else
#define ___CC_O "cc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___CC_CMD "cc -pic -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___SCHAR char
#endif
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___LD_CMD "/usr/bin/ld %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif
#endif
#endif

#ifdef sgi
#define ___CPU_mips
#define ___CPU_BIGEND
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "gcc -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#else
#define ___CC_O "cc -OPT:IEEE_comparisons=ON -c \$(CC_O_ARGS)"
#define ___CC_O_SH "cc -OPT:IEEE_comparisons=ON -c \$(CC_O_SH_ARGS)"
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "cc -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cc -OPT:IEEE_comparisons=ON -c -D___DYNAMIC -o %s.o %s.c"
#endif
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___LD_CMD "/usr/bin/ld -shared %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib LD_LIBRARYN32_PATH=../lib LD_LIBRARY64_PATH=../lib"
#endif

#ifdef __alpha
#define ___CPU_alpha
#define ___CPU_LITEND
#undef __GNUC__
#ifdef ___FORCE_32
#define ___WORD_IS_SMALLER_THAN_POINTERS
#undef __GNUC__
#define ___o "o"
#define ___CC_O "cc -w -ieee -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "cc -w -ieee -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc -taso -call_shared \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cc -taso -call_shared \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cc -taso -call_shared \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "cc -taso -shared -call_shared -expect_unresolved \\* -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cc -w -ieee -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/bin/ld -taso -shared -expect_unresolved \\* %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#else
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "gcc -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#else
#define ___CC_O "cc -ieee -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "cc -ieee -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc -call_shared \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cc -call_shared \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cc -call_shared \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "cc -shared -call_shared -expect_unresolved \\* -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cc -ieee -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#endif
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___LD_CMD "/usr/bin/ld -shared -expect_unresolved \\* %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif
#endif

#ifdef hpux
#ifdef __hp9000s300
#define ___CPU_m68k
#define ___CPU_BIGEND
#endif
#ifdef __hppa
#define ___CPU_hppa
#define ___CPU_BIGEND
#endif
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fPIC -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "gcc -shared -fPIC -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#else
#define ___CC_O "cc +O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "cc +z +O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___MAKE_GAMBCLIB_SH "/bin/ld -b -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cc +z -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___SCHAR char
#endif
#define ___CLIBS "-lm -ldld"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.sl"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___LD_CMD "/bin/ld -b %s.o -lm -o %s"
#define ___CANT_IMPORT_DYNAMICALLY
#define ___SETDLPATH "SHLIB_PATH=../lib"
#endif

#ifdef _AIX
#define ___CPU_rs6k
#define ___CPU_BIGEND
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#else
#define ___CC_O "cc -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___SETDLPATH "LIBPATH=../lib"
#endif

#ifdef sony_news
#define ___CPU_sony_news
#define ___CPU_BIGEND
#define ___o "o"
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/ccs/bin/ld -G %s.o -o %s"
#define ___CANT_IMPORT_DYNAMICALLY
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif

#ifdef __linux__using_gplusplus
#ifdef __i386__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___LINK "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#ifdef __sparc__
#define ___CPU_sparc
#define ___CPU_BIGEND
#define ___LINK "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS -L../lib -lgambc -\$(CLIBS) o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "g++ -fhandle-exceptions -rdynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#ifdef __powerpc__
#define ___CPU_ppc
#define ___CPU_BIGEND
#define ___LINK "g++ -fhandle-exceptions -export-dynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "g++ -fhandle-exceptions -export-dynamic \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "g++ -fhandle-exceptions -export-dynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#define ___o "o"
#define ___CC_O "g++ -fhandle-exceptions -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "g++ -fhandle-exceptions -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___CLIBS "-lm -ldl"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "g++ -fhandle-exceptions -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "g++ -fhandle-exceptions -fPIC -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/bin/ld -shared %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif

#ifdef __linux__
#ifdef __i386__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___LINK "gcc -rdynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc -rdynamic \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc -rdynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#ifdef __sparc__
#define ___CPU_sparc
#define ___CPU_BIGEND
#define ___LINK "gcc -rdynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc -rdynamic \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc -rdynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#ifdef __powerpc__
#define ___CPU_ppc
#define ___CPU_BIGEND
#define ___LINK "gcc -export-dynamic \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc -export-dynamic \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc -export-dynamic \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#define ___o "o"
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___CLIBS "-lm -ldl"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "gcc -shared -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/bin/ld -shared %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif

#ifdef __NetBSD__
#ifdef i386
#define ___CPU_x86
#define ___CPU_LITEND
#define ___IMPORTED_ID_PREFIX "_"
#define ___o "o"
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so.1.1"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "ld -Bshareable -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/bin/ld -Bshareable %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif
#endif

#ifdef __FreeBSD__
#ifdef i386
#define ___CPU_x86
#define ___CPU_LITEND
#define ___IMPORTED_ID_PREFIX "_"
#define ___o "o"
#define ___CC_O "gcc -O1 -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "gcc -fpic -O1 -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "gcc \\\$\$OBJECTS -L../lib -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "gcc \\\$\$OBJECTS -L\$(libdir) -lgambc \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___GAMBCLIB_SH "libgambc.so.1.1"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "ld -Bshareable -o \$(GAMBCLIB_SH) \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "gcc -fPIC -O1 -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "/usr/bin/ld -Bshareable %s.o -o %s"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif
#endif

#ifdef __DJGPP__
#ifdef __i386__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___o "o"
#define ___CC_O "gcc -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "-lm -lemu"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___CC_CMD "gcc -c -D___DYNAMIC -D___SINGLE_HOST -o %s.o %s.c"
#define ___LD_CMD "dxegen %s ____linker %s.o"
#define ___LD_FLIP
#define ___SETDLPATH ""
#define ___CANT_IMPORT_DYNAMICALLY
#ifdef ___DYNAMIC
#undef ___LINKER_ID
#define ___LINKER_ID ___linker
#endif
#define ___CANT_IMPORT_CLIB_DYNAMICALLY
#define ___CANT_IMPORT_SETJMP_DYNAMICALLY
#endif
#endif

#ifdef _MSC_VER
#ifndef __MWERKS__
#if _MSC_VER < 1000
#ifdef _M_I86
#define ___CPU_x86
#define ___CPU_LITEND
#define ___EXPORT_FUNC(type,name)__declspec(dllexport) type name
#define ___EXPORT_DATA(type,name)__declspec(dllexport) type name
#define ___IMPORT_FUNC(type,name)__declspec(dllimport) type name
#define ___IMPORT_DATA(type,name)__declspec(dllimport) type name
#define ___o "obj"
#define ___CC_O "cl -W0 -AH -Oitb1 -G3s \$(CFLAGS) -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "cl \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS ""
#define ___GAMBCLIB "libgambc.lib"
#define ___GAMBCLIB_SH "gambc.lib"
#define ___MAKE_GAMBCLIB "lib -out:\$(GAMBCLIB) \\\$\$OBJECTS"
#define ___MAKE_GAMBCLIB_SH "link -dll \$(LFLAGS) -out:gambc.dll \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cl -W0 -AH -Oitb1 -G3s -D___DYNAMIC -D___SINGLE_HOST -c -Fo%s.obj %s.c"
#define ___LD_CMD "link -noentry -dll %s.obj -out:%s"
#define ___SETDLPATH "OLDPATH=\"\$\$PATH\" PATH=\"\$\$OLDPATH;..\\\\\\\\lib\""
#define ___CANT_IMPORT_DYNAMICALLY
#define ___IMPORTED_ADR_NOT_CONST
#define ___USE_ISNAN
#endif
#else
#ifdef _M_IX86
#define ___CPU_x86
#define ___CPU_LITEND
#define ___EXPORT_FUNC(type,name)__declspec(dllexport) type name
#define ___EXPORT_DATA(type,name)__declspec(dllexport) type name
#define ___IMPORT_FUNC(type,name)__declspec(dllimport) type name
#define ___IMPORT_DATA(type,name)__declspec(dllimport) type name
#define ___o "obj"
#define ___CC_O "cl -nologo -Oityb1 -G5s -MD \$(CFLAGS) -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "cl -nologo -Oityb1 -G5s -MD \$(CFLAGS) -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "cl -nologo \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#define ___LINK_SH "cl -nologo \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH) -o \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "cl -nologo \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH) -o \\\$\$EXECUTABLE"
#define ___CLIBS ""
#define ___GAMBCLIB "libgambc.lib"
#define ___GAMBCLIB_SH "gambc.lib"
#define ___MAKE_GAMBCLIB "lib -out:\$(GAMBCLIB) \\\$\$OBJECTS"
#define ___MAKE_GAMBCLIB_SH "link -nologo -dll \$(LFLAGS) -out:gambc.dll \\\$\$OBJECTS \$(CLIBS)"
#define ___CC_CMD "cl -nologo -Oityb1 -G5s -MD -D___DYNAMIC -D___SINGLE_HOST -c -Fo%s.obj %s.c"
#define ___LD_CMD "link -nologo -noentry -dll %s.obj -out:%s"
#define ___SETDLPATH "OLDPATH=\"\$\$PATH\" PATH=\"\$\$OLDPATH;..\\\\\\\\lib\""
#define ___CANT_IMPORT_DYNAMICALLY
#define ___IMPORTED_ADR_NOT_CONST
#define ___USE_ISNAN
#endif
#endif
#endif
#endif

#ifdef __BORLANDC__
#ifdef _M_IX86
#define ___CPU_x86
#define ___CPU_LITEND
#define ___EXPORT_FUNC(type,name)type __export name
#define ___EXPORT_DATA(type,name)type __export name
#define ___IMPORT_FUNC(type,name)type __import name
#define ___IMPORT_DATA(type,name)type __import name
#define ___IMPORTED_ID_PREFIX "_"
#define ___o "obj"
#define ___CC_O "bcc32 -w- -O2 -a4 -tWM \$(CFLAGS) -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH "bcc32 -w- -O2 -a4 -tWM \$(CFLAGS) -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "bcc32 -e\\\$\$EXECUTABLE \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS)"
#define ___LINK_SH "bcc32 -e\\\$\$EXECUTABLE \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH)"
#define ___LINK_SH_INSTALL "bcc32 -e\\\$\$EXECUTABLE \$(LFLAGS) \\\$\$OBJECTS ../lib/\$(GAMBCLIB_SH)"
#define ___CLIBS ""
#define ___GAMBCLIB "libgambc.lib"
#define ___GAMBCLIB_SH "gambc.lib"
#define ___MAKE_GAMBCLIB "tlib \$(GAMBCLIB) /p32 \\\$\$OBJECTS_PLUS"
#define ___MAKE_GAMBCLIB_SH "tlink32 -Tpd \$(LFLAGS) c0d32.obj \\\$\$OBJECTS, gambc.dll, , import32 cw32mti ; implib \$(GAMBCLIB_SH) gambc.dll"
#define ___CC_CMD "bcc32 -w- -O2 -a4 -tWM -D___DYNAMIC -D___SINGLE_HOST -c -o%s.obj %s.c"
#define ___LD_CMD "tlink32 -Tpd c0d32.obj %s.obj, %s, , import32 cw32mti"
#define ___SETDLPATH "OLDPATH=\"\$\$PATH\" PATH=\"\$\$OLDPATH;..\\\\\\\\lib\""
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#define ___IMPORTED_ADR_NOT_CONST
#define ___USE_ISNAN
#endif
#endif

#ifdef __WATCOMC__
#ifdef __386__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___EXPORT_FUNC(type,name)__declspec(dllexport) type name
#define ___EXPORT_DATA(type,name)__declspec(dllexport) type name
#define ___IMPORT_FUNC(type,name)__declspec(dllimport) type name
#define ___IMPORT_DATA(type,name)__declspec(dllimport) type name
#define ___IMPORTED_ID_SUFFIX "_"
#define ___o "obj"
#define ___CC_O "wcl386 -w0 -obetir -zp4 -s -5r -fp5 -bm -bt=nt -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___CC_O_SH_BROKEN "wcl386 -w0 -obetir -zp4 -s -5r -fp5 -bm -bt=nt -bd -br -c \$(CC_O_SH_ARGS) -D___SINGLE_HOST"
#define ___LINK "wlink option stack=16384 system nt file \\\$\$OBJECTS_COMMA library ..\\\\\\\\lib\\\\\\\\\$(GAMBCLIB),\$(CLIBS) name \\\$\$EXECUTABLE"
#define ___LINK_SH "wlink option stack=16384 system nt file \\\$\$OBJECTS_COMMA library ..\\\\\\\\lib\\\\\\\\\$(GAMBCLIB_SH),\$(CLIBS) name \\\$\$EXECUTABLE"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "kernel32,user32"
#define ___GAMBCLIB "libgambc.lib"
#define ___GAMBCLIB_SH "gambc.lib"
#define ___MAKE_GAMBCLIB "wlib -n -p=32 \$(GAMBCLIB) \\\$\$OBJECTS_PLUS"
#define ___MAKE_GAMBCLIB_SH "wlink option stack=16384 system nt_dll file \\\$\$OBJECTS_COMMA library \$(CLIBS),mthrdll name gambc.dll;wlib -n -p=32 \$(GAMBCLIB_SH) +gambc.dll"
#define ___CC_CMD "wcl386 -w0 -obetir -zp4 -s -5r -fp5 -bm -bt=nt -bd -br -D___DYNAMIC -D___SINGLE_HOST -c -fo=%s.obj %s.c"
#define ___LD_CMD "wlink option stack=16384 system nt_dll file %s.obj name %s"
#define ___SETDLPATH "OLDPATH=\"\$\$PATH\" PATH=\"\$\$OLDPATH;..\\\\\\\\lib\""
#define ___CANT_IMPORT_CLIB_DYNAMICALLY
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#define ___USE_ISNAN
#endif
#endif

#ifdef __MACHTEN__
#ifdef __MACHTEN_PPC__
#define ___CPU_ppc
#define ___CPU_BIGEND
#define ___LINK "cc -Xlstack=300000 \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#else
#define ___CPU_m68k
#define ___LINK "cc \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___o "o"
#define ___CC_O "cc -c \$(CC_O_ARGS)"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif

#ifdef NeXT
#ifdef i386
#define ___CPU_x86
#define ___CPU_LITEND
#else
#define ___CPU_m68k
#define ___CPU_BIGEND
#endif
#define ___o "o"
#ifdef __GNUC__
#define ___CC_O "gcc -posix -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "gcc -posix \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#else
#define ___CC_O "cc -posix -c \$(CC_O_ARGS) -D___SINGLE_HOST"
#define ___LINK "cc -posix \\\$\$OBJECTS ../lib/\$(GAMBCLIB) \$(CLIBS) -o \\\$\$EXECUTABLE"
#endif
#define ___LINK_SH "echo"
#define ___LINK_SH_INSTALL "echo"
#define ___CLIBS "-lm"
#define ___GAMBCLIB "libgambc.a"
#define ___MAKE_GAMBCLIB "ar rc \$(GAMBCLIB) \\\$\$OBJECTS;ranlib \$(GAMBCLIB)"
#define ___MAKE_GAMBCLIB_SH "echo"
#define ___SETDLPATH "LD_LIBRARY_PATH=../lib"
#endif

#ifdef __MWERKS__
#ifdef __INTEL__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___SINGLE_HOST
#define ___EXPORT_FUNC(type,name)__declspec(dllexport) type name
#define ___EXPORT_DATA(type,name)__declspec(dllexport) type name
#define ___IMPORT_FUNC(type,name)__declspec(dllimport) type name
#define ___IMPORT_DATA(type,name)__declspec(dllimport) type name
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#else
#ifdef __POWERPC__
#define ___CPU_ppc
#define ___SINGLE_HOST
#define ___CPU_BIGEND
#if __MWERKS__ == 0x1100
#define ___CC_CMD "~~:compile-file.cw11"
#else
#if __MWERKS__ == 0x1800
#define ___CC_CMD "~~:compile-file.cwpro1"
#else
#if __MWERKS__ == 0x2000
#define ___CC_CMD "~~:compile-file.cwpro2"
#else
#if __MWERKS__ == 0x2100
#define ___CC_CMD "~~:compile-file.cwpro3"
#else
#define ___CC_CMD "~~:compile-file.cwpro4"
#endif
#endif
#endif
#endif
#else
#define ___CPU_m68k
#define ___CPU_BIGEND
#endif
#define ___EXPORT_FUNC(type,name)__declspec(export) type name
#define ___EXPORT_DATA(type,name)__declspec(export) type name
#define ___IMPORT_FUNC(type,name)__declspec(import) type name
#define ___IMPORT_DATA(type,name)__declspec(import) type name
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#endif
#if __option (warn_illpragma)
#define ___PRIMAL
#endif
#if __option (warn_unusedarg)
#define ___LIBRARY
#endif
#if __option (warn_extracomma)
#define ___SHARED
#endif
#if __option (warn_emptydecl)
#define ___DYNAMIC
#endif
#endif

#ifdef __MINGW32__
#define ___CPU_x86
#define ___CPU_LITEND
#ifdef __ONLY_FOR_EXPORT__
#define ___EXPORT(type,name)EXPORTED: name :END
#define ___IMPORT(type,name)IMPORTED: name :END
#else
#define ___EXPORT(type,name)type name
#define ___IMPORT(type,name)extern type name
#endif
#define ___o "o"
#define ___CC_CMD "gambc-compile.cmd %s %s"
#define ___LD_CMD "gambc-link.cmd %s %s"
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#endif

#ifdef __EMX__
#define ___CPU_x86
#define ___CPU_LITEND
#define ___EXPORT(type,name)type name
#define ___IMPORT(type,name)extern type name
#define ___o "o"
#define ___CC_CMD "gambc-compile.cmd %s %s"
#define ___LD_CMD "gambc-link.cmd %s %s"
#define ___CANT_IMPORT_DYNAMICALLY
#define ___CANT_IMPORT_EXPORTED
#endif

/*---------------------------------------------------------------------------*/

/*
 * DETERMINE C COMPILER'S CHARACTERISTICS
 *
 * The following symbols need to be defined to reflect the
 * C compiler's characteristics:
 *
 *  define ___I16 as the integer type of exactly 16 bits
 *  define ___I32 as the integer type of exactly 32 bits
 *  define ___I64 as the integer type of exactly 64 bits (only if one exists)
 *  define ___F32 as the floating-point type of exactly 32 bits
 *  define ___F64 as the floating-point type of exactly 64 bits
 */

#ifdef ___CPU_alpha
#define ___I16 short
#define ___I32 int
#define ___I64 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_hppa
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_m68k
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_mips
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_sony_news
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_sparc
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_ppc
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_rs6k
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef ___CPU_x86
#define ___I16 short
#define ___I32 long
#define ___F32 float
#define ___F64 double
#endif

#ifdef __GNUC__
#ifndef ___I64
#define ___I64 long long
#endif
#endif

#ifndef ___SCHAR
#define ___SCHAR signed char
#endif


/*---------------------------------------------------------------------------*/

/* SANITY CHECKS AND SETTING OF DEFAULT OPTIONS */

/*
 * Verify that processor type is known.
 */

#ifndef ___I16
@error "___I16 must be defined"
#endif

#ifndef ___I32
@error "___I32 must be defined"
#endif

#ifndef ___F32
@error "___F32 must be defined"
#endif

#ifndef ___F64
@error "___F64 must be defined"
#endif

#ifdef ___CPU_BIGEND
#ifdef ___CPU_LITEND
@error "Either ___CPU_BIGEND or ___CPU_LITEND must be defined"
#endif
#else
#ifndef ___CPU_LITEND
@error "Either ___CPU_BIGEND or ___CPU_LITEND must be defined"
#endif
#endif

/*
 * Generate a single host procedure or multiple C host
 * procedures (default) per Scheme module?
 */

#ifdef ___SINGLE_HOST
#ifdef ___MULTIPLE_HOSTS
@error "Define either ___SINGLE_HOST or ___MULTIPLE_HOSTS"
#endif
#else
#ifndef ___MULTIPLE_HOSTS
#define ___MULTIPLE_HOSTS
#endif
#endif

/*
 * Compiling for dynamic loading or not (default).
 */

#ifdef ___DYNAMIC
#ifdef ___NON_DYNAMIC
@error "Define either ___DYNAMIC or ___NON_DYNAMIC"
#endif
#else
#ifndef ___NON_DYNAMIC
#define ___NON_DYNAMIC
#endif
#endif

/*
 * Define symbols appropriate for dynamic loading.
 */

#ifdef ___DYNAMIC
#undef ___PRIMAL
#define ___PRIMAL
#undef ___LIBRARY
#define ___LIBRARY
#undef ___SHARED
#define ___SHARED
#undef ___BIND_LATE
#define ___BIND_LATE
#endif

/*
 * Compiling to produce a library or an application with a "main" (default
 * unless compiling a flat link file).
 */

#ifdef ___LIBRARY
#ifdef ___APPLICATION
@error "Define either ___LIBRARY or ___APPLICATION"
#endif
#else
#ifndef ___APPLICATION
#ifdef ___FLAT_LINKFILE
#define ___LIBRARY
#else
#define ___APPLICATION
#endif
#endif
#endif

/*
 * Compiling to produce a shared-library or not (default).
 */

#ifdef ___SHARED
#ifdef ___NON_SHARED
@error "Define either ___SHARED or ___NON_SHARED"
#endif
#else
#ifndef ___NON_SHARED
#define ___NON_SHARED
#endif
#endif

/* 
 * Select binding time for global variables, symbols, and keywords.
 * Early binding (default) produces faster code because it directly
 * accesses the resource.  Late binding does an indirection at run
 * time.
 */

#ifdef ___BIND_LATE
#ifdef ___BIND_EARLY
@error "Define either ___BIND_LATE or ___BIND_EARLY"
#endif
#else
#ifndef ___BIND_EARLY
#define ___BIND_EARLY
#endif
#endif

/*
 * Size in bytes of characters in Scheme strings.
 *
 * ___CS must be 1, 2 or 4, which give respectively an 8 bit, 16 bit,
 * or 29 bit subset of Unicode (which is a 31 bit code).  The 8 bit
 * subset of Unicode corresponds to LATIN-1 and the 16 bit subset
 * of Unicode corresponds to UCS-2.
 */

#ifndef ___CS
#define ___CS 2
#endif

/*
 * Default character encoding to use for I/O.
 *
 * ___DEFAULT_IO_ENCODING should be one of:
 *    ___IO_CHAR_ENCODING    use text mode and native encoding
 *    ___IO_LATIN1_ENCODING  use text mode and LATIN-1 encoding
 *    ___IO_UTF8_ENCODING    use text mode and UTF-8 encoding (1..6 bytes/char)
 *    ___IO_BYTE_ENCODING    use binary mode and LATIN-1 encoding (1 byte/char)
 *    ___IO_UCS2_ENCODING    use binary mode and UCS-2 encoding (2 bytes/char)
 *    ___IO_UCS4_ENCODING    use binary mode and UCS-4 encoding (4 bytes/char)
 */

#ifndef ___DEFAULT_IO_ENCODING
#define ___DEFAULT_IO_ENCODING ___IO_CHAR_ENCODING
#endif

/*
 * Number of registers in the virtual machine.  These definitions must
 * agree with those in the file "gsc/_t-c-1.scm".  All Scheme sources
 * must be recompiled if these definitions are changed.
 *
 * ___NB_GVM_REGS = total number of registers available
 *                  3 <= ___NB_GVM_REGS <= 8
 * ___NB_ARG_REGS = maximum number of arguments passed in registers
 *                  1 <= ___NB_ARG_REGS <= ___NB_GVM_REGS-2
 */

#define ___NB_GVM_REGS 5
#define ___NB_ARG_REGS 3

/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
#define ___P(ansi,kr)ansi
#define ___PVOID ()
#define ___BOOL int
#define ___BEGIN_C_LINKAGE extern "C" {
#define ___END_C_LINKAGE }
#else
#ifdef __STDC__
#define ___P(ansi,kr)ansi
#define ___PVOID (void)
#else
#define ___P(ansi,kr)kr
#define ___PVOID ()
#endif
#define ___BOOL int
#define ___BEGIN_C_LINKAGE
#define ___END_C_LINKAGE
#define ___USE_SETJMP
#endif

#ifndef ___HIDDEN
#define ___HIDDEN static
#endif

#ifndef ___LOCAL
#define ___LOCAL static
#endif

#ifndef ___EXPORT_FUNC
#define ___EXPORT_FUNC(type,name)type name
#endif

#ifndef ___EXPORT_DATA
#define ___EXPORT_DATA(type,name)type name
#endif

#ifndef ___IMPORT_FUNC
#define ___IMPORT_FUNC(type,name)extern type name
#endif

#ifndef ___IMPORT_DATA
#define ___IMPORT_DATA(type,name)extern type name
#endif

#define ___EXP_FUNC(type,name)type name
#define ___EXP_DATA(type,name)type name
#define ___IMP_FUNC(type,name)extern type name
#define ___IMP_DATA(type,name)extern type name

#ifdef ___SHARED
#ifdef ___LIBRARY
#undef ___EXP_FUNC
#define ___EXP_FUNC(type,name)___EXPORT_FUNC(type,name)
#undef ___EXP_DATA
#define ___EXP_DATA(type,name)___EXPORT_DATA(type,name)
#endif
#ifndef ___PRIMAL
#undef ___IMP_FUNC
#define ___IMP_FUNC(type,name)___IMPORT_FUNC(type,name)
#undef ___IMP_DATA
#define ___IMP_DATA(type,name)___IMPORT_DATA(type,name)
#endif
#endif

#ifdef ___CANT_IMPORT_EXPORTED
#ifdef ___SHARED
#ifndef ___PRIMAL
#undef ___BIND_LATE
#define ___BIND_LATE
#endif
#endif
#endif

/*---------------------------------------------------------------------------*/

/*
 * IMPORTANT NOTE
 *
 * As a general principle, the macros are written in such a way that all
 * macros which expand into C expressions yield PRIMARY C expressions.
 * Also, macros assume that arguments are PRIMARY expressions.  A PRIMARY
 * expression is either:
 *
 *   an identifier, or
 *   a non-negative constant, or
 *   a parenthesized expression.
 *
 * This convention avoids many operator priority problems and helps keep
 * the number of parentheses down.  On the other hand, it is easy to
 * introduce errors when modifying these macros so be careful.
 */

/*---------------------------------------------------------------------------*/

/*
 * GENERAL DEFINITIONS
 *
 * ___U8    an unsigned integer type of exactly 8 bits
 * ___U16   an unsigned integer type of exactly 16 bits
 * ___U32   an unsigned integer type of exactly 32 bits
 * ___U64   an unsigned integer type of exactly 64 bits (only if one exists)
 * ___WORD  an integer type able to contain a pointer with no loss
 * ___LWS   is equal to the base 2 logarithm of "sizeof(___WORD)"
 */

#define ___U8  unsigned char
#define ___U16 unsigned ___I16
#define ___U32 unsigned ___I32
#ifdef ___I64
#define ___U64 unsigned ___I64
#else
#undef ___FORCE_32
#define ___FORCE_32
#endif

#ifdef ___FORCE_32
#define ___WORD ___I32
#define ___LWS 2
#define ___FLONUM_SIZE 2
#else
#define ___WORD ___I64
#define ___LWS 3
#define ___FLONUM_SIZE 1
#endif

#define ___WS (1<<___LWS)

#define ___LATIN1 ___U8
#define ___UCS4 ___U32
#define ___UCS2 ___U16
#define ___LATIN1STRING ___U8*
#define ___UCS4STRING ___UCS4*
#define ___UCS2STRING ___UCS2*
#define ___UTF8STRING char*

#if ___CS == 1

#define ___LCS 0
#define ___C ___U8

#else

#if ___CS == 2

#define ___LCS 1
#define ___C ___U16

#else

#define ___LCS 2
#define ___C ___U32

#endif
#endif

#ifdef ___WORD_IS_SMALLER_THAN_POINTERS
#define ___FAKEWORD ___WORD
#define ___CAST_FAKEWORD_TO_WORD(x)x
#define ___CAST_WORDSTAR_TO_FAKEWORD(x)((___WORD)x)
#define ___FAKEHOST ___WORD
#define ___CAST_HOST_TO_FAKEHOST(x)((___WORD)x)
#define ___CAST_FAKEHOST_TO_HOST(x)((___host)x)
#else
#define ___FAKEWORD ___WORD*
#define ___CAST_FAKEWORD_TO_WORD(x)((___WORD)x)
#define ___CAST_WORDSTAR_TO_FAKEWORD(x)x
#define ___FAKEHOST ___host
#define ___CAST_HOST_TO_FAKEHOST(x)x
#define ___CAST_FAKEHOST_TO_HOST(x)x
#endif

/* Padding at end of objects so that they can be aligned to an address */
/* multiple of 4 or 8 by moving them up in memory.                     */

#ifdef ___FORCE_32
#define ___PADDING ,0
#define ___PADDING_LBL ,{0,0,0,0}
#define ___PADDING_FLO ,0,0
#else
#define ___PADDING
#define ___PADDING_LBL
#define ___PADDING_FLO
#endif

/* Utility macro to select code for MULTIPLE/SINGLE host. */

#ifdef ___SINGLE_HOST
#define ___SM(s,m)s
#else
#define ___SM(s,m)m
#endif

/*---------------------------------------------------------------------------*/

/* OBJECT REPRESENTATION */

/*
 * For a complete description of the object representation, read the
 * file "lib/mem.c".  These definitions must agree with those in the
 * file "lib/header.scm".
 */

/*
 * Type tag assignment
 *
 * Type tags are located in the lower 2 bits of a ___WORD.
 *
 * ___TB = number of tag bits
 * ___tFIXNUM   = tag for fixnums (small integers), must be 0
 * ___tSPECIAL  = tag for other immediates (#f, #t, (), chars, ...)
 * ___tPAIR     = tag for pairs
 * ___tSUBTYPED = tag for other memory allocated objects
 */

#define ___TB 2
#define ___tFIXNUM   0
#define ___tSPECIAL  2
#define ___tPAIR     3
#define ___tSUBTYPED 1

#define ___MEM_ALLOCATED(obj)(obj&1)

/*
 * Subtype tag assignment
 *

 * These tags are stored in the head of memory allocated objects
 * (including pairs).
 *
 * ___SB = number of subtype tag bits
 * ___sVECTOR       = tag for vectors
 * ___sPAIR         = tag for pairs
 * ___sRATNUM       = tag for ratnums
 * ___sCPXNUM       = tag for cpxnums
 * ___sSTRUCTURE    = tag for structures
 * ___sMEROON       = tag for Meroon objects
 * ___sSYMBOL       = tag for symbols
 * ___sKEYWORD      = tag for keywords
 * ___sFRAME        = tag for continuation frames
 * ___sCONTINUATION = tag for continuation descriptors
 * ___sPROMISE      = tag for promises
 * ___sPROCEDURE    = tag for procedures
 * ___sWILL         = tag for wills
 * ___sSTRING       = tag for strings
 * ___sBIGNUM       = tag for bignums
 * ___sU8VECTOR     = tag for 8-bit unsigned integer vectors
 * ___sU16VECTOR    = tag for 16-bit unsigned integer vectors
 * ___sU32VECTOR    = tag for 32-bit unsigned integer vectors
 * ___sF32VECTOR    = tag for 32-bit floating point number vectors
 * ___sF64VECTOR    = tag for 64-bit floating point number vectors
 * ___sFLONUM       = tag for flonums
 * ___sPOINTER      = tag for C pointers
 *
 * The three subtype tags ___sF64VECTOR, ___sFLONUM, ___sPOINTER must
 * come last.  These object types are aligned on a multiple of 8.
 */

#define ___SB 5
#define ___sVECTOR       0
#define ___sPAIR         1
#define ___sRATNUM       2
#define ___sCPXNUM       3
#define ___sSTRUCTURE    4
#define ___sMEROON       6
#define ___sSYMBOL       8
#define ___sKEYWORD      9
#define ___sFRAME        10
#define ___sCONTINUATION 11
#define ___sPROMISE      12
#define ___sPROCEDURE    13
#define ___sWILL         14
#define ___sSTRING       16
#define ___sBIGNUM       17
#define ___sU8VECTOR     25
#define ___sU16VECTOR    26
#define ___sU32VECTOR    27
#define ___sF32VECTOR    28
#define ___sF64VECTOR    29
#define ___sFLONUM       30
#define ___sPOINTER      31

/*
 * Head type tag assignment
 *
 * Head type tags are stored in the lower 3 bits of the head of memory
 * allocated objects.
 *
 * ___HTB = number of head tag bits
 * ___MOVABLE0 = tag for movable objects in generation 0
 * ___FORW     = tag for movable objects that have been forwarded
 * ___STILL    = tag for still objects
 * ___PERM     = tag for permanent objects
 *
 * note: the tag ___FORW+(1<<___TB) is also used
 */

#define ___HTB 3
#define ___MOVABLE0 0
#define ___STILL    1
#define ___FORW     3
#define ___PERM     6

/*
 * Miscellaneous masks.
 */

#define ___LF (___HTB+___SB)

#define ___TMASK ((1<<___TB)-1)
#define ___HTMASK ((1<<___HTB)-1)
#define ___SMASK (((1<<___SB)-1)<<___HTB)
#define ___LMASK (~(___U32)0<<___LF)

/*
 * Value constructors for object references inside executable code.
 */

#define ___FAL (((___WORD)-1<<___TB)+___tSPECIAL)
#define ___TRU (((___WORD)-2<<___TB)+___tSPECIAL)
#define ___NUL (((___WORD)-3<<___TB)+___tSPECIAL)
#define ___EOF (((___WORD)-4<<___TB)+___tSPECIAL)
#define ___VOID (((___WORD)-5<<___TB)+___tSPECIAL)
#define ___ABSENT (((___WORD)-6<<___TB)+___tSPECIAL)
#define ___UNB1 (((___WORD)-7<<___TB)+___tSPECIAL)
#define ___UNB2 (((___WORD)-8<<___TB)+___tSPECIAL)
#define ___SCRIPT (((___WORD)-10<<___TB)+___tSPECIAL)
#define ___OPTIONAL (((___WORD)-11<<___TB)+___tSPECIAL)
#define ___KEY_OBJ (((___WORD)-12<<___TB)+___tSPECIAL)
#define ___REST (((___WORD)-13<<___TB)+___tSPECIAL)
#define ___FIX(x)((___WORD)((___I32)x<<___TB))
#define ___CHR(x)(((___WORD)(___C)x<<___TB)+___tSPECIAL)

#define ___SYM(i,id)___CAST_FAKEWORD_TO_WORD(___sym_tbl[i])
#define ___KEY(i,id)___CAST_FAKEWORD_TO_WORD(___key_tbl[i])
#define ___CNS(i)___TAG((___ALIGNUP(___cns_tbl,___WS)+i*(___PAIR_SIZE+1)),___tPAIR)
#define ___SUB(i)___CAST_FAKEWORD_TO_WORD(___sub_tbl[i])

/*
 * Value constructors for object references inside constant
 * memory allocated objects.
 */

#define ___REF_FAL ___FAL
#define ___REF_TRU ___TRU
#define ___REF_NUL ___NUL
#define ___REF_EOF ___EOF
#define ___REF_VOID ___VOID
#define ___REF_ABSENT ___ABSENT
#define ___REF_SCRIPT ___SCRIPT
#define ___REF_OPTIONAL ___OPTIONAL
#define ___REF_KEY_OBJ ___KEY_OBJ
#define ___REF_REST ___REST
#define ___REF_FIX(x)___FIX(x)
#define ___REF_CHR(x)___CHR(x)

#define ___REF_SYM(i,id)(((___WORD)(-1-i)<<___TB)+___tPAIR)
#define ___REF_KEY(i,id)(((___WORD)(-1-i)<<___TB)+___tSUBTYPED)
#define ___REF_CNS(i)(((___WORD)i<<___TB)+___tPAIR)
#define ___REF_SUB(i)(((___WORD)i<<___TB)+___tSUBTYPED)

/*---------------------------------------------------------------------------*/

/* Miscellaneous macros */

#define ___NOTHING

#define ___INT(x)(x>>___TB)

#define ___U32UNBOX(x)((___TYP((___temp=x))==___tFIXNUM)?___INT(___temp): \
((((((___I32)((___U16*)___BODY_AS(___temp,___tSUBTYPED))[3]<<___RADIX_WIDTH)+ \
(___I32)((___U16*)___BODY_AS(___temp,___tSUBTYPED))[2])<<___RADIX_WIDTH)+ \
(___I32)((___U16*)___BODY_AS(___temp,___tSUBTYPED))[1])* \
(((___U16*)___BODY_AS(___temp,___tSUBTYPED))[0]==0?-1:1)))

#define ___RADIX_WIDTH 14

#define ___MIN_FIX (-((___I32)1<<(32-___TB-1)))
#define ___MAX_FIX (((___I32)1<<(32-___TB-1))-1)

#if ___CS == 4
#define ___MAX_CHR ___MAX_FIX
#else
#define ___MAX_CHR (((___I32)1<<(8*___CS))-1)
#endif

/*
 * Module prefix and C id prefix must match the definitions
 * in the file "gsc/_parms.scm".
 */

#define ___MODULE_PREFIX " "
#define ___C_ID_PREFIX "___"

/*---------------------------------------------------------------------------*/

#define ___ALIGNUP(x,mult)((___WORD*)(((___WORD)x+mult-1)&(-mult)))

/* Type tests */

#define ___TAG(ptr,tag)((___WORD)ptr+tag)
#define ___UNTAG(obj)((___WORD*)(obj&-(1<<___TB)))
#define ___UNTAG_AS(obj,tag)((___WORD*)(obj-tag))

#define ___TYP(x)(x&___TMASK)
#define ___TESTTYPE(x,typ)(___TYP(x)==typ)

#define ___TESTSUBTYPE(x,s)(___TYP((___temp=x))==___tSUBTYPED&&___SUBTYPE(___temp)==s<<___TB)
#define ___HEADER(x)(*___UNTAG_AS(x,___tSUBTYPED))

#define ___BODY_OFS 1

#ifdef ___USE_HANDLES
#define ___PAIR_OVERHEAD 2
#define ___SUBTYPED_OVERHEAD 2
#define ___BODY(obj)((___WORD*)(*(___UNTAG(obj)+___BODY_OFS)+___BODY_OFS))
#define ___BODY_AS(obj,tag)((___WORD*)*(___UNTAG_AS(obj,tag)+___BODY_OFS)+___BODY_OFS)
#else
#define ___PAIR_OVERHEAD 1
#define ___SUBTYPED_OVERHEAD 1
#define ___BODY(obj)(___UNTAG(obj)+___BODY_OFS)
#define ___BODY_AS(obj,tag)(___UNTAG_AS(obj,tag)+___BODY_OFS)
#endif

#define ___MAKE_HD(bytes,subtype,tag)((bytes<<___LF)+(subtype<<___HTB)+tag)
#define ___HD_TYP(head)((___U32)head&___HTMASK)
#define ___HD_BYTES(head)((___U32)head>>___LF)
#define ___HD_WORDS(head)((((___U32)head+((___WS-1)<<___LF)))>>(___LF+___LWS))
#define ___HD_FIELDS(head)((___U32)head>>(___LF+___LWS))
#define ___HD_SUBTYPE(head)((___U32)head>>___HTB&((1<<___SB)-1))

#define ___FIELD(obj,i)(*(___BODY_AS(obj,___tSUBTYPED)+i))

#define ___WORDS(bytes)((bytes+___WS-1)>>___LWS)

#define ___MAKE_HD_BYTES(bytes,subtype)___MAKE_HD(bytes,subtype,___MOVABLE0)
#define ___MAKE_HD_WORDS(words,subtype)___MAKE_HD((words<<___LWS),subtype,___MOVABLE0)

#define ___SYMBOL_SIZE 3
#define ___KEYWORD_SIZE 2
#define ___WILL1_SIZE 2
#define ___WILL2_SIZE 3
#define ___PROMISE_SIZE 2
#define ___RATNUM_SIZE 2
#define ___CPXNUM_SIZE 2
#define ___CONTINUATION_SIZE 3
#define ___INTRO_SIZE 3

#define ___U32BOX(x) \
(___temp=(x), \
((___U32)___temp<=(___U32)___MAX_FIX)?___FIX(___temp): \
(___hp[0]=___MAKE_HD_BYTES((4<<1),___sBIGNUM), \
((___U16*)(___hp+1))[0]=1, \
((___U16*)(___hp+1))[1]=(___U32)___temp&((1<<___RADIX_WIDTH)-1), \
((___U16*)(___hp+1))[2]=((___U32)___temp>>___RADIX_WIDTH)&((1<<___RADIX_WIDTH)-1), \
((___U16*)(___hp+1))[3]=((___U32)___temp>>(2*___RADIX_WIDTH))&((1<<___RADIX_WIDTH)-1), \
___hp+=___WORDS((4<<1))+1, \
___TAG((___hp-___WORDS((4<<1))-1),___tSUBTYPED)))

/* Flonum boxing and unboxing */

#define ___FLONUM_VAL(obj)(*(___F64*)(___BODY_AS(obj,___tSUBTYPED)))

#define ___FLONUM_SETUP(ptr,x) \
(*ptr=___MAKE_HD_WORDS(___FLONUM_SIZE,___sFLONUM),*(___F64*)(ptr+1)=x, \
___TAG(ptr,___tSUBTYPED))

#if ___WS == 4

#define ___F64BOX(x) \
(___hp+=___FLONUM_SIZE+2,((___WORD)___hp&7)==0 \
?___FLONUM_SETUP((___hp-___FLONUM_SIZE-1),x) \
:___FLONUM_SETUP((___hp-___FLONUM_SIZE-2),x))

#else

#define ___F64BOX(x) \
(___hp+=___FLONUM_SIZE+1,___FLONUM_SETUP((___hp-___FLONUM_SIZE-1),x))

#endif

#define ___F64UNBOX(x)___FLONUM_VAL(x)

#define ___D_F64(x)___F64 x;
#define ___SET_F64(x,y)x=y;
#define ___IF(x)if (x) {
#define ___END_IF }

/*---------------------------------------------------------------------------*/

/* Inlinable operations (for 'apply' and 'ifjump' GVM instructions) */

/* APPLY-able operations */

#define ___TYPE(x)___FIX(___TYP(x))
#define ___TYPECAST(x,y)((x&~___TMASK)+___INT(y))
#define ___SUBTYPE(x)((___HEADER(x)&___SMASK)>>(___HTB-___TB))
#define ___SUBTYPESET(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___SMASK)+((y)<<(___HTB-___TB));

/* IFJUMP-able operations */

#define ___FALSEP(x)(x==___FAL)
#define ___NULLP(x)(x==___NUL)
#define ___UNBOUNDP(x)(((___temp=x)==___UNB1)||(___temp==___UNB2))
#define ___EQP(x,y)(x==y)
#define ___EOFP(x)(x==___EOF)

/* IFJUMP-able operations */

#define ___FIXNUMP(x)___TESTTYPE(x,___tFIXNUM)
#define ___FLONUMP(x)___TESTSUBTYPE(x,___sFLONUM)
#define ___SPECIALP(x)___TESTTYPE(x,___tSPECIAL)
#define ___PAIRP(x)___TESTTYPE(x,___tPAIR)
#define ___SUBTYPEDP(x)___TESTTYPE(x,___tSUBTYPED)
#define ___PROCEDUREP(x)___TESTSUBTYPE(x,___sPROCEDURE)
#define ___PROMISEP(x)___TESTSUBTYPE(x,___sPROMISE)
#define ___VECTORP(x)___TESTSUBTYPE(x,___sVECTOR)
#define ___SYMBOLP(x)___TESTSUBTYPE(x,___sSYMBOL)
#define ___KEYWORDP(x)___TESTSUBTYPE(x,___sKEYWORD)
#define ___RATNUMP(x)___TESTSUBTYPE(x,___sRATNUM)
#define ___CPXNUMP(x)___TESTSUBTYPE(x,___sCPXNUM)
#define ___STRINGP(x)___TESTSUBTYPE(x,___sSTRING)
#define ___STRUCTUREP(x)___TESTSUBTYPE(x,___sSTRUCTURE)
#define ___BIGNUMP(x)___TESTSUBTYPE(x,___sBIGNUM)
#define ___U8VECTORP(x)___TESTSUBTYPE(x,___sU8VECTOR)
#define ___U16VECTORP(x)___TESTSUBTYPE(x,___sU16VECTOR)
#define ___U32VECTORP(x)___TESTSUBTYPE(x,___sU32VECTOR)
#define ___F32VECTORP(x)___TESTSUBTYPE(x,___sF32VECTOR)
#define ___F64VECTORP(x)___TESTSUBTYPE(x,___sF64VECTOR)
#define ___CHARP(x)(___TYP((___temp=x))==___tSPECIAL&&___temp>=0)

/* APPLY-able operations */

#define ___FIX_0 ___FIX(0)
#define ___FIXPOS(x)((___WORD)((___I32)x))
#define ___FIXMAX(x,y)((x<y)?y:x)
#define ___FIXMIN(x,y)((x<y)?x:y)
#define ___FIXADD(x,y)((___WORD)((___I32)x+(___I32)y))
#define ___FIX_1 ___FIX(1)
#define ___FIXMUL(x,y)((___WORD)((___I32)x*(___I32)___INT(y)))
#define ___FIXNEG(x)((___WORD)(-(___I32)x))
#define ___FIXSUB(x,y)((___WORD)((___I32)x-(___I32)y))
#define ___FIXINV(x)___FIX(((___I32)___FIX(1)/(___I32)x))
#define ___FIXQUO(x,y)___FIX(((___I32)x/(___I32)y))
#define ___FIXREM(x,y)((___WORD)((___I32)x%(___I32)y))/****is this ok?*******/
#define ___FIXMOD(x,y)((___temp=___FIXREM((___ps->temp1=x),(___ps->temp2=y)))==0?___FIX(0):((___ps->temp1<0)==(___ps->temp2<0)?(___I32)___temp:___FIXADD(___temp,___ps->temp2)))
#define ___FIXIOR(x,y)((___WORD)((___I32)x|(___I32)y))
#define ___FIXXOR(x,y)((___WORD)((___I32)x^(___I32)y))
#define ___FIX_M1 ___FIX(-1)
#define ___FIXAND(x,y)((___WORD)((___I32)x&(___I32)y))
#define ___FIXNOT(x)((___WORD)((___I32)x^(___I32)~___TMASK))
#define ___FIXASHR(x,y)(((___I32)x>>___INT(y))&~___TMASK)
#define ___FIXLSHR(x,y)((___I32)(((___U32)x>>___INT(y))&~___TMASK))
#define ___FIXSHL(x,y)((___I32)x<<___INT(y))
#define ___FIXTOCHR(x)((x&~___TMASK)+___tSPECIAL)
#define ___FIXFROMCHR(x)(x&~___TMASK)

/* IFJUMP-able operations */

#define ___FIXZEROP(x)(x==0)
#define ___FIXPOSITIVEP(x)(x>0)
#define ___FIXNEGATIVEP(x)(x<0)
#define ___FIXODDP(x)(x&___FIX(1))
#define ___FIXEVENP(x)!(x&___FIX(1))
#define ___FIXEQ(x,y)(x==y)
#define ___FIXLT(x,y)(x<y)
#define ___FIXGT(x,y)(x>y)
#define ___FIXLE(x,y)(x<=y)
#define ___FIXGE(x,y)(x>=y)

/* APPLY-able operations */

#define ___F64TOFIX(x)___FIX(x)
#define ___F64FROMFIX(x)___INT(x)
#define ___F64_0 0.0
#define ___F64POS(x)x
#define ___F64MAX(x,y)(___F64NANP(x)?x:((x>y)?x:y))
#define ___F64MIN(x,y)(___F64NANP(x)?x:((x<y)?x:y))
#define ___F64ADD(x,y)(x+y)
#define ___F64_1 1.0
#define ___F64MUL(x,y)(x*y)
#define ___F64NEG(x)(-x)
#define ___F64SUB(x,y)(x-y)
#define ___F64INV(x)1.0/x
#define ___F64DIV(x,y)(x/y)
#define ___F64ABS(x)___CLIBEXT(fabs)(x)
#define ___F64FLOOR(x)___CLIBEXT(floor)(x)
#define ___F64CEILING(x)___CLIBEXT(ceil)(x)
#define ___F64ROUND(x)___EXT(___round)(x)
#define ___F64EXP(x)___CLIBEXT(exp)(x)
#define ___F64LOG(x)___CLIBEXT(log)(x)
#define ___F64SIN(x)___CLIBEXT(sin)(x)
#define ___F64COS(x)___CLIBEXT(cos)(x)
#define ___F64TAN(x)___CLIBEXT(tan)(x)
#define ___F64ASIN(x)___CLIBEXT(asin)(x)
#define ___F64ACOS(x)___CLIBEXT(acos)(x)
#define ___F64ATAN(x)___CLIBEXT(atan)(x)
#define ___F64ATAN2(x,y)___CLIBEXT(atan2)(x,y)
#define ___F64SQRT(x)___CLIBEXT(sqrt)(x)
#define ___F64COPYSIGN(x,y)___EXT(___copysign)(x,y)

/* IFJUMP-able operations */

#define ___F64ZEROP(x)(x==0.0)
#define ___F64POSITIVEP(x)(x>0.0)
#define ___F64NEGATIVEP(x)(x<0.0)
#define ___F64FINITEP(x)___EXT(___isfinite)(x)
#ifdef ___USE_ISNAN
#define ___F64NANP(x)___EXT(___isnan)(x)
#else
#define ___F64NANP(x)(x!=x)
#endif
#define ___F64EQ(x,y)(x==y)
#define ___F64LT(x,y)(x<y)
#define ___F64GT(x,y)(x>y)
#define ___F64LE(x,y)(x<=y)
#define ___F64GE(x,y)(x>=y)

/* IFJUMP-able operations */

#define ___CHAREQP(x,y)(x==y)
#define ___CHARLTP(x,y)(x<y)
#define ___CHARGTP(x,y)(x>y)
#define ___CHARLEP(x,y)(x<=y)
#define ___CHARGEP(x,y)(x>=y)

/* APPLY-able operations */

#define ___PAIR_SIZE 2
#define ___PAIR_CDR_OFS 0
#define ___PAIR_CAR_OFS 1

#define ___PAIR_CAR(obj)(*(___BODY_AS(obj,___tPAIR)+___PAIR_CAR_OFS))
#define ___PAIR_CDR(obj)(*(___BODY_AS(obj,___tPAIR)+___PAIR_CDR_OFS))

#define ___CONS(x,y)(___hp[0]=___MAKE_HD_WORDS(___PAIR_SIZE,___sPAIR), \
___hp[___PAIR_CAR_OFS+1]=x,___hp[___PAIR_CDR_OFS+1]=y,___hp+=___PAIR_SIZE+1,___TAG((___hp-___PAIR_SIZE-1),___tPAIR))

#define ___SETCAR(obj,car)___PAIR_CAR(obj)=car;
#define ___SETCDR(obj,cdr)___PAIR_CDR(obj)=cdr;
#define ___CAR(obj)___PAIR_CAR(obj)
#define ___CDR(obj)___PAIR_CDR(obj)
#define ___CAAR(obj)___CAR(___CAR(obj))
#define ___CADR(obj)___CAR(___CDR(obj))
#define ___CDAR(obj)___CDR(___CAR(obj))
#define ___CDDR(obj)___CDR(___CDR(obj))
#define ___CAAAR(obj)___CAR(___CAR(___CAR(obj)))
#define ___CAADR(obj)___CAR(___CAR(___CDR(obj)))
#define ___CADAR(obj)___CAR(___CDR(___CAR(obj)))
#define ___CADDR(obj)___CAR(___CDR(___CDR(obj)))
#define ___CDAAR(obj)___CDR(___CAR(___CAR(obj)))
#define ___CDADR(obj)___CDR(___CAR(___CDR(obj)))
#define ___CDDAR(obj)___CDR(___CDR(___CAR(obj)))
#define ___CDDDR(obj)___CDR(___CDR(___CDR(obj)))
#define ___CAAAAR(obj)___CAR(___CAR(___CAR(___CAR(obj))))
#define ___CAAADR(obj)___CAR(___CAR(___CAR(___CDR(obj))))
#define ___CAADAR(obj)___CAR(___CAR(___CDR(___CAR(obj))))
#define ___CAADDR(obj)___CAR(___CAR(___CDR(___CDR(obj))))
#define ___CADAAR(obj)___CAR(___CDR(___CAR(___CAR(obj))))
#define ___CADADR(obj)___CAR(___CDR(___CAR(___CDR(obj))))
#define ___CADDAR(obj)___CAR(___CDR(___CDR(___CAR(obj))))
#define ___CADDDR(obj)___CAR(___CDR(___CDR(___CDR(obj))))
#define ___CDAAAR(obj)___CDR(___CAR(___CAR(___CAR(obj))))
#define ___CDAADR(obj)___CDR(___CAR(___CAR(___CDR(obj))))
#define ___CDADAR(obj)___CDR(___CAR(___CDR(___CAR(obj))))
#define ___CDADDR(obj)___CDR(___CAR(___CDR(___CDR(obj))))
#define ___CDDAAR(obj)___CDR(___CDR(___CAR(___CAR(obj))))
#define ___CDDADR(obj)___CDR(___CDR(___CAR(___CDR(obj))))
#define ___CDDDAR(obj)___CDR(___CDR(___CDR(___CAR(obj))))
#define ___CDDDDR(obj)___CDR(___CDR(___CDR(___CDR(obj))))

/* APPLY-able operations */

#define ___MAKECELL(x)(___hp+=2,___hp[-2]=___MAKE_HD_WORDS(1,___sVECTOR), \
___hp[-1]=x,___TAG((___hp-2),___tSUBTYPED))
#define ___CELLREF(x)___BODY_AS(x,___tSUBTYPED)[0]
#define ___CELLSET(x,y)___BODY_AS(x,___tSUBTYPED)[0]=y;

#define ___VECTORLENGTH(x)___FIX(___HD_FIELDS(___HEADER(x)))
#define ___VECTORREF(x,y)*(___WORD*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(___LWS-___TB)))
#define ___VECTORSET(x,y,z)*(___WORD*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(___LWS-___TB)))=z;
#define ___VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+___LWS));

#define ___STRINGLENGTH(x)___FIX((___HD_BYTES(___HEADER(x))>>___LCS))
#define ___STRINGREF(x,y)___CHR(*(___C*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>(___TB-___LCS))))
#define ___STRINGSET(x,y,z)*(___C*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>(___TB-___LCS)))=___INT(z);
#define ___STRINGSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+___LCS));

#define ___U8VECTORLENGTH(x)___FIX(___HD_BYTES(___HEADER(x)))
#define ___U8VECTORREF(x,y)___FIX(*(___U8*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>___TB)))
#define ___U8VECTORSET(x,y,z)*(___U8*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>___TB))=___INT(z);
#define ___U8VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB));

#define ___U16VECTORLENGTH(x)___FIX((___HD_BYTES(___HEADER(x))>>1))
#define ___U16VECTORREF(x,y)___FIX(*(___U16*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>(___TB-1))))
#define ___U16VECTORSET(x,y,z)*(___U16*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)>>(___TB-1)))=___INT(z);
#define ___U16VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+1));

#define ___U32VECTORLENGTH(x)___FIX((___HD_BYTES(___HEADER(x))>>2))
#define ___U32VECTORREF(x,y)___U32BOX(*(___U32*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(2-___TB))))
#define ___U32VECTORSET(x,y,z)*(___U32*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(2-___TB)))=___U32UNBOX(z);
#define ___U32VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+2));

#define ___F32VECTORLENGTH(x)___FIX((___HD_BYTES(___HEADER(x))>>2))
#define ___F32VECTORREF(x,y)*(___F32*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(2-___TB)))
#define ___F32VECTORSET(x,y,z)*(___F32*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(2-___TB)))=z;
#define ___F32VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+2));

#define ___F64VECTORLENGTH(x)___FIX((___HD_BYTES(___HEADER(x))>>3))
#define ___F64VECTORREF(x,y)*(___F64*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(3-___TB)))
#define ___F64VECTORSET(x,y,z)*(___F64*)(((___WORD)___BODY_AS(x,___tSUBTYPED))+((y)<<(3-___TB)))=z;
#define ___F64VECTORSHRINK(x,y)___temp=x;___HEADER(___temp)=(___HEADER(___temp)&~___LMASK)+((y)<<(___LF-___TB+3));

#define ___STRUCTREF(x,y,tag)___VECTORREF(x,y)
#define ___STRUCTSET(x,y,z,tag)___VECTORSET(x,y,z)

#define ___SYMBOLTOSTR(x)___VECTORREF(x,___FIX(0))

#define ___KEYWORDTOSTR(x)___VECTORREF(x,___FIX(0))

#define ___CLOSURECODE(x)___CLO(x,0)
#define ___CLOSUREREF(x,y)___CLO(x,___INT(y))
#define ___CLOSURESET(x,y,z)___SET_CLO(x,___INT(y),z)

#define ___GLOBALVARREF(gv)((___glo_struct*)___VECTORREF(gv,___FIX(2)))->val
#define ___GLOBALVARSET(gv,x)((___glo_struct*)___VECTORREF(gv,___FIX(2)))->val = x;

#define ___MAKEPROMISE(x) \
(___hp+=___PROMISE_SIZE+1, \
___hp[-3]=___MAKE_HD_WORDS(___PROMISE_SIZE,___sPROMISE), \
___hp[-2]=x, ___hp[-1]=___TAG((___hp-___PROMISE_SIZE-1),___tSUBTYPED))

#define ___WILLP(x)___TESTSUBTYPE(x,___sWILL)
#define ___MAKEWILL1(testator) \
(___hp[0]=___MAKE_HD_WORDS(___WILL1_SIZE,___sWILL), \
___hp[1]=___FLOATING_WILL, \
___hp[2]=testator, \
___hp+=___WILL1_SIZE+1, \
___TAG((___hp-___WILL1_SIZE-1),___tSUBTYPED))
#define ___MAKEWILL2(testator,action) \
(___hp[0]=___MAKE_HD_WORDS(___WILL2_SIZE,___sWILL), \
___hp[1]=___ps->non_executable_wills, \
___hp[2]=testator, \
___hp[3]=action, \
___ps->non_executable_wills=___TAG(___hp,0), \
___hp+=___WILL2_SIZE+1, \
___TAG((___hp-___WILL2_SIZE-1),___tSUBTYPED))
#define ___WILLTESTATOR(x)___BODY_AS(x,___tSUBTYPED)[1]

#define ___EXEC_WILL     1
#define ___REACH_WILL    2
#define ___FLOATING_WILL -1

/*---------------------------------------------------------------------------*/

/* Stack manipulation */

#define ___PUSH(val)*--___fp=(val);
#define ___POP *___fp++
#define ___PSSTK(fpo)___PSFP[-(fpo)]
#define ___PSADJFP(fpa)___PSFP-=(fpa);
#define ___STK(fpo)___fp[-(fpo)]
#define ___SET_STK(fpo,val)___fp[-(fpo)]=(val);
#define ___ADJFP(fpa)___fp-=(fpa);

#define ___PRM(i,glo)___GLOSTRUCT(i,glo).prm
#define ___GLO(i,glo)___GLOSTRUCT(i,glo).val
#define ___SET_GLO(i,glo,x)___GLOSTRUCT(i,glo).val=x;
#ifdef ___BIND_LATE
#define ___GLOSTRUCT(i,glo)(*(___glo_struct*)___glo_tbl[i])
#else
#define ___GLOSTRUCT(i,glo)glo
#endif

#define ___HOST_PROC ___SM(___MH_PROC,___PH_PROC)
#define ___HOST_LBL0 ___SM(1,___PH_LBL0)

#define ___BEGIN_M_COD ___SM(___BEGIN_COD,___NOTHING)
#define ___END_M_COD ___SM(___END_COD,___NOTHING)
#define ___BEGIN_P_COD ___SM(___NOTHING,___BEGIN_COD)
#define ___END_P_COD ___SM(___NOTHING,___END_COD)

#define ___BEGIN_P_SLBL
#define ___DEF_P_SLBL(id)
#define ___END_P_SLBL

#define ___D_ALL ___SM(___MD_ALL,___PD_ALL)
#define ___R_ALL ___SM(___MR_ALL,___PR_ALL)
#define ___W_ALL ___SM(___MW_ALL,___PW_ALL)

#define ___BEGIN_COD \
___HIDDEN ___WORD ___HOST_PROC ___P((___processor_state ___ps),(___ps) \
___processor_state ___ps;){ \
register ___WORD ___pc, ___temp; \
register ___WORD ___start=___MLBL(___HOST_LBL0); \
___D_ALL ___R_ALL

#define ___END_COD \
___ps->pc=___pc; ___W_ALL return ___pc; }

#define ___LS 4

#define ___PSHEAP ___ps->hp
#define ___D_HEAP register ___WORD *___hp;
#define ___R_HEAP ___hp=___PSHEAP;
#define ___W_HEAP ___PSHEAP=___hp;

#define ___PSFP ___ps->fp
#define ___D_FP register ___WORD *___fp;
#define ___R_FP ___fp=___PSFP;
#define ___W_FP ___PSFP=___fp;

/*---------------------------------------------------------------------------*/

/* GVM registers */

#define ___MAX_LOCAL_GVM_REGS 8

#define ___PSR0 ___ps->r[0]
#if ___MAX_LOCAL_GVM_REGS > 0
#define ___D_R0 register ___WORD ___r0;
#define ___R_R0 ___r0=___PSR0;
#define ___W_R0 ___PSR0=___r0;
#define ___R0 ___r0
#else
#define ___D_R0
#define ___R_R0
#define ___W_R0
#define ___R0 ___PSR0
#endif
#define ___SET_R0(val)___R0=val;
#define ___PUSH_R0 ___PUSH(___R0)
#define ___POP_R0 ___SET_R0(___POP)

#if ___NB_ARG_REGS == 0
#define ___PUSH_ARGS_IN_REGS(na)
#define ___POP_ARGS_IN_REGS(na)
#define ___PSSELF ___PSR1
#define ___SELF ___R1
#define ___LD_ARG_REGS
#define ___ST_ARG_REGS
#endif

#define ___PSR1 ___ps->r[1]
#if ___MAX_LOCAL_GVM_REGS > 1
#define ___D_R1 register ___WORD ___r1;
#define ___R_R1 ___r1=___PSR1;
#define ___W_R1 ___PSR1=___r1;
#define ___R1 ___r1
#else
#define ___D_R1
#define ___R_R1
#define ___W_R1
#define ___R1 ___PSR1
#endif
#define ___SET_R1(val)___R1=(val);
#define ___PUSH_R1_TO_R1 ___PUSH(___R1)
#define ___POP_R1_TO_R1 ___SET_R1(___POP)
#define ___LD_R1_TO_R1 ___D_R1 ___R_R1
#define ___ST_R1_TO_R1 ___W_R1

#if ___NB_ARG_REGS == 1
#define ___PUSH_ARGS_IN_REGS(na) \
if ((na)>0) ___PUSH_R1_TO_R1
#define ___POP_ARGS_IN_REGS(na) \
if ((na)>0) ___POP_R1_TO_R1
#define ___PSSELF ___PSR2
#define ___SELF ___R2
#define ___LD_ARG_REGS ___LD_R1_TO_R1
#define ___ST_ARG_REGS ___ST_R1_TO_R1
#endif

#if ___NB_GVM_REGS == 2

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R1
#define ___POP_REGS ___POP_R1_TO_R1 ___POP_R0

#else

#define ___PSR2 ___ps->r[2]
#if ___MAX_LOCAL_GVM_REGS > 2
#define ___D_R2 register ___WORD ___r2;
#define ___R_R2 ___r2=___PSR2;
#define ___W_R2 ___PSR2=___r2;
#define ___R2 ___r2
#else
#define ___D_R2
#define ___R_R2
#define ___W_R2
#define ___R2 ___PSR2
#endif
#define ___SET_R2(val)___R2=(val);
#define ___PUSH_R1_TO_R2 ___PUSH_R1_TO_R1 ___PUSH(___R2)
#define ___POP_R2_TO_R1 ___SET_R2(___POP)___POP_R1_TO_R1
#define ___LD_R1_TO_R2 ___D_R2 ___LD_R1_TO_R1 ___R_R2
#define ___ST_R1_TO_R2 ___ST_R1_TO_R1 ___W_R2

#if ___NB_ARG_REGS == 2
#define ___PUSH_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___PUSH_R1_TO_R1 break; \
  default: ___PUSH_R1_TO_R2 \
  }
#define ___POP_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___POP_R1_TO_R1 break; \
  default: ___POP_R2_TO_R1 \
  }
#define ___PSSELF ___PSR3
#define ___SELF ___R3
#define ___LD_ARG_REGS ___LD_R1_TO_R2
#define ___ST_ARG_REGS ___ST_R1_TO_R2
#endif

#if ___NB_GVM_REGS == 3

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R2
#define ___POP_REGS ___POP_R2_TO_R1 ___POP_R0

#else

#define ___PSR3 ___ps->r[3]
#if ___MAX_LOCAL_GVM_REGS > 3
#define ___D_R3 register ___WORD ___r3;
#define ___R_R3 ___r3=___PSR3;
#define ___W_R3 ___PSR3=___r3;
#define ___R3 ___r3
#else
#define ___D_R3
#define ___R_R3
#define ___W_R3
#define ___R3 ___PSR3
#endif
#define ___SET_R3(val)___R3=(val);
#define ___PUSH_R1_TO_R3 ___PUSH_R1_TO_R2 ___PUSH(___R3)
#define ___POP_R3_TO_R1 ___SET_R3(___POP)___POP_R2_TO_R1
#define ___LD_R1_TO_R3 ___D_R3 ___LD_R1_TO_R2 ___R_R3
#define ___ST_R1_TO_R3 ___ST_R1_TO_R2 ___W_R3

#if ___NB_ARG_REGS == 3
#define ___PUSH_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___PUSH_R1_TO_R1 break; \
  case 2:  ___PUSH_R1_TO_R2 break; \
  default: ___PUSH_R1_TO_R3 \
  }
#define ___POP_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___POP_R1_TO_R1 break; \
  case 2:  ___POP_R2_TO_R1 break; \
  default: ___POP_R3_TO_R1 \
  }
#define ___PSSELF ___PSR4
#define ___SELF ___R4
#define ___LD_ARG_REGS ___LD_R1_TO_R3
#define ___ST_ARG_REGS ___ST_R1_TO_R3
#endif

#if ___NB_GVM_REGS == 4

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R3
#define ___POP_REGS ___POP_R3_TO_R1 ___POP_R0

#else

#define ___PSR4 ___ps->r[4]
#if ___MAX_LOCAL_GVM_REGS > 4
#define ___D_R4 register ___WORD ___r4;
#define ___R_R4 ___r4=___PSR4;
#define ___W_R4 ___PSR4=___r4;
#define ___R4 ___r4
#else
#define ___D_R4
#define ___R_R4
#define ___W_R4
#define ___R4 ___PSR4
#endif
#define ___SET_R4(val)___R4=(val);
#define ___PUSH_R1_TO_R4 ___PUSH_R1_TO_R3 ___PUSH(___R4)
#define ___POP_R4_TO_R1 ___SET_R4(___POP)___POP_R3_TO_R1
#define ___LD_R1_TO_R4 ___D_R4 ___LD_R1_TO_R3 ___R_R4
#define ___ST_R1_TO_R4 ___ST_R1_TO_R3 ___W_R4

#if ___NB_ARG_REGS == 4
#define ___PUSH_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___PUSH_R1_TO_R1 break; \
  case 2:  ___PUSH_R1_TO_R2 break; \
  case 3:  ___PUSH_R1_TO_R3 break; \
  default: ___PUSH_R1_TO_R4 \
  }
#define ___POP_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___POP_R1_TO_R1 break; \
  case 2:  ___POP_R2_TO_R1 break; \
  case 3:  ___POP_R3_TO_R1 break; \
  default: ___POP_R4_TO_R1 \
  }
#define ___PSSELF ___PSR5
#define ___SELF ___R5
#define ___LD_ARG_REGS ___LD_R1_TO_R4
#define ___ST_ARG_REGS ___ST_R1_TO_R4
#endif

#if ___NB_GVM_REGS == 5

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R4
#define ___POP_REGS ___POP_R4_TO_R1 ___POP_R0

#else

#define ___PSR5 ___ps->r[5]
#if ___MAX_LOCAL_GVM_REGS > 5
#define ___D_R5 register ___WORD ___r5;
#define ___R_R5 ___r5=___PSR5;
#define ___W_R5 ___PSR5=___r5;
#define ___R5 ___r5
#else
#define ___D_R5
#define ___R_R5
#define ___W_R5
#define ___R5 ___PSR5
#endif
#define ___SET_R5(val)___R5=(val);
#define ___PUSH_R1_TO_R5 ___PUSH_R1_TO_R4 ___PUSH(___R5)
#define ___POP_R5_TO_R1 ___SET_R5(___POP)___POP_R4_TO_R1
#define ___LD_R1_TO_R5 ___D_R5 ___LD_R1_TO_R4 ___R_R5
#define ___ST_R1_TO_R5 ___ST_R1_TO_R4 ___W_R5

#if ___NB_ARG_REGS == 5
#define ___PUSH_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___PUSH_R1_TO_R1 break; \
  case 2:  ___PUSH_R1_TO_R2 break; \
  case 3:  ___PUSH_R1_TO_R3 break; \
  case 4:  ___PUSH_R1_TO_R4 break; \
  default: ___PUSH_R1_TO_R5 \
  }
#define ___POP_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___POP_R1_TO_R1 break; \
  case 2:  ___POP_R2_TO_R1 break; \
  case 3:  ___POP_R3_TO_R1 break; \
  case 4:  ___POP_R4_TO_R1 break; \
  default: ___POP_R5_TO_R1 \
  }
#define ___PSSELF ___PSR6
#define ___SELF ___R6
#define ___LD_ARG_REGS ___LD_R1_TO_R5
#define ___ST_ARG_REGS ___ST_R1_TO_R5
#endif

#if ___NB_GVM_REGS == 6

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R5
#define ___POP_REGS ___POP_R5_TO_R1 ___POP_R0

#else

#define ___PSR6 ___ps->r[6]
#if ___MAX_LOCAL_GVM_REGS > 6
#define ___D_R6 register ___WORD ___r6;
#define ___R_R6 ___r6=___PSR6;
#define ___W_R6 ___PSR6=___r6;
#define ___R6 ___r6
#else
#define ___D_R6
#define ___R_R6
#define ___W_R6
#define ___R6 ___PSR6
#endif
#define ___SET_R6(val)___R6=(val);
#define ___PUSH_R1_TO_R6 ___PUSH_R1_TO_R5 ___PUSH(___R6)
#define ___POP_R6_TO_R1 ___SET_R6(___POP)___POP_R5_TO_R1
#define ___LD_R1_TO_R6 ___D_R6 ___LD_R1_TO_R5 ___R_R6
#define ___ST_R1_TO_R6 ___ST_R1_TO_R5 ___W_R6

#if ___NB_ARG_REGS == 6
#define ___PUSH_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___PUSH_R1_TO_R1 break; \
  case 2:  ___PUSH_R1_TO_R2 break; \
  case 3:  ___PUSH_R1_TO_R3 break; \
  case 4:  ___PUSH_R1_TO_R4 break; \
  case 5:  ___PUSH_R1_TO_R5 break; \
  default: ___PUSH_R1_TO_R6 \
  }
#define ___POP_ARGS_IN_REGS(na) \
switch (na) \
  { \
  case 0:  break; \
  case 1:  ___POP_R1_TO_R1 break; \
  case 2:  ___POP_R2_TO_R1 break; \
  case 3:  ___POP_R3_TO_R1 break; \
  case 4:  ___POP_R4_TO_R1 break; \
  case 5:  ___POP_R5_TO_R1 break; \
  default: ___POP_R6_TO_R1 \
  }
#define ___PSSELF ___PSR7
#define ___SELF ___R7
#define ___LD_ARG_REGS ___LD_R1_TO_R6
#define ___ST_ARG_REGS ___ST_R1_TO_R6
#endif

#if ___NB_GVM_REGS == 7

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R6
#define ___POP_REGS ___POP_R6_TO_R1 ___POP_R0

#else

#define ___PSR7 ___ps->r[7]
#if ___MAX_LOCAL_GVM_REGS > 7
#define ___D_R7 register ___WORD ___r7;
#define ___R_R7 ___r7=___PSR7;
#define ___W_R7 ___PSR7=___r7;
#define ___R7 ___r7
#else
#define ___D_R7
#define ___R_R7
#define ___W_R7
#define ___R7 ___PSR7
#endif
#define ___SET_R7(val)___R7=(val);
#define ___PUSH_R1_TO_R7 ___PUSH_R1_TO_R6 ___PUSH(___R7)
#define ___POP_R7_TO_R1 ___SET_R7(___POP)___POP_R6_TO_R1
#define ___LD_R1_TO_R7 ___D_R7 ___LD_R1_TO_R6 ___R_R7
#define ___ST_R1_TO_R7 ___ST_R1_TO_R6 ___W_R7

#if ___NB_GVM_REGS == 8

#define ___PUSH_REGS ___PUSH_R0 ___PUSH_R1_TO_R7
#define ___POP_REGS ___POP_R7_TO_R1 ___POP_R0

#endif
#endif
#endif
#endif
#endif
#endif
#endif

/*---------------------------------------------------------------------------*/

/* Labels and switches */

#define ___NOT(x)!x
#define ___AND(x,y)(x&&y)

#define ___MLBL(n)___lp+((n)*___LS*___WS)
#define ___LBL(n)___start+((___PH_LBL0-___HOST_LBL0+n)*___LS*___WS)
#define ___DEF_SLBL(n,lbl)case ___PH_LBL0-___HOST_LBL0+n:___DEF_GLBL(lbl)
#define ___DEF_GLBL(lbl)lbl:
#define ___GOTO(lbl)goto lbl;
#define ___IF_GOTO(test,lbl)if(test)___GOTO(lbl)
#define ___JUMPINT(nargs,prc,lbl)___SM(___GOTO(lbl),{nargs ___pc=prc;goto ___jump;})
#define ___JUMPEXTPRM(nargs,val){nargs ___pc=val;goto ___jumpext;}
#define ___JUMPEXT(nargs,val) \
{nargs ___SELF=val; \
___pc=((___label_struct*)(___SELF-___tSUBTYPED))->entry;goto ___jumpext;}
#define ___JUMPPRM(nargs,val){nargs ___pc=val;goto ___jump;}

#define ___JUMP(nargs,val) \
{nargs ___SELF=val; \
___pc=((___label_struct*)(___SELF-___tSUBTYPED))->entry;goto ___jump;}

#define ___JUMPGENNOTSAFE(nargs,val)___JUMP(nargs,val)
#define ___JUMPGLONOTSAFE(nargs,i,glo)___JUMP(nargs,___GLO(i,glo))
#define ___JUMPGENSAFE(nargs,val) \
{nargs ___SELF=val; \
if (___PROCEDUREP(___SELF)) \
  {___pc=((___label_struct*)(___SELF-___tSUBTYPED))->entry;goto ___jump;} \
___ps->temp1=___SELF;___JUMPEXTPRM(___NOTHING,___ps->handler_not_proc)}
#define ___JUMPGLOSAFE(nargs,i,glo) \
{nargs ___SELF=___GLO(i,glo); \
if (___PROCEDUREP(___SELF)) \
  {___pc=((___label_struct*)(___SELF-___tSUBTYPED))->entry;goto ___jump;} \
___ps->temp4=(___WORD)&___GLOSTRUCT(i,glo);___JUMPEXTPRM(___NOTHING,___ps->handler_not_proc_glo)}

#ifdef ___NOT_SAFE_CALLS
#undef ___JUMPGENSAFE
#undef ___JUMPGLOSAFE
#define ___JUMPGENSAFE(nargs,val)___JUMPGENNOTSAFE(nargs,val)
#define ___JUMPGLOSAFE(nargs,i,glo)___JUMPGLONOTSAFE(nargs,i,glo)
#endif

#ifdef ___SAFE_CALLS
#undef ___JUMPGENNOTSAFE
#undef ___JUMPGLONOTSAFE
#define ___JUMPGENNOTSAFE(nargs,val)___JUMPGENSAFE(nargs,val)
#define ___JUMPGLONOTSAFE(nargs,i,glo)___JUMPGLOSAFE(nargs,i,glo)
#endif

#ifdef ___SINGLE_HOST

#define ___BEGIN_M_SW ___BEGIN_SW
#define ___END_M_SW ___END_SW
#define ___BEGIN_P_SW
#define ___END_P_SW

#else

#define ___BEGIN_M_SW
#define ___END_M_SW
#define ___BEGIN_P_SW ___BEGIN_SW
#define ___END_P_SW ___END_SW

#endif

#define ___BEGIN_SW \
___pc=___ps->pc; \
___jump: \
switch((___pc-=___start)/(___LS*___WS)) \
{
#define ___END_SW \
}___pc+=___start;___jumpext:

/*---------------------------------------------------------------------------*/

#define ___PRC(i)___start+((i-___HOST_LBL0)*___LS*___WS)

#define ___SET_NARGS(n)___ps->na=n;

#define ___IF_NARGS_EQ(n,code)if(___ps->na==n){code}else

#define ___WRONG_NARGS(lbl,nb_req,nb_opt,nb_key) \
{___ps->temp1=___LBL(lbl); \
___JUMPEXTPRM(___NOTHING,___ps->handler_wrong_nargs)}

#define ___GET_REST(lbl,nb_req,nb_opt,nb_key) \
if(___ps->na>=0){___ps->temp1=___LBL(lbl); \
___JUMPEXTPRM(___NOTHING,___ps->handler_get_rest)}

#define ___GET_KEY(lbl,nb_req,nb_opt,nb_key,key_descr) \
if(___ps->na>=0){___ps->temp1=___LBL(lbl);___ps->temp2=nb_req+nb_opt; \
___ps->temp3=key_descr;___JUMPEXTPRM(___NOTHING,___ps->handler_get_key)}

#define ___GET_KEY_REST(lbl,nb_req,nb_opt,nb_key,key_descr) \
if(___ps->na>=0){___ps->temp1=___LBL(lbl);___ps->temp2=nb_req+nb_opt; \
___ps->temp3=key_descr;___JUMPEXTPRM(___NOTHING,___ps->handler_get_key_rest)}

#define ___BOOLEAN(x)(x)?___TRU:___FAL
#define ___EXPR(x)x;

#define ___ALLOC_CLO(n)(___hp+=n+2,___TAG((___hp-n-2),___tSUBTYPED))
#define ___BEGIN_SETUP_CLO(n,clo,lbl) \
{___WORD *___ptr=___UNTAG_AS(clo,___tSUBTYPED); \
___ptr[0]=___MAKE_HD_WORDS((n+1),___sPROCEDURE); ___ptr[1]=___LBL(lbl);
#define ___ADD_CLO_ELEM(i,val)___ptr[i+2]=(val);
#define ___END_SETUP_CLO(n) }
#define ___CLO(x,y)___BODY_AS(x,___tSUBTYPED)[y]
#define ___SET_CLO(x,y,z)___BODY_AS(x,___tSUBTYPED)[y]=z;

#define ___BEGIN_ALLOC_LIST(n,last)___CONS(last,___NUL);
#define ___ADD_LIST_ELEM(i,val)___CONS(val,___TAG((___hp-3),___tPAIR));
#define ___END_ALLOC_LIST(n)
#define ___GET_LIST(n) ___TAG((___hp-3),___tPAIR)

#define ___BEGIN_ALLOC_STRING(n) \
___hp[0]=___MAKE_HD_BYTES((n<<___LCS),___sSTRING);
#define ___ADD_STRING_ELEM(i,val)((___C*)(___hp+1))[i]=___INT(val);
#define ___END_ALLOC_STRING(n)___hp+=___WORDS((n<<___LCS))+1;
#define ___GET_STRING(n)___TAG((___hp-___WORDS((n<<___LCS))-1),___tSUBTYPED)

#define ___BEGIN_ALLOC_U8VECTOR(n) \
___hp[0]=___MAKE_HD_BYTES(n,___sU8VECTOR);
#define ___ADD_U8VECTOR_ELEM(i,val)((___U8*)(___hp+1))[i]=___INT(val);
#define ___END_ALLOC_U8VECTOR(n)___hp+=___WORDS(n)+1;
#define ___GET_U8VECTOR(n)___TAG((___hp-___WORDS(n)-1),___tSUBTYPED)

#define ___BEGIN_ALLOC_U16VECTOR(n) \
___hp[0]=___MAKE_HD_BYTES((n<<1),___sU16VECTOR);
#define ___ADD_U16VECTOR_ELEM(i,val)((___U16*)(___hp+1))[i]=___INT(val);
#define ___END_ALLOC_U16VECTOR(n)___hp+=___WORDS((n<<1))+1;
#define ___GET_U16VECTOR(n)___temp=___TAG((___hp-___WORDS((n<<1))-1),___tSUBTYPED)

#define ___BEGIN_ALLOC_U32VECTOR(n) \
___hp[0]=___MAKE_HD_BYTES((n<<2),___sU32VECTOR);
#define ___ADD_U32VECTOR_ELEM(i,val)((___U32*)(___hp+1))[i]=___U32UNBOX(val);
#define ___END_ALLOC_U32VECTOR(n)___hp+=___WORDS((n<<2))+1;
#define ___GET_U32VECTOR(n)___temp=___TAG((___hp-___WORDS((n<<2))-1),___tSUBTYPED)

#define ___BEGIN_ALLOC_F32VECTOR(n) \
___hp[0]=___MAKE_HD_BYTES((n<<2),___sF32VECTOR);
#define ___ADD_F32VECTOR_ELEM(i,val)((___F32*)(___hp+1))[i]=(val);
#define ___END_ALLOC_F32VECTOR(n)___hp+=___WORDS((n<<2))+1;
#define ___GET_F32VECTOR(n)___temp=___TAG((___hp-___WORDS((n<<2))-1),___tSUBTYPED)

#if ___WS == 4

#define ___BEGIN_ALLOC_F64VECTOR(n) \
{___WORD *___ptr = (___WORD*)((___WORD)(___hp+2)&~7); \
___ptr[-1]=___MAKE_HD_BYTES((n<<3),___sF64VECTOR);
#define ___ADD_F64VECTOR_ELEM(i,val)((___F64*)___ptr)[i]=(val);
#define ___END_ALLOC_F64VECTOR(n)___hp+=___WORDS((n<<3))+2;}
#define ___GET_F64VECTOR(n)___temp=___TAG((((___WORD*)((___WORD)(___hp-___WORDS((n<<3)))&~7))-1),___tSUBTYPED)

#else

#define ___BEGIN_ALLOC_F64VECTOR(n) \
___hp[0]=___MAKE_HD_BYTES((n<<3),___sF64VECTOR);
#define ___ADD_F64VECTOR_ELEM(i,val)((___F64*)(___hp+1))[i]=(val);
#define ___END_ALLOC_F64VECTOR(n)___hp+=___WORDS((n<<3))+1;
#define ___GET_F64VECTOR(n)___temp=___TAG((___hp-___WORDS((n<<3))-1),___tSUBTYPED)

#endif

#define ___BEGIN_ALLOC_VECTOR(n)___hp[0]=___MAKE_HD_WORDS(n,___sVECTOR);
#define ___ADD_VECTOR_ELEM(i,val)___hp[i+1]=(val);
#define ___END_ALLOC_VECTOR(n)___hp+=n+1;
#define ___GET_VECTOR(n)___temp=___TAG((___hp-n-1),___tSUBTYPED)

#define ___POLL(n)if(___fp<___ps->stack_trip) \
{___ps->temp1=___LBL(n);___JUMPEXTPRM(___NOTHING,___ps->handler_stack_limit)}

#define ___TASK_PUSH(i)
#define ___TASK_POP(n)

#define ___CHECK_HEAP(n,m)if(___hp>___ps->heap_limit) \
{___ps->temp1=___LBL(n);___JUMPEXTPRM(___NOTHING,___ps->handler_heap_limit)}

#define ___FORCE1(n,src) \
if (___TYP((___temp=(src)))==___tSUBTYPED&&___SUBTYPE(___temp)==___sPROMISE<<___TB){___ps->temp1=___LBL(n);___ps->temp2=___temp;___JUMPEXTPRM(___NOTHING,___ps->handler_force);
#define ___FORCE2 ___temp=___ps->temp2;}
#define ___FORCE3 ___temp

#define ___NB_INTRS 3
#define ___INTR_USER  0
#define ___INTR_TIMER 1
#define ___INTR_GC    2

#define ___IO_DEFAULT_ENCODING 0
#define ___IO_CHAR_ENCODING    1
#define ___IO_LATIN1_ENCODING  2
#define ___IO_UTF8_ENCODING    3
#define ___IO_BYTE_ENCODING    4
#define ___IO_UCS2_ENCODING    5
#define ___IO_UCS4_ENCODING    6

#define ___MODULE_KIND 0
#define ___LINKFILE_KIND 1

#define ___CLIBEXT(f)f
#define ___SETJMP(x)setjmp(x)
#define ___EXT(f)f

#ifdef ___BIND_LATE

#ifdef ___CANT_IMPORT_CLIB_DYNAMICALLY
#undef ___CLIBEXT
#define ___CLIBEXT(f)___GSTATE->f
#undef ___LOCAL_GSTATE
#define ___LOCAL_GSTATE
#endif

#ifdef ___CANT_IMPORT_SETJMP_DYNAMICALLY
#undef ___SETJMP
#define ___SETJMP(x)___GSTATE->setjmp(x)
#endif

#ifdef ___CANT_IMPORT_DYNAMICALLY
#undef ___EXT
#define ___EXT(f)___GSTATE->f
#undef ___LOCAL_GSTATE
#define ___LOCAL_GSTATE
#endif

#endif

#ifdef ___LOCAL_GSTATE

#define ___GSTATE ___local_gstate
#define ___GSTATE_DECL ___LOCAL ___global_state_struct *___local_gstate;
#define ___SET_LOCAL_GSTATE(gs) ___local_gstate = gs;

#else

#define ___GSTATE (&___gstate)
#define ___GSTATE_DECL ___IMP_DATA(___global_state_struct,___gstate);
#define ___SET_LOCAL_GSTATE(gs)

#endif

#define ___PSTATE (&___GSTATE->pstate)

#ifdef ___BIND_LATE

#define ___NEED_SYM(sym)
#define ___NEED_KEY(key)
#define ___NEED_GLO(glo)

#define ___BEGIN_SYM1 ___LOCAL ___UTF8STRING ___sym_names[]={
#define ___DEF_SYM1(i,sym,str)str,
#define ___END_SYM1 0};

#define ___DEF_SYM2(i,sym,str)

#define ___BEGIN_KEY1 ___LOCAL ___UTF8STRING ___key_names[]={
#define ___DEF_KEY1(i,key,str)str,
#define ___END_KEY1 0};

#define ___DEF_KEY2(i,key,str)

#define ___BEGIN_GLO ___LOCAL ___UTF8STRING ___glo_names[]={
#define ___DEF_GLO(i,str)str,
#define ___END_GLO 0};

#define ___BEGIN_OLD_KEY
#define ___DEF_OLD_KEY(key)
#define ___END_OLD_KEY

#define ___BEGIN_OLD_SYM_GLO
#define ___DEF_OLD_SYM_GLO(sym,glo)
#define ___END_OLD_SYM_GLO

#define ___BEGIN_NEW_KEY
#define ___DEF_NEW_KEY(prevkey,key,str,hash)
#define ___END_NEW_KEY

#define ___BEGIN_NEW_SYM_GLO
#define ___DEF_NEW_SYM_GLO_SUP(prevsym,sym,str,hash,glo)
#define ___DEF_NEW_SYM_GLO(prevsym,sym,str,hash,glo)
#define ___END_NEW_SYM_GLO(prevsym,prevkey)___LINKFILE_DESCR(0,0)

#define ___DEF_SUB_NSTR(id,n)
#define ___NSTR0
#define ___NSTR1(a)
#define ___NSTR2(a,b)
#define ___NSTR3(a,b,c)
#define ___NSTR4(a,b,c,d)
#define ___NSTR5(a,b,c,d,e)
#define ___NSTR6(a,b,c,d,e,f)
#define ___NSTR7(a,b,c,d,e,f,g)
#define ___NSTR8(a,b,c,d,e,f,g,h)

#else

#define ___NEED_SYM(sym)___IMP_DATA(___symkey_struct,sym);
#define ___NEED_KEY(key)___IMP_DATA(___symkey_struct,key);
#define ___NEED_GLO(glo)___IMP_DATA(___glo_struct,glo);

#ifdef ___IMPORTED_ADR_NOT_CONST

#define ___BEGIN_SYM1 ___LOCAL ___FAKEWORD ___sym_tbl[___SYM_COUNT];
#define ___DEF_SYM1(i,sym,str)
#define ___END_SYM1

#define ___DEF_SYM2(i,sym,str)___sym_tbl[i]=(___FAKEWORD)(sym);

#define ___BEGIN_KEY1 ___LOCAL ___FAKEWORD ___key_tbl[___KEY_COUNT];
#define ___DEF_KEY1(i,key,str)
#define ___END_KEY1

#define ___DEF_KEY2(i,key,str)___key_tbl[i]=(___FAKEWORD)(key);

#else

#define ___BEGIN_SYM1 ___LOCAL ___FAKEWORD ___sym_tbl[]={
#define ___DEF_SYM1(i,sym,str)(___FAKEWORD)(sym),
#define ___END_SYM1 0};

#define ___DEF_SYM2(i,sym,str)

#define ___BEGIN_KEY1 ___LOCAL ___FAKEWORD ___key_tbl[]={
#define ___DEF_KEY1(i,key,str)(___FAKEWORD)(key),
#define ___END_KEY1 0};

#define ___DEF_KEY2(i,key,str)

#endif

#define ___BEGIN_GLO
#define ___DEF_GLO(i,str)
#define ___END_GLO

#define ___BEGIN_OLD_KEY
#define ___DEF_OLD_KEY(key)
#define ___END_OLD_KEY

#define ___BEGIN_OLD_SYM_GLO
#define ___DEF_OLD_SYM_GLO(sym,glo)
#define ___END_OLD_SYM_GLO

#define ___BEGIN_NEW_KEY
#define ___DEF_NEW_KEY(prevkey,key,str,hash) \
___EXP_DATA(___symkey_struct,key)={(___FAKEWORD)prevkey,(___FAKEWORD)str,0 ___PADDING};
#define ___END_NEW_KEY

#define ___BEGIN_NEW_SYM_GLO
#define ___DEF_NEW_SYM_GLO_SUP(prevsym,sym,str,hash,glo) \
___EXP_DATA(___glo_struct,glo) = {___UNB2, ___FIX(hash), 0}; \
___EXP_DATA(___symkey_struct,sym)={(___FAKEWORD)prevsym,(___FAKEWORD)str,0,(___FAKEWORD)&glo ___PADDING};
#define ___DEF_NEW_SYM_GLO(prevsym,sym,str,hash,glo) \
___EXP_DATA(___glo_struct,glo) = {___UNB1, ___FIX(hash), 0}; \
___EXP_DATA(___symkey_struct,sym)={(___FAKEWORD)prevsym,(___FAKEWORD)str,0,(___FAKEWORD)&glo ___PADDING};
#define ___END_NEW_SYM_GLO(prevsym,prevkey)___LINKFILE_DESCR(prevsym,prevkey)

#define ___DEF_SUB_NSTR(id,n) ___DEF_SUB_STR(id,n)
#define ___NSTR0 ___STR0
#define ___NSTR1(a) ___STR1(a)
#define ___NSTR2(a,b) ___STR2(a,b)
#define ___NSTR3(a,b,c) ___STR3(a,b,c)
#define ___NSTR4(a,b,c,d) ___STR4(a,b,c,d)
#define ___NSTR5(a,b,c,d,e) ___STR5(a,b,c,d,e)
#define ___NSTR6(a,b,c,d,e,f) ___STR6(a,b,c,d,e,f)
#define ___NSTR7(a,b,c,d,e,f,g) ___STR7(a,b,c,d,e,f,g)
#define ___NSTR8(a,b,c,d,e,f,g,h) ___STR8(a,b,c,d,e,f,g,h)

#endif

#define ___BEGIN_CNS \
___LOCAL ___WORD ___cns_tbl[]={
#define ___DEF_CNS(car,cdr)___MAKE_HD((___PAIR_SIZE<<___LWS),___sPAIR,___PERM),cdr,car
#define ___END_CNS ___PADDING};

#define ___BEGIN_SUB \
___LOCAL ___FAKEWORD ___sub_tbl[]={
#define ___DEF_SUB(id)___CAST_WORDSTAR_TO_FAKEWORD(id)
#define ___END_SUB };

#define ___DEF_SUB_VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<___LWS),___sVECTOR,___PERM)

#define ___DEF_SUB_STR(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<___LCS),___sSTRING,___PERM)

#define ___DEF_SUB_BIG(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<1),___sBIGNUM,___PERM)

#define ___DEF_SUB_BIGFIX(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<1),___sBIGNUM,___PERM)

#define ___DEF_SUB_RAT(id,num,den) \
___LOCAL ___WORD id[]={___MAKE_HD((___RATNUM_SIZE<<___LWS),___sRATNUM,___PERM),num,den ___PADDING};

#define ___DEF_SUB_FLO(id,hi,lo) \
___LOCAL ___WORD id[]={___MAKE_HD((___FLONUM_SIZE<<___LWS),___sFLONUM,___PERM), \
___FLO2(hi,lo) ___PADDING_FLO};

#if ___FLONUM_SIZE == 1

#define ___FLO2(hi,lo)((___WORD)hi<<32)+(___U32)lo

#else

#ifdef ___CPU_BIGEND
#define ___FLO2(hi,lo)hi,lo
#else
#define ___FLO2(hi,lo)lo,hi
#endif

#endif

#define ___DEF_SUB_CPX(id,real,imag) \
___LOCAL ___WORD id[]={___MAKE_HD((___CPXNUM_SIZE<<___LWS),___sCPXNUM,___PERM),real,imag ___PADDING};

#define ___DEF_SUB_U8VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD(n,___sU8VECTOR,___PERM)

#define ___DEF_SUB_U16VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<1),___sU16VECTOR,___PERM)

#define ___DEF_SUB_U32VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<2),___sU32VECTOR,___PERM)

#define ___DEF_SUB_F32VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<2),___sF32VECTOR,___PERM)

#define ___DEF_SUB_F64VEC(id,n) \
___LOCAL ___WORD id[]={___MAKE_HD((n<<3),___sF64VECTOR,___PERM)

#if ___WS == 4

#if ___CS == 1

#ifdef ___CPU_BIGEND
#define ___S4(a,b,c,d)((((___WORD)(___C)a<<8)+(___WORD)(___C)b<<8)+(___WORD)(___C)c<<8)+(___WORD)(___C)d
#else
#define ___S4(d,c,b,a)((((___WORD)(___C)a<<8)+(___WORD)(___C)b<<8)+(___WORD)(___C)c<<8)+(___WORD)(___C)d
#endif

#else

#if ___CS == 2

#ifdef ___CPU_BIGEND
#define ___S4(a,b,c,d)((___WORD)(___C)a<<16)+(___WORD)(___C)b,((___WORD)(___C)c<<16)+(___WORD)(___C)d
#else
#define ___S4(b,a,d,c)((___WORD)(___C)a<<16)+(___WORD)(___C)b,((___WORD)(___C)c<<16)+(___WORD)(___C)d
#endif

#else

#define ___S4(a,b,c,d)a,b,c,d

#endif

#endif

#define ___STR0 ___PADDING};
#define ___STR1(a),___S4(a,0,0,0) ___PADDING};
#define ___STR2(a,b),___S4(a,b,0,0) ___PADDING};
#define ___STR3(a,b,c),___S4(a,b,c,0) ___PADDING};
#define ___STR4(a,b,c,d),___S4(a,b,c,d) ___PADDING};
#define ___STR5(a,b,c,d,e),___S4(a,b,c,d),___S4(e,0,0,0) ___PADDING};
#define ___STR6(a,b,c,d,e,f),___S4(a,b,c,d),___S4(e,f,0,0) ___PADDING};
#define ___STR7(a,b,c,d,e,f,g),___S4(a,b,c,d),___S4(e,f,g,0) ___PADDING};
#define ___STR8(a,b,c,d,e,f,g,h),___S4(a,b,c,d),___S4(e,f,g,h)

#ifdef ___CPU_BIGEND
#define ___B2(a,b)((___WORD)(___U16)a<<16)+(___WORD)(___U16)b
#else
#define ___B2(b,a)((___WORD)(___U16)a<<16)+(___WORD)(___U16)b
#endif

#define ___BIG0 ___PADDING};
#define ___BIG1(a),___B2(a,0) ___PADDING};
#define ___BIG2(a,b),___B2(a,b) ___PADDING};
#define ___BIG3(a,b,c),___B2(a,b),___B2(c,0) ___PADDING};
#define ___BIG4(a,b,c,d),___B2(a,b),___B2(c,d)

#define ___BIGFIX0 ___PADDING};
#define ___BIGFIX1(a),___B2(a,0) ___PADDING};
#define ___BIGFIX2(a,b),___B2(a,b) ___PADDING};
#define ___BIGFIX3(a,b,c),___B2(a,b),___B2(c,0) ___PADDING};
#define ___BIGFIX4(a,b,c,d),___B2(a,b),___B2(c,d)

#ifdef ___CPU_BIGEND
#define ___P8(a,b,c,d)((((___WORD)(___U8)a<<8)+(___WORD)(___U8)b<<8)+(___WORD)(___U8)c<<8)+(___WORD)(___U8)d
#else
#define ___P8(d,c,b,a)((((___WORD)(___U8)a<<8)+(___WORD)(___U8)b<<8)+(___WORD)(___U8)c<<8)+(___WORD)(___U8)d
#endif

#define ___U8VEC0 ___PADDING};
#define ___U8VEC1(a),___P8(a,0,0,0) ___PADDING};
#define ___U8VEC2(a,b),___P8(a,b,0,0) ___PADDING};
#define ___U8VEC3(a,b,c),___P8(a,b,c,0) ___PADDING};
#define ___U8VEC4(a,b,c,d),___P8(a,b,c,d) ___PADDING};
#define ___U8VEC5(a,b,c,d,e),___P8(a,b,c,d),___P8(e,0,0,0) ___PADDING};
#define ___U8VEC6(a,b,c,d,e,f),___P8(a,b,c,d),___P8(e,f,0,0) ___PADDING};
#define ___U8VEC7(a,b,c,d,e,f,g),___P8(a,b,c,d),___P8(e,f,g,0) ___PADDING};
#define ___U8VEC8(a,b,c,d,e,f,g,h),___P8(a,b,c,d),___P8(e,f,g,h)

#ifdef ___CPU_BIGEND
#define ___P16(a,b)((___WORD)(___U16)a<<16)+(___WORD)(___U16)b
#else
#define ___P16(b,a)((___WORD)(___U16)a<<16)+(___WORD)(___U16)b
#endif

#define ___U16VEC0 ___PADDING};
#define ___U16VEC1(a),___P16(a,0) ___PADDING};
#define ___U16VEC2(a,b),___P16(a,b) ___PADDING};
#define ___U16VEC3(a,b,c),___P16(a,b),___P16(c,0) ___PADDING};
#define ___U16VEC4(a,b,c,d),___P16(a,b),___P16(c,d)

#define ___U32VEC0 ___PADDING};
#define ___U32VEC1(a),a ___PADDING};
#define ___U32VEC2(a,b),a,b

#define ___F32VEC0 ___PADDING};
#define ___F32VEC1(a),a ___PADDING};
#define ___F32VEC2(a,b),a,b

#else

#if ___CS == 1

#ifdef ___CPU_BIGEND
#define ___S8(a,b,c,d,e,f,g,h)(((((((((___WORD)(___C)a<<8)+(___WORD)(___C)b<<8)+(___WORD)(___C)c<<8)+(___WORD)(___C)d<<8)+(___WORD)(___C)e<<8)+(___WORD)(___C)f<<8)+(___WORD)(___C)g<<8)+(___WORD)(___C)h)
#else
#define ___S8(h,g,f,e,d,c,b,a)(((((((((___WORD)(___C)a<<8)+(___WORD)(___C)b<<8)+(___WORD)(___C)c<<8)+(___WORD)(___C)d<<8)+(___WORD)(___C)e<<8)+(___WORD)(___C)f<<8)+(___WORD)(___C)g<<8)+(___WORD)(___C)h)
#endif

#else

#if ___CS == 2

#ifdef ___CPU_BIGEND
#define ___S8(a,b,c,d,e,f,g,h)((((___WORD)(___C)a<<16)+(___WORD)(___C)b<<16)+(___WORD)(___C)c<<16)+(___WORD)(___C)d,((((___WORD)(___C)e<<16)+(___WORD)(___C)f<<16)+(___WORD)(___C)g<<16)+(___WORD)(___C)h
#else
#define ___S8(d,c,b,a,h,g,f,e)((((___WORD)(___C)a<<16)+(___WORD)(___C)b<<16)+(___WORD)(___C)c<<16)+(___WORD)(___C)d,((((___WORD)(___C)e<<16)+(___WORD)(___C)f<<16)+(___WORD)(___C)g<<16)+(___WORD)(___C)h
#endif

#else

#ifdef ___CPU_BIGEND
#define ___S8(a,b,c,d,e,f,g,h)((___WORD)(___C)a<<32)+(___WORD)(___C)b,((___WORD)(___C)c<<32)+(___WORD)(___C)d,((___WORD)(___C)e<<32)+(___WORD)(___C)f,((___WORD)(___C)g<<32)+(___WORD)(___C)h
#else
#define ___S8(b,a,d,c,f,e,h,g)((___WORD)(___C)a<<32)+(___WORD)(___C)b,((___WORD)(___C)c<<32)+(___WORD)(___C)d,((___WORD)(___C)e<<32)+(___WORD)(___C)f,((___WORD)(___C)g<<32)+(___WORD)(___C)h
#endif

#endif

#endif

#define ___STR0 ___PADDING};
#define ___STR1(a),___S8(a,0,0,0,0,0,0,0) ___PADDING};
#define ___STR2(a,b),___S8(a,b,0,0,0,0,0,0) ___PADDING};
#define ___STR3(a,b,c),___S8(a,b,c,0,0,0,0,0) ___PADDING};
#define ___STR4(a,b,c,d),___S8(a,b,c,d,0,0,0,0) ___PADDING};
#define ___STR5(a,b,c,d,e),___S8(a,b,c,d,e,0,0,0) ___PADDING};
#define ___STR6(a,b,c,d,e,f),___S8(a,b,c,d,e,f,0,0) ___PADDING};
#define ___STR7(a,b,c,d,e,f,g),___S8(a,b,c,d,e,f,g,0) ___PADDING};
#define ___STR8(a,b,c,d,e,f,g,h),___S8(a,b,c,d,e,f,g,h)

#ifdef ___CPU_BIGEND
#define ___B4(a,b,c,d)((((___WORD)(___U16)a<<16)+(___WORD)(___U16)b<<16)+(___WORD)(___U16)c<<16)+(___WORD)(___U16)d
#else
#define ___B4(d,c,b,a)((((___WORD)(___U16)a<<16)+(___WORD)(___U16)b<<16)+(___WORD)(___U16)c<<16)+(___WORD)(___U16)d
#endif

#define ___BIG0 ___PADDING};
#define ___BIG1(a),___B4(a,0,0,0) ___PADDING};
#define ___BIG2(a,b),___B4(a,b,0,0) ___PADDING};
#define ___BIG3(a,b,c),___B4(a,b,c,0) ___PADDING};
#define ___BIG4(a,b,c,d),___B4(a,b,c,d)

#define ___BIGEND0 ___PADDING};
#define ___BIGEND1(a),___B4(a,0,0,0) ___PADDING};
#define ___BIGEND2(a,b),___B4(a,b,0,0) ___PADDING};
#define ___BIGEND3(a,b,c),___B4(a,b,c,0) ___PADDING};
#define ___BIGEND4(a,b,c,d),___B4(a,b,c,d)

#ifdef ___CPU_BIGEND
#define ___P8(a,b,c,d,e,f,g,h)((((((((___WORD)(___U8)a<<8)+(___WORD)(___U8)b<<8)+(___WORD)(___U8)c<<8)+(___WORD)(___U8)d<<8)+(___WORD)(___U8)e<<8)+(___WORD)(___U8)f<<8)+(___WORD)(___U8)g<<8)+(___WORD)(___U8)h
#else
#define ___P8(h,g,f,e,d,c,b,a)((((((((___WORD)(___U8)a<<8)+(___WORD)(___U8)b<<8)+(___WORD)(___U8)c<<8)+(___WORD)(___U8)d<<8)+(___WORD)(___U8)e<<8)+(___WORD)(___U8)f<<8)+(___WORD)(___U8)g<<8)+(___WORD)(___U8)h
#endif

#define ___U8VEC0 ___PADDING};
#define ___U8VEC1(a),___P8(a,0,0,0,0,0,0,0) ___PADDING};
#define ___U8VEC2(a,b),___P8(a,b,0,0,0,0,0,0) ___PADDING};
#define ___U8VEC3(a,b,c),___P8(a,b,c,0,0,0,0,0) ___PADDING};
#define ___U8VEC4(a,b,c,d),___P8(a,b,c,d,0,0,0,0) ___PADDING};
#define ___U8VEC5(a,b,c,d,e),___P8(a,b,c,d,e,0,0,0) ___PADDING};
#define ___U8VEC6(a,b,c,d,e,f),___P8(a,b,c,d,e,f,0,0) ___PADDING};
#define ___U8VEC7(a,b,c,d,e,f,g),___P8(a,b,c,d,e,f,g,0) ___PADDING};
#define ___U8VEC8(a,b,c,d,e,f,g,h),___P8(a,b,c,d,e,f,g,h)

#ifdef ___CPU_BIGEND
#define ___P16(a,b,c,d)((((___WORD)(___U16)a<<16)+(___WORD)(___U16)b<<16)+(___WORD)(___U16)c<<16)+(___WORD)(___U16)d
#else
#define ___P16(d,c,b,a)((((___WORD)(___U16)a<<16)+(___WORD)(___U16)b<<16)+(___WORD)(___U16)c<<16)+(___WORD)(___U16)d
#endif

#define ___U16VEC0 ___PADDING};
#define ___U16VEC1(a),___P16(a,0,0,0) ___PADDING};
#define ___U16VEC2(a,b),___P16(a,b,0,0) ___PADDING};
#define ___U16VEC3(a,b,c),___P16(a,b,c,0) ___PADDING};
#define ___U16VEC4(a,b,c,d),___P16(a,b,c,d)

#ifdef ___CPU_BIGEND
#define ___P32(a,b)((___WORD)(___U32)a<<32)+(___WORD)(___U32)b
#else
#define ___P32(b,a)((___WORD)(___U32)a<<32)+(___WORD)(___U32)b
#endif

#define ___U32VEC0 ___PADDING};
#define ___U32VEC1(a),___P32(a,0) ___PADDING};
#define ___U32VEC2(a,b),___P32(a,b)

#define ___F32VEC0 ___PADDING};
#define ___F32VEC1(a),___P32(a,0) ___PADDING};
#define ___F32VEC2(a,b),___P32(a,b)

#endif

#define ___F64VEC0 ___PADDING_FLO};
#define ___F64VEC1(hi,lo),___FLO2(hi,lo)

#define ___VEC0 ___PADDING};
#define ___VEC1(a),a

#define ___MAKE_PROC_INFO(nbparms,nbclosed)(nbclosed<<17)+(nbparms<<3)+1
#define ___PROC_INFO_NBPARMS(x)(((x)>>3)&((1<<14)-1))
#define ___PROC_INFO_NBCLOSED(x)(((x)>>17)&((1<<14)-1))

#define ___MAKE_RETN_INFO(fs,link)(link<<17)+(fs<<3)+3
#define ___RETN_INFO_FS(x)(((x)>>3)&((1<<14)-1))
#define ___RETN_INFO_LINK(x)(((x)>>17)&((1<<14)-1))

#define ___MAKE_RETT_INFO(fs,link)(link<<17)+(fs<<3)+4
#define ___RETT_INFO_FS(x)(((x)>>3)&((1<<14)-1))
#define ___RETT_INFO_LINK(x)(((x)>>17)&((1<<14)-1))

#define ___MAKE_RETI_INFO(fs,link)(link<<17)+((fs+___NB_GVM_REGS+1)<<3)+7
#define ___RETI_INFO_FS(x)(((x)>>3)&((1<<14)-1))
#define ___RETI_INFO_LINK(x)(((x)>>17)&((1<<14)-1))

#define ___BEGIN_LBL \
___LOCAL ___label_struct ___lbl_tbl[]={
#define ___DEF_LBL_INTRO(id,info,cproc){___MAKE_HD((___INTRO_SIZE<<___LWS),___sVECTOR,___PERM),info,0,___CAST_HOST_TO_FAKEHOST((___host)cproc)}
#define ___DEF_LBL_PROC(id,nbp,nbc){___MAKE_HD((3<<___LWS),___sPROCEDURE,___PERM),0,___MAKE_PROC_INFO(nbp,nbc),___CAST_HOST_TO_FAKEHOST(___SM(___MH_PROC,id))}
#define ___DEF_LBL_RETN(id,fs,link){___MAKE_HD((3<<___LWS),___sPROCEDURE,___PERM),0,___MAKE_RETN_INFO(fs,link),___CAST_HOST_TO_FAKEHOST(___SM(___MH_PROC,id))}
#define ___DEF_LBL_RETT(id,fs,link){___MAKE_HD((3<<___LWS),___sPROCEDURE,___PERM),0,___MAKE_RETT_INFO(fs,link),___CAST_HOST_TO_FAKEHOST(___SM(___MH_PROC,id))}
#define ___DEF_LBL_RETI(id,fs,link){___MAKE_HD((3<<___LWS),___sPROCEDURE,___PERM),0,___MAKE_RETI_INFO(fs,link),___CAST_HOST_TO_FAKEHOST(___SM(___MH_PROC,id))}
#define ___END_LBL ___PADDING_LBL};

#ifdef ___GLO_COUNT
#ifdef ___BIND_LATE
#define ___GLO_DECL ___LOCAL ___FAKEWORD ___glo_tbl[___GLO_COUNT];
#define ___GLO_TBL ___glo_tbl,___GLO_COUNT,___SUP_COUNT,___glo_names
#else
#define ___GLO_DECL
#define ___GLO_TBL 0,0,0,0
#endif
#else
#define ___GLO_DECL
#define ___GLO_TBL 0,0,0,0
#endif

#ifdef ___SYM_COUNT
#ifdef ___BIND_LATE
#define ___SYM_DECL ___LOCAL ___FAKEWORD ___sym_tbl[___SYM_COUNT];
#define ___SYM_TBL ___sym_tbl,___SYM_COUNT,___sym_names
#else
#define ___SYM_DECL
#define ___SYM_TBL ___sym_tbl,___SYM_COUNT,0
#endif
#else
#define ___SYM_DECL
#define ___SYM_TBL 0,0,0
#endif

#ifdef ___KEY_COUNT
#ifdef ___BIND_LATE
#define ___KEY_DECL ___LOCAL ___FAKEWORD ___key_tbl[___KEY_COUNT];
#define ___KEY_TBL ___key_tbl,___KEY_COUNT,___key_names
#else
#define ___KEY_DECL
#define ___KEY_TBL ___key_tbl,___KEY_COUNT,0
#endif
#else
#define ___KEY_DECL
#define ___KEY_TBL 0,0,0
#endif

#ifdef ___LBL_COUNT
#define ___LBL_TBL &___lp,___lbl_tbl,___LBL_COUNT
#else
#define ___LBL_TBL 0,0,0
#endif

#ifdef ___CNS_COUNT
#define ___CNS_TBL ___cns_tbl,___CNS_COUNT
#else
#define ___CNS_TBL 0,0
#endif

#ifdef ___SUB_COUNT
#define ___SUB_TBL ___sub_tbl,___SUB_COUNT
#else
#define ___SUB_TBL 0,0
#endif

#define ___BEGIN_MOD1 ___LOCAL void ___init_proc ___PVOID{
#define ___DEF_PRM(i,glo,n)___PRM(i,glo)=___GLO(i,glo)=___MLBL(n);
#define ___END_MOD1 }

#define ___BEGIN_MOD2 ___LOCAL ___module_struct ___module_descr={ \
___VERSION,___MODULE_KIND,___MODULE_NAME, \
___GLO_TBL,___SYM_TBL,___KEY_TBL,___LBL_TBL,___CNS_TBL,___SUB_TBL, \
___init_proc,0}; \
___BEGIN_C_LINKAGE ___EXP_FUNC(___mod_or_lnk,___LINKER_ID) \
   ___P((___global_state_struct *___gs),(___gs) \
___global_state_struct *___gs;) \
{ ___SET_LOCAL_GSTATE(___gs)
#define ___END_MOD2 return (___mod_or_lnk)&___module_descr;} ___END_C_LINKAGE

#ifndef ___LIBRARY
#define ___MAIN_PROC \
___IMP_FUNC(int,___main) \
  ___P((int argc, \
        char **argv, \
        ___mod_or_lnk (*linker)(___global_state_struct*)), \
       ()); \
int main ___P((int argc, char **argv),(argc, argv) \
int argc; char **argv;) \
{ return ___main (argc, argv, ___LINKER_ID); }
#else
#define ___MAIN_PROC
#endif

#define ___LINKFILE_DESCR(sym_list,key_list) \
___LOCAL ___linkfile_struct ___linkfile_descr={ \
___VERSION,___LINKFILE_KIND,___LINKFILE_NAME, \
sym_list,key_list,___linker_tbl}; \
___BEGIN_C_LINKAGE ___EXP_FUNC(___mod_or_lnk,___LINKER_ID) \
   ___P((___global_state_struct *___gs),(___gs) \
___global_state_struct *___gs;) \
{ ___SET_LOCAL_GSTATE(___gs) return (___mod_or_lnk)&___linkfile_descr;} \
___END_C_LINKAGE ___MAIN_PROC

#define ___BEGIN_OLD_LNK
#define ___DEF_OLD_LNK(id)___BEGIN_C_LINKAGE ___IMP_FUNC(___mod_or_lnk,id) \
___P((___global_state_struct *___gs),()); ___END_C_LINKAGE
#define ___END_OLD_LNK

#define ___BEGIN_NEW_LNK
#define ___DEF_NEW_LNK(id)___BEGIN_C_LINKAGE ___mod_or_lnk id \
___P((___global_state_struct *___gs),()); ___END_C_LINKAGE
#define ___END_NEW_LNK

#define ___BEGIN_LNK ___LOCAL void *___linker_tbl[]={
#define ___DEF_LNK(id)(void*)id
#define ___END_LNK ,0};

/*
 * ___NO_ERR must be 0.
 */
 
#define ___NO_ERR                 0
#define ___UNWIND_C_STACK         ((3<<13)+0)
#define ___CDEF_HEAP_OVERFLOW_ERR ((3<<13)+1)
#define ___FIRST_C_CONV_ERR       ___STOC_CHAR_ERR
#define ___STOC_CHAR_ERR          ((3<<13)+(1<<7))
#define ___STOC_SCHAR_ERR         ((3<<13)+(2<<7))
#define ___STOC_UCHAR_ERR         ((3<<13)+(3<<7))
#define ___STOC_LATIN1_ERR        ((3<<13)+(4<<7))
#define ___STOC_UCS4_ERR          ((3<<13)+(5<<7))
#define ___STOC_UCS2_ERR          ((3<<13)+(6<<7))
#define ___STOC_SHORT_ERR         ((3<<13)+(7<<7))
#define ___STOC_USHORT_ERR        ((3<<13)+(8<<7))
#define ___STOC_INT_ERR           ((3<<13)+(9<<7))
#define ___STOC_UINT_ERR          ((3<<13)+(10<<7))
#define ___STOC_LONG_ERR          ((3<<13)+(11<<7))
#define ___STOC_ULONG_ERR         ((3<<13)+(12<<7))
#define ___STOC_FLOAT_ERR         ((3<<13)+(13<<7))
#define ___STOC_DOUBLE_ERR        ((3<<13)+(14<<7))
#define ___STOC_POINTER_ERR       ((3<<13)+(15<<7))
#define ___STOC_FUNCTION_ERR      ((3<<13)+(16<<7))
#define ___STOC_BOOL_ERR          ((3<<13)+(17<<7))
#define ___STOC_CHARSTRING_ERR    ((3<<13)+(18<<7))
#define ___STOC_LATIN1STRING_ERR  ((3<<13)+(19<<7))
#define ___STOC_UCS4STRING_ERR    ((3<<13)+(20<<7))
#define ___STOC_UCS2STRING_ERR    ((3<<13)+(21<<7))
#define ___STOC_UTF8STRING_ERR    ((3<<13)+(22<<7))
#define ___STOC_HEAP_OVERFLOW_ERR ((3<<13)+(23<<7))
#define ___CTOS_CHAR_ERR          ((3<<13)+(31<<7))
#define ___CTOS_SCHAR_ERR         ((3<<13)+(32<<7))
#define ___CTOS_UCHAR_ERR         ((3<<13)+(33<<7))
#define ___CTOS_LATIN1_ERR        ((3<<13)+(34<<7))
#define ___CTOS_UCS4_ERR          ((3<<13)+(35<<7))
#define ___CTOS_UCS2_ERR          ((3<<13)+(36<<7))
#define ___CTOS_SHORT_ERR         ((3<<13)+(37<<7))
#define ___CTOS_USHORT_ERR        ((3<<13)+(38<<7))
#define ___CTOS_INT_ERR           ((3<<13)+(39<<7))
#define ___CTOS_UINT_ERR          ((3<<13)+(40<<7))
#define ___CTOS_LONG_ERR          ((3<<13)+(41<<7))
#define ___CTOS_ULONG_ERR         ((3<<13)+(42<<7))
#define ___CTOS_FLOAT_ERR         ((3<<13)+(43<<7))
#define ___CTOS_DOUBLE_ERR        ((3<<13)+(44<<7))
#define ___CTOS_POINTER_ERR       ((3<<13)+(45<<7))
#define ___CTOS_FUNCTION_ERR      ((3<<13)+(46<<7))
#define ___CTOS_BOOL_ERR          ((3<<13)+(47<<7))
#define ___CTOS_CHARSTRING_ERR    ((3<<13)+(48<<7))
#define ___CTOS_LATIN1STRING_ERR  ((3<<13)+(49<<7))
#define ___CTOS_UCS4STRING_ERR    ((3<<13)+(50<<7))
#define ___CTOS_UCS2STRING_ERR    ((3<<13)+(51<<7))
#define ___CTOS_UTF8STRING_ERR    ((3<<13)+(52<<7))
#define ___CTOS_HEAP_OVERFLOW_ERR ((3<<13)+(53<<7))

#ifdef ___USE_SETJMP
#define ___BEGIN_CATCH \
___jmpbuf_struct ___jbuf, *___old_catcher = ___ps->catcher; \
___ps->catcher = &___jbuf; ___err = ___SETJMP(___jbuf.buf); \
if (___err==___NO_ERR) {
#define ___END_CATCH } ___ps->catcher = ___old_catcher;
#define ___THROW(err)longjmp (___ps->catcher->buf, err)
#else
#define ___BEGIN_CATCH ___err = ___NO_ERR; try {
#define ___END_CATCH } catch (int err) { ___err = err; }
#define ___THROW(err)throw (err)
#endif

#define ___CLAM_CONV_ERROR if (___err>=___FIRST_C_CONV_ERR) {___ps->temp1=___LBL(0);___ps->temp2=___FIX(___err);___JUMPEXTPRM(___SET_NARGS(___NARGS),___ps->handler_clam_conv_error)}

#define ___STOC(f,s,c,i)___err=___EXT(f)(s,c,i)
#define ___CTOS(f,c,s,i)___err=___EXT(f)(c,s,i)
#define ___IF_STOC(f,s,c,i)if ((___STOC(f,s,c,i))==___NO_ERR)
#define ___IF_CTOS(f,c,s,i)if ((___CTOS(f,c,s,i))==___NO_ERR)

#define ___BEGIN_CDEF_BODY
#define ___END_CDEF_BODY

#define ___BEGIN_CDEF_VOID ___processor_state ___ps=___PSTATE;___WORD ___marker;int ___err;if ((___err=___EXT(___make_cdef_stack_marker) (&___marker))==___NO_ERR) {
#define ___CDEF_CALL_VOID(nargs,lbl)___err=___EXT(___call) (nargs,lbl);
#define ___CDEF_SET_RESULT_VOID /* no result to set */
#define ___CDEF_ERROR_VOID(lbl) while (___err>=___FIRST_C_CONV_ERR) {___ps->temp1=___FIX(___err);___ps->temp2=lbl;___CDEF_CALL_VOID(0,___ps->handler_cdef_conv_error)
#define ___END_CDEF_VOID } ___EXT(___kill_cdef_stack_marker) (___marker); } ___EXT(___propagate_error) (___err);

#define ___BEGIN_CDEF_SCMOBJ ___processor_state ___ps=___PSTATE;___WORD ___marker;___WORD ___result;int ___err;if ((___err=___EXT(___make_cdef_stack_marker) (&___marker))==___NO_ERR) {
#define ___CDEF_CALL_SCMOBJ(nargs,lbl)___err=___EXT(___call) (nargs,lbl);
#define ___CDEF_SET_RESULT_SCMOBJ ___result = ___CDEF_RESULT;
#define ___CDEF_ERROR_SCMOBJ(lbl) while (___err>=___FIRST_C_CONV_ERR) {___ps->temp1=___FIX(___err);___ps->temp2=lbl;___CDEF_CALL_SCMOBJ(0,___ps->handler_cdef_conv_error)
#define ___END_CDEF_SCMOBJ } ___EXT(___kill_cdef_stack_marker) (___marker); } ___EXT(___propagate_error) (___err);

#define ___BEGIN_CDEF(decl)___processor_state ___ps=___PSTATE;___WORD ___marker;decl;int ___err;if ((___err=___EXT(___make_cdef_stack_marker) (&___marker))==___NO_ERR) {
#define ___CDEF_CALL(nargs,lbl)if ((___err=___EXT(___call) (nargs,lbl))==___NO_ERR)
#define ___CDEF_SET_RESULT /* done in conversion function */
#define ___CDEF_ERROR(lbl) while (___err>=___FIRST_C_CONV_ERR) {___ps->temp1=___FIX(___err);___ps->temp2=lbl;___CDEF_CALL(0,___ps->handler_cdef_conv_error)
#define ___END_CDEF } ___EXT(___kill_cdef_stack_marker) (___marker); } ___EXT(___propagate_error) (___err);

#define ___BEGIN_CDEF_ARG(i,s)___WORD s;
#define ___END_CDEF_ARG(i)
#define ___BEGIN_CDEF_ARG_SCMOBJ(i)
#define ___END_CDEF_ARG_SCMOBJ(i)
#define ___CDEF_ARG(i,arg)___PSSTK(i)=arg;
#define ___CDEF_RESULT ___PSR1

#define ___BEGIN_CDEF_SCMOBJ_TO_CHAR(s,c)___STOC(___scmobj_to_char,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_CHAR(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_SCHAR(s,c)___STOC(___scmobj_to_schar,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_SCHAR(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UCHAR(s,c)___STOC(___scmobj_to_uchar,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UCHAR(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_LATIN1(s,c)___STOC(___scmobj_to_latin1,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_LATIN1(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UCS4(s,c)___STOC(___scmobj_to_ucs4,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UCS4(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UCS2(s,c)___STOC(___scmobj_to_ucs2,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UCS2(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_SHORT(s,c)___STOC(___scmobj_to_short,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_SHORT(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_USHORT(s,c)___STOC(___scmobj_to_ushort,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_USHORT(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_INT(s,c)___STOC(___scmobj_to_int,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_INT(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UINT(s,c)___STOC(___scmobj_to_uint,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UINT(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_LONG(s,c)___STOC(___scmobj_to_long,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_LONG(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_ULONG(s,c)___STOC(___scmobj_to_ulong,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_ULONG(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_FLOAT(s,c)___STOC(___scmobj_to_float,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_FLOAT(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_DOUBLE(s,c)___STOC(___scmobj_to_double,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_DOUBLE(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_POINTER(s,c)___STOC(___scmobj_to_pointer,s,(void**)&c,0);
#define ___END_CDEF_SCMOBJ_TO_POINTER(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_FUNCTION(s,c)___STOC(___scmobj_to_function,s,(void**)&c,0);
#define ___END_CDEF_SCMOBJ_TO_FUNCTION(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_BOOL(s,c)___STOC(___scmobj_to_bool,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_BOOL(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_CHARSTRING(s,c)___STOC(___scmobj_to_charstring,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_CHARSTRING(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_LATIN1STRING(s,c)___STOC(___scmobj_to_latin1string,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_LATIN1STRING(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UCS4STRING(s,c)___STOC(___scmobj_to_ucs4string,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UCS4STRING(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UCS2STRING(s,c)___STOC(___scmobj_to_ucs2string,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UCS2STRING(s,c)
#define ___BEGIN_CDEF_SCMOBJ_TO_UTF8STRING(s,c)___STOC(___scmobj_to_utf8string,s,&c,0);
#define ___END_CDEF_SCMOBJ_TO_UTF8STRING(s,c)

#define ___BEGIN_CDEF_CHAR_TO_SCMOBJ(c,s,i)___IF_CTOS(___char_to_scmobj,c,&s,i){
#define ___END_CDEF_CHAR_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_SCHAR_TO_SCMOBJ(c,s,i)___IF_CTOS(___schar_to_scmobj,c,&s,i){
#define ___END_CDEF_SCHAR_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_UCHAR_TO_SCMOBJ(c,s,i)___IF_CTOS(___uchar_to_scmobj,c,&s,i){
#define ___END_CDEF_UCHAR_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_LATIN1_TO_SCMOBJ(c,s,i)___IF_CTOS(___latin1_to_scmobj,c,&s,i){
#define ___END_CDEF_LATIN1_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_UCS4_TO_SCMOBJ(c,s,i)___IF_CTOS(___ucs4_to_scmobj,c,&s,i){
#define ___END_CDEF_UCS4_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_UCS2_TO_SCMOBJ(c,s,i)___IF_CTOS(___ucs2_to_scmobj,c,&s,i){
#define ___END_CDEF_UCS2_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_SHORT_TO_SCMOBJ(c,s,i)___IF_CTOS(___short_to_scmobj,c,&s,i){
#define ___END_CDEF_SHORT_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_USHORT_TO_SCMOBJ(c,s,i)___IF_CTOS(___ushort_to_scmobj,c,&s,i){
#define ___END_CDEF_USHORT_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_INT_TO_SCMOBJ(c,s,i)___IF_CTOS(___int_to_scmobj,c,&s,i){
#define ___END_CDEF_INT_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_UINT_TO_SCMOBJ(c,s,i)___IF_CTOS(___uint_to_scmobj,c,&s,i){
#define ___END_CDEF_UINT_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_LONG_TO_SCMOBJ(c,s,i)___IF_CTOS(___long_to_scmobj,c,&s,i){
#define ___END_CDEF_LONG_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_ULONG_TO_SCMOBJ(c,s,i)___IF_CTOS(___ulong_to_scmobj,c,&s,i){
#define ___END_CDEF_ULONG_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_FLOAT_TO_SCMOBJ(c,s,i)___IF_CTOS(___float_to_scmobj,c,&s,i){
#define ___END_CDEF_FLOAT_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_DOUBLE_TO_SCMOBJ(c,s,i)___IF_CTOS(___double_to_scmobj,c,&s,i){
#define ___END_CDEF_DOUBLE_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_POINTER_TO_SCMOBJ(c,s,i)___IF_CTOS(___pointer_to_scmobj,(void*)c,&s,i){
#define ___END_CDEF_POINTER_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_FUNCTION_TO_SCMOBJ(c,s,i)___IF_CTOS(___function_to_scmobj,(void*)c,&s,i){
#define ___END_CDEF_FUNCTION_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_BOOL_TO_SCMOBJ(c,s,i)___IF_CTOS(___bool_to_scmobj,c,&s,i){
#define ___END_CDEF_BOOL_TO_SCMOBJ(c,s,i)}
#define ___BEGIN_CDEF_CHARSTRING_TO_SCMOBJ(c,s,i)___IF_CTOS(___charstring_to_scmobj,c,&s,i){
#define ___END_CDEF_CHARSTRING_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_LATIN1STRING_TO_SCMOBJ(c,s,i)___IF_CTOS(___latin1string_to_scmobj,c,&s,i){
#define ___END_CDEF_LATIN1STRING_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_UCS4STRING_TO_SCMOBJ(c,s,i)___IF_CTOS(___ucs4string_to_scmobj,c,&s,i){
#define ___END_CDEF_UCS4STRING_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_UCS2STRING_TO_SCMOBJ(c,s,i)___IF_CTOS(___ucs2string_to_scmobj,c,&s,i){
#define ___END_CDEF_UCS2STRING_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CDEF_UTF8STRING_TO_SCMOBJ(c,s,i)___IF_CTOS(___utf8string_to_scmobj,c,&s,i){
#define ___END_CDEF_UTF8STRING_TO_SCMOBJ(c,s,i)___EXT(___release_scmobj)(s);}


#define ___RETURN_TO_C(n)___SET_R0(___LBL(n)) ___JUMPEXTPRM(___NOTHING,___ps->handler_return_to_c)

#define ___BEGIN_CLAM_BODY
#define ___END_CLAM_BODY ___AT_END
#define ___BEGIN_CLAM_BODY_FREE ___W_ALL {___BEGIN_CATCH
#define ___END_CLAM_BODY_FREE ___AT_END ___END_CATCH} ___R_ALL

#define ___BEGIN_CLAM_VOID ___W_ALL {int ___err=___NO_ERR;
#define ___CLAM_SET_RESULT_VOID ___CLAM_RESULT = ___VOID;
#define ___CLAM_ERROR_VOID ___CLAM_CONV_ERROR
#define ___CLAM_ERROR_FREE_VOID ___CLAM_CONV_ERROR ___EXT(___propagate_error) (___err);
#define ___END_CLAM_VOID } ___R_ALL

#define ___BEGIN_CLAM_SCMOBJ ___W_ALL {int ___err=___NO_ERR;___WORD ___result;
#define ___CLAM_SET_RESULT_SCMOBJ ___CLAM_RESULT = ___result;
#define ___CLAM_ERROR_SCMOBJ ___CLAM_CONV_ERROR
#define ___CLAM_ERROR_FREE_SCMOBJ ___CLAM_CONV_ERROR ___EXT(___propagate_error) (___err);
#define ___END_CLAM_SCMOBJ } ___R_ALL

#define ___BEGIN_CLAM(decl)___W_ALL {int ___err=___NO_ERR;decl;
#define ___CLAM_SET_RESULT /* done in conversion function */
#define ___CLAM_ERROR ___CLAM_CONV_ERROR
#define ___CLAM_ERROR_FREE ___CLAM_CONV_ERROR ___EXT(___propagate_error) (___err);
#define ___END_CLAM } ___R_ALL

#define ___BEGIN_CLAM_ARG(i,decl)decl;
#define ___END_CLAM_ARG(i)
#define ___BEGIN_CLAM_ARG_SCMOBJ(i)
#define ___END_CLAM_ARG_SCMOBJ(i)
#define ___CLAM_ARG(i)___PSSTK((i-___NARGS-2))
#define ___CLAM_RESULT ___PSR1

#define ___BEGIN_CLAM_SCMOBJ_TO_CHAR(s,c,i)___IF_STOC(___scmobj_to_char,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_CHAR(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_SCHAR(s,c,i)___IF_STOC(___scmobj_to_schar,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_SCHAR(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_UCHAR(s,c,i)___IF_STOC(___scmobj_to_uchar,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UCHAR(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_LATIN1(s,c,i)___IF_STOC(___scmobj_to_latin1,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_LATIN1(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_UCS4(s,c,i)___IF_STOC(___scmobj_to_ucs4,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UCS4(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_UCS2(s,c,i)___IF_STOC(___scmobj_to_ucs2,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UCS2(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_SHORT(s,c,i)___IF_STOC(___scmobj_to_short,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_SHORT(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_USHORT(s,c,i)___IF_STOC(___scmobj_to_ushort,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_USHORT(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_INT(s,c,i)___IF_STOC(___scmobj_to_int,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_INT(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_UINT(s,c,i)___IF_STOC(___scmobj_to_uint,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UINT(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_LONG(s,c,i)___IF_STOC(___scmobj_to_long,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_LONG(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_ULONG(s,c,i)___IF_STOC(___scmobj_to_ulong,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_ULONG(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_FLOAT(s,c,i)___IF_STOC(___scmobj_to_float,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_FLOAT(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_DOUBLE(s,c,i)___IF_STOC(___scmobj_to_double,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_DOUBLE(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_POINTER(s,c,i)___IF_STOC(___scmobj_to_pointer,s,(void**)&c,i){
#define ___END_CLAM_SCMOBJ_TO_POINTER(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_FUNCTION(s,c,i)___IF_STOC(___scmobj_to_function,s,(void**)&c,i){
#define ___END_CLAM_SCMOBJ_TO_FUNCTION(s,c,i)___EXT(___free_function)(c);}
#define ___BEGIN_CLAM_SCMOBJ_TO_BOOL(s,c,i)___IF_STOC(___scmobj_to_bool,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_BOOL(s,c,i)}
#define ___BEGIN_CLAM_SCMOBJ_TO_CHARSTRING(s,c,i)___IF_STOC(___scmobj_to_charstring,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_CHARSTRING(s,c,i)___EXT(___free_string)(c);}
#define ___BEGIN_CLAM_SCMOBJ_TO_LATIN1STRING(s,c,i)___IF_STOC(___scmobj_to_latin1string,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_LATIN1STRING(s,c,i)___EXT(___free_string)(c);}
#define ___BEGIN_CLAM_SCMOBJ_TO_UCS4STRING(s,c,i)___IF_STOC(___scmobj_to_ucs4string,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UCS4STRING(s,c,i)___EXT(___free_string)(c);}
#define ___BEGIN_CLAM_SCMOBJ_TO_UCS2STRING(s,c,i)___IF_STOC(___scmobj_to_ucs2string,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UCS2STRING(s,c,i)___EXT(___free_string)(c);}
#define ___BEGIN_CLAM_SCMOBJ_TO_UTF8STRING(s,c,i)___IF_STOC(___scmobj_to_utf8string,s,&c,i){
#define ___END_CLAM_SCMOBJ_TO_UTF8STRING(s,c,i)___EXT(___free_string)(c);}

#define ___BEGIN_CLAM_CHAR_TO_SCMOBJ(c,s)___CTOS(___char_to_scmobj,c,&s,0);
#define ___END_CLAM_CHAR_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_SCHAR_TO_SCMOBJ(c,s)___CTOS(___schar_to_scmobj,c,&s,0);
#define ___END_CLAM_SCHAR_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_UCHAR_TO_SCMOBJ(c,s)___CTOS(___uchar_to_scmobj,c,&s,0);
#define ___END_CLAM_UCHAR_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_LATIN1_TO_SCMOBJ(c,s)___CTOS(___latin1_to_scmobj,c,&s,0);
#define ___END_CLAM_LATIN1_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_UCS4_TO_SCMOBJ(c,s)___CTOS(___ucs4_to_scmobj,c,&s,0);
#define ___END_CLAM_UCS4_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_UCS2_TO_SCMOBJ(c,s)___CTOS(___ucs2_to_scmobj,c,&s,0);
#define ___END_CLAM_UCS2_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_SHORT_TO_SCMOBJ(c,s)___IF_CTOS(___short_to_scmobj,c,&s,0){
#define ___END_CLAM_SHORT_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_USHORT_TO_SCMOBJ(c,s)___IF_CTOS(___ushort_to_scmobj,c,&s,0){
#define ___END_CLAM_USHORT_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_INT_TO_SCMOBJ(c,s)___IF_CTOS(___int_to_scmobj,c,&s,0){
#define ___END_CLAM_INT_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_UINT_TO_SCMOBJ(c,s)___IF_CTOS(___uint_to_scmobj,c,&s,0){
#define ___END_CLAM_UINT_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_LONG_TO_SCMOBJ(c,s)___IF_CTOS(___long_to_scmobj,c,&s,0){
#define ___END_CLAM_LONG_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_ULONG_TO_SCMOBJ(c,s)___IF_CTOS(___ulong_to_scmobj,c,&s,0){
#define ___END_CLAM_ULONG_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_FLOAT_TO_SCMOBJ(c,s)___IF_CTOS(___float_to_scmobj,c,&s,0){
#define ___END_CLAM_FLOAT_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_DOUBLE_TO_SCMOBJ(c,s)___IF_CTOS(___double_to_scmobj,c,&s,0){
#define ___END_CLAM_DOUBLE_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_POINTER_TO_SCMOBJ(c,s)___IF_CTOS(___pointer_to_scmobj,(void**)c,&s,0){
#define ___END_CLAM_POINTER_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_FUNCTION_TO_SCMOBJ(c,s)___IF_CTOS(___function_to_scmobj,(void**)c,&s,0){
#define ___END_CLAM_FUNCTION_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_BOOL_TO_SCMOBJ(c,s)___CTOS(___bool_to_scmobj,c,&s,0);
#define ___END_CLAM_BOOL_TO_SCMOBJ(c,s)
#define ___BEGIN_CLAM_CHARSTRING_TO_SCMOBJ(c,s)___IF_CTOS(___charstring_to_scmobj,c,&s,0){
#define ___END_CLAM_CHARSTRING_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_LATIN1STRING_TO_SCMOBJ(c,s)___IF_CTOS(___latin1string_to_scmobj,c,&s,0){
#define ___END_CLAM_LATIN1STRING_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_UCS4STRING_TO_SCMOBJ(c,s)___IF_CTOS(___ucs4string_to_scmobj,c,&s,0){
#define ___END_CLAM_UCS4STRING_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_UCS2STRING_TO_SCMOBJ(c,s)___IF_CTOS(___ucs2string_to_scmobj,c,&s,0){
#define ___END_CLAM_UCS2STRING_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}
#define ___BEGIN_CLAM_UTF8STRING_TO_SCMOBJ(c,s)___IF_CTOS(___utf8string_to_scmobj,c,&s,0){
#define ___END_CLAM_UTF8STRING_TO_SCMOBJ(c,s)___EXT(___release_scmobj)(s);}

#endif

/*---------------------------------------------------------------------------*/

#ifndef ___DEFINES_ONLY

#ifdef _MSC_VER
#ifdef ___DYNAMIC
int _fltused; /* needed if floating-point used. */
#endif
#endif

#ifdef __BORLANDC__
#ifdef ___SHARED
#define _RTLDLL
#endif
#endif

#include <math.h>

#ifdef ___USE_SETJMP

#include <setjmp.h>

typedef struct ___jmpbuf_struct
  {
    jmp_buf buf;
  } ___jmpbuf_struct;

#endif

#ifndef ___U64

/* 64 bit unsigned integer structure */

typedef struct
  {
#ifdef ___CPU_BIGEND
    ___U32 hi32, lo32;
#else
    ___U32 lo32, hi32;
#endif
  } ___U64;

#endif

/* Symbol/keyword structure */

typedef ___FAKEWORD ___symkey_struct[];

/* Global variable structure */

typedef struct ___glo_struct
  {
    ___WORD val, prm, next;
  } ___glo_struct;

/* Processor structure */

typedef struct ___processor_state_struct
  {
    ___WORD *stack, *stack_base, *stack_limit, *stack_trip, *stack_break, *fp;
    ___WORD *heap, *heap_limit, *hp;
    ___WORD r[___NB_GVM_REGS], pc, temp1, temp2, temp3, temp4;
    int na, np;
    int intr_enabled, intr_flag[___NB_INTRS];
    ___WORD glo_list_head, glo_list_tail;
    ___WORD handler_break, handler_stack_limit, handler_heap_limit,
            handler_not_proc, handler_not_proc_glo,
            handler_wrong_nargs, handler_get_rest,
            handler_get_key, handler_get_key_rest,
            handler_force, handler_clam_conv_error,
            handler_cdef_conv_error, handler_return_to_c,
            initial_continuation;
    ___WORD executable_wills, non_executable_wills;
#ifdef ___USE_SETJMP
    ___jmpbuf_struct *catcher;
#endif
  } ___processor_state_struct, *___processor_state;

typedef ___WORD (*___host) ___P((___processor_state),());

typedef struct ___label_struct
  {
    ___WORD header, entry, flags;
    ___FAKEHOST host;
  } ___label_struct;

/* Module structure */

typedef struct ___module_struct
  {
    int version;
    int kind;
    ___UTF8STRING name;
    ___FAKEWORD *glo_tbl; int glo_count; int sup_count;
    ___UTF8STRING *glo_names;
    ___FAKEWORD *sym_tbl; int sym_count;
    ___UTF8STRING *sym_names;
    ___FAKEWORD *key_tbl; int key_count;
    ___UTF8STRING *key_names;
    ___WORD *lp;
    ___label_struct *lbl_tbl; int lbl_count;
    ___WORD *cns_tbl; int cns_count;
    ___FAKEWORD *sub_tbl; int sub_count;
    void (*init_proc) ___PVOID;
    struct ___module_struct *next;
  } ___module_struct;

/* Linkfile structure */

typedef struct ___linkfile_struct
  {
    int version;
    int kind;
    ___UTF8STRING name;
    ___FAKEWORD *sym_list;
    ___FAKEWORD *key_list;
    void **linker_tbl;
  } ___linkfile_struct;

/* Module or linkfile structure */

typedef union
  {
    ___module_struct module;
    ___linkfile_struct linkfile;
  } *___mod_or_lnk;

/* Global state structure */

typedef struct ___global_state_struct
  {
    ___processor_state_struct pstate;
    ___U64 nb_gcs, gc_user_nsecs, gc_sys_nsecs;
    ___U64 bytes_allocated_minus_occupied;
#ifdef ___CANT_IMPORT_CLIB_DYNAMICALLY
    double (*fabs) ___P((double x),());
    double (*floor) ___P((double x),());
    double (*ceil) ___P((double x),());
    double (*exp) ___P((double x),());
    double (*log) ___P((double x),());
    double (*sin) ___P((double x),());
    double (*cos) ___P((double x),());
    double (*tan) ___P((double x),());
    double (*asin) ___P((double x),());
    double (*acos) ___P((double x),());
    double (*atan) ___P((double x),());
    double (*atan2) ___P((double x, double y),());
    double (*sqrt) ___P((double x),());
#endif
#ifdef ___USE_SETJMP
#ifdef ___CANT_IMPORT_SETJMP_DYNAMICALLY
    int (*setjmp) ___P((jmp_buf env),());
#endif
#endif
#ifdef ___CANT_IMPORT_DYNAMICALLY
    double (*___copysign) ___P((double x, double y),());
    int (*___isfinite) ___P((double x),());
    int (*___isnan) ___P((double x),());
    double (*___round) ___P((double x),());
    int (*___scmobj_to_char)
       ___P((___WORD obj, char *x, int arg_num),());
    int (*___scmobj_to_schar)
       ___P((___WORD obj, ___SCHAR *x, int arg_num),());
    int (*___scmobj_to_uchar)
       ___P((___WORD obj, unsigned char *x, int arg_num),());
    int (*___scmobj_to_latin1)
       ___P((___WORD obj, ___LATIN1 *x, int arg_num),());
    int (*___scmobj_to_ucs4)
       ___P((___WORD obj, ___UCS4 *x, int arg_num),());
    int (*___scmobj_to_ucs2)
       ___P((___WORD obj, ___UCS2 *x, int arg_num),());
    int (*___scmobj_to_short)
       ___P((___WORD obj, short *x, int arg_num),());
    int (*___scmobj_to_ushort)
       ___P((___WORD obj, unsigned short *x, int arg_num),());
    int (*___scmobj_to_int)
       ___P((___WORD obj, int *x, int arg_num),());
    int (*___scmobj_to_uint)
       ___P((___WORD obj, unsigned int *x, int arg_num),());
    int (*___scmobj_to_long)
       ___P((___WORD obj, long *x, int arg_num),());
    int (*___scmobj_to_ulong)
       ___P((___WORD obj, unsigned long *x, int arg_num),());
    int (*___scmobj_to_float)
       ___P((___WORD obj, float *x, int arg_num),());
    int (*___scmobj_to_double)
       ___P((___WORD obj, double *x, int arg_num),());
    int (*___scmobj_to_pointer)
       ___P((___WORD obj, void **x, int arg_num),());
    int (*___scmobj_to_function)
       ___P((___WORD obj, void **x, int arg_num),());
    int (*___scmobj_to_bool)
       ___P((___WORD obj, ___BOOL *x, int arg_num),());
    int (*___scmobj_to_charstring)
       ___P((___WORD obj, char **x, int arg_num),());
    int (*___scmobj_to_latin1string)
       ___P((___WORD obj, ___LATIN1STRING *x, int arg_num),());
    int (*___scmobj_to_ucs4string)
       ___P((___WORD obj, ___UCS4STRING *x, int arg_num),());
    int (*___scmobj_to_ucs2string)
       ___P((___WORD obj, ___UCS2STRING *x, int arg_num),());
    int (*___scmobj_to_utf8string)
       ___P((___WORD obj, ___UTF8STRING *x, int arg_num),());
    void (*___free_function) ___P((void *x),());
    void (*___free_string) ___P((void *x),());
    int (*___char_to_scmobj)
       ___P((char x, ___WORD *obj, int arg_num),());
    int (*___schar_to_scmobj)
       ___P((___SCHAR x, ___WORD *obj, int arg_num),());
    int (*___uchar_to_scmobj)
       ___P((unsigned char x, ___WORD *obj, int arg_num),());
    int (*___latin1_to_scmobj)
       ___P((___LATIN1 x, ___WORD *obj, int arg_num),());
    int (*___ucs4_to_scmobj)
       ___P((___UCS4 x, ___WORD *obj, int arg_num),());
    int (*___ucs2_to_scmobj)
       ___P((___UCS2 x, ___WORD *obj, int arg_num),());
    int (*___short_to_scmobj)
       ___P((short x, ___WORD *obj, int arg_num),());
    int (*___ushort_to_scmobj)
       ___P((unsigned short x, ___WORD *obj, int arg_num),());
    int (*___int_to_scmobj)
       ___P((int x, ___WORD *obj, int arg_num),());
    int (*___uint_to_scmobj)
       ___P((unsigned int x, ___WORD *obj, int arg_num),());
    int (*___long_to_scmobj)
       ___P((long x, ___WORD *obj, int arg_num),());
    int (*___ulong_to_scmobj)
       ___P((unsigned long x, ___WORD *obj, int arg_num),());
    int (*___float_to_scmobj)
       ___P((float x, ___WORD *obj, int arg_num),());
    int (*___double_to_scmobj)
       ___P((double x, ___WORD *obj, int arg_num),());
    int (*___pointer_to_scmobj)
       ___P((void *x, ___WORD *obj, int arg_num),());
    int (*___function_to_scmobj)
       ___P((void *x, ___WORD *obj, int arg_num),());
    int (*___bool_to_scmobj)
       ___P((___BOOL x, ___WORD *obj, int arg_num),());
    int (*___charstring_to_scmobj)
       ___P((char *x, ___WORD *obj, int arg_num),());
    int (*___latin1string_to_scmobj)
       ___P((___LATIN1STRING x, ___WORD *obj, int arg_num),());
    int (*___ucs4string_to_scmobj)
       ___P((___UCS4STRING x, ___WORD *obj, int arg_num),());
    int (*___ucs2string_to_scmobj)
       ___P((___UCS2STRING x, ___WORD *obj, int arg_num),());
    int (*___utf8string_to_scmobj)
       ___P((___UTF8STRING x, ___WORD *obj, int arg_num),());
    int (*___make_cdef_stack_marker) ___P((___WORD *marker),());
    void (*___kill_cdef_stack_marker) ___P((___WORD marker),());
    void (*___release_scmobj) ___P((___WORD obj),());
    ___WORD (*___alloc_scmobj)
       ___P((unsigned int subtype, unsigned long bytes, unsigned int kind),());
    ___WORD (*___make_pair)
       ___P((___WORD car, ___WORD cdr, unsigned int kind),());
    ___WORD (*___make_vector)
       ___P((unsigned long length, ___WORD init, unsigned int kind),());
    ___WORD (*___make_string)
       ___P((unsigned long length, char init, unsigned int kind),());
    void (*___still_obj_refcount_inc) ___P((___WORD obj),());
    void (*___still_obj_refcount_dec) ___P((___WORD obj),());
    void (*___cleanup) ___PVOID;
    int (*___call) ___P((int nargs, ___WORD proc),());
    void (*___propagate_error) ___P((int err),());
    void (*___raise_interrupt) ___P((int code),());
#endif
  } ___global_state_struct;

___LOCAL ___WORD ___lp; /* Module's label table pointer */
___GLO_DECL
___SYM_DECL
___KEY_DECL

/* Setup parameters structure */

typedef struct ___setup_params_struct
  {
    int argc;
    char **argv;
    unsigned long stack_cache, min_heap, max_heap;
    int live_percent;
    long (*gc_hook) ___P((long avail, long live),());
    void (*fatal_error) ___P((char *msg),());
    int standard;
    int debug_level;
    int default_io_encoding;
    int force_tty;
    int force_unbuffered_io;
    ___mod_or_lnk (*linker) ___P((___global_state_struct*),());
  } ___setup_params_struct;

#endif

#ifndef ___INCLUDED_FROM_C_INTF
___IMP_FUNC(int,___scmobj_to_char)
   ___P((___WORD obj, char *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_schar)
   ___P((___WORD obj, ___SCHAR *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_uchar)
   ___P((___WORD obj, unsigned char *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_latin1)
   ___P((___WORD obj, ___LATIN1 *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ucs4)
   ___P((___WORD obj, ___UCS4 *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ucs2)
   ___P((___WORD obj, ___UCS2 *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_short)
   ___P((___WORD obj, short *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ushort)
   ___P((___WORD obj, unsigned short *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_int)
   ___P((___WORD obj, int *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_uint)
   ___P((___WORD obj, unsigned int *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_long)
   ___P((___WORD obj, long *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ulong)
   ___P((___WORD obj, unsigned long *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_float)
   ___P((___WORD obj, float *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_double)
   ___P((___WORD obj, double *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_pointer)
   ___P((___WORD obj, void **x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_function)
   ___P((___WORD obj, void **x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_bool)
   ___P((___WORD obj, ___BOOL *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_charstring)
   ___P((___WORD obj, char **x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_latin1string)
   ___P((___WORD obj, ___LATIN1STRING *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ucs4string)
   ___P((___WORD obj, ___UCS4STRING *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_ucs2string)
   ___P((___WORD obj, ___UCS2STRING *x, int arg_num),());
___IMP_FUNC(int,___scmobj_to_utf8string)
   ___P((___WORD obj, ___UTF8STRING *x, int arg_num),());
___IMP_FUNC(void,___free_function) ___P((void *x),());
___IMP_FUNC(void,___free_string) ___P((void *x),());
___IMP_FUNC(int,___char_to_scmobj)
   ___P((char x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___schar_to_scmobj)
   ___P((___SCHAR x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___uchar_to_scmobj)
   ___P((unsigned char x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___latin1_to_scmobj)
   ___P((___LATIN1 x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ucs4_to_scmobj)
   ___P((___UCS4 x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ucs2_to_scmobj)
   ___P((___UCS2 x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___short_to_scmobj)
   ___P((short x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ushort_to_scmobj)
   ___P((unsigned short x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___int_to_scmobj)
   ___P((int x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___uint_to_scmobj)
   ___P((unsigned int x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___long_to_scmobj)
   ___P((long x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ulong_to_scmobj)
   ___P((unsigned long x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___float_to_scmobj)
   ___P((float x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___double_to_scmobj)
   ___P((double x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___pointer_to_scmobj)
   ___P((void *x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___function_to_scmobj)
   ___P((void *x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___bool_to_scmobj)
   ___P((___BOOL x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___charstring_to_scmobj)
   ___P((char *x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___latin1string_to_scmobj)
   ___P((___LATIN1STRING x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ucs4string_to_scmobj)
   ___P((___UCS4STRING x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___ucs2string_to_scmobj)
   ___P((___UCS2STRING x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___utf8string_to_scmobj)
   ___P((___UTF8STRING x, ___WORD *obj, int arg_num),());
___IMP_FUNC(int,___make_cdef_stack_marker) ___P((___WORD *marker),());
___IMP_FUNC(void,___kill_cdef_stack_marker) ___P((___WORD marker),());
___IMP_FUNC(void,___release_scmobj) ___P((___WORD obj),());
#endif

#ifndef ___INCLUDED_FROM_MEM
___IMP_FUNC(___WORD,___alloc_scmobj)
   ___P((unsigned int subtype, unsigned long bytes, unsigned int kind),());
___IMP_FUNC(___WORD,___make_pair)
   ___P((___WORD car, ___WORD cdr, unsigned int kind),());
___IMP_FUNC(___WORD,___make_vector)
   ___P((unsigned long length, ___WORD init, unsigned int kind),());
___IMP_FUNC(___WORD,___make_string)
   ___P((unsigned long length, char init, unsigned int kind),());
___IMP_FUNC(void,___still_obj_refcount_inc) ___P((___WORD obj),());
___IMP_FUNC(void,___still_obj_refcount_dec) ___P((___WORD obj),());
#endif

#ifndef ___INCLUDED_FROM_SETUP
___GSTATE_DECL
___IMP_FUNC(double,___copysign) ___P((double x, double y),());
___IMP_FUNC(int,___isfinite) ___P((double x),());
___IMP_FUNC(int,___isnan) ___P((double x),());
___IMP_FUNC(double,___round) ___P((double x),());
___IMP_FUNC(void,___setup) ___P((struct ___setup_params_struct *setup_params),());
___IMP_FUNC(void,___cleanup) ___PVOID;
___IMP_FUNC(int,___call) ___P((int nargs, ___WORD proc),());
___IMP_FUNC(void,___propagate_error) ___P((int err),());
___IMP_FUNC(void,___raise_interrupt) ___P((int code),());
#endif
