/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

#include "mysys_priv.h"
#include "mysys_err.h"
#include <errno.h>
#undef MY_HOW_OFTEN_TO_ALARM
#define MY_HOW_OFTEN_TO_ALARM ((int) my_time_to_wait_for_lock)
#ifdef NO_ALARM_LOOP
#undef NO_ALARM_LOOP
#endif
#include <my_alarm.h>
#ifdef __WIN32__
#include <sys/locking.h>
#endif

#ifdef HAVE_FCNTL
static struct flock lock;		/* Must be static for sun-sparc */
#endif

	/* Lock a part of a file */

int my_lock(File fd, int locktype, my_off_t start, my_off_t length,
	    myf MyFlags)
{
#ifdef HAVE_FCNTL
  int value;
  ALARM_VARIABLES;
#endif
  DBUG_ENTER("my_lock");
  DBUG_PRINT("my",("Fd: %d  Op: %d  start: %ld  Length: %ld  MyFlags: %d",
		   fd,locktype,(long) start,(long) length,MyFlags));
#ifdef VMS
  DBUG_RETURN(0);
#else
  if (my_disable_locking)
    DBUG_RETURN(0);
#if defined(HAVE_LOCKING)
  if (MyFlags & MY_SEEK_NOT_DONE)
    VOID(my_seek(fd,start,MY_SEEK_SET,MYF(MyFlags & ~MY_SEEK_NOT_DONE)));
  if (!locking(fd,locktype,length) || errno == EINVAL)
    DBUG_RETURN(0);
#else
#if defined(HAVE_FCNTL)
  lock.l_type=locktype;
  lock.l_whence=0L;
  lock.l_start=(long) start;
  lock.l_len=(long) length;
  if (MyFlags & MY_DONT_WAIT)
  {
    if (fcntl(fd,F_SETLK,&lock) != -1)	/* Check if we can lock */
      DBUG_RETURN(0);			/* Ok, file locked */
    DBUG_PRINT("info",("Was locked, trying with alarm"));
    ALARM_INIT;
    while ((value=fcntl(fd,F_SETLKW,&lock)) && ! ALARM_TEST &&
	   errno == EINTR)
    {			/* Setup again so we don`t miss it */
      ALARM_REINIT;
    }
    ALARM_END;
    if (value != -1)
      DBUG_RETURN(0);
    if (errno == EINTR)
      errno=EAGAIN;
  }
  else if (fcntl(fd,F_SETLKW,&lock) != -1) /* Wait until a lock */
    DBUG_RETURN(0);
#else
  if (MyFlags & MY_SEEK_NOT_DONE)
    VOID(my_seek(fd,start,MY_SEEK_SET,MYF(MyFlags & ~MY_SEEK_NOT_DONE)));
  if (lockf(fd,locktype,length) != -1)
    DBUG_RETURN(0);
#endif /* HAVE_FCNTL */
#endif /* HAVE_LOCKING */

	/* We got an error. We don't want EACCES errors */
  my_errno=(errno == EACCES) ? EAGAIN : errno;
  if (MyFlags & MY_WME)
  {
    if (locktype == F_UNLCK)
      my_error(EE_CANTUNLOCK,MYF(ME_BELL+ME_WAITTANG),my_errno);
    else
      my_error(EE_CANTLOCK,MYF(ME_BELL+ME_WAITTANG),my_errno);
  }
  DBUG_PRINT("error",("my_errno: %d (%d)",my_errno,errno));
  DBUG_RETURN(-1);
#endif	/* ! VMS */
} /* my_lock */
