#ifndef M68000_H
#define M68000_H


#include "cpudefs.h"

/* ASG 971105 */
typedef struct
{
	regstruct regs;
	int pending_interrupts;
} MC68000_Regs;

extern void MC68000_Reset(void);                      /* ASG 971105 */
extern int  MC68000_Execute(int);                     /* ASG 971105 */
extern void MC68000_SetRegs(MC68000_Regs *);          /* ASG 971105 */
extern void MC68000_GetRegs(MC68000_Regs *);          /* ASG 971105 */
extern void MC68000_Cause_Interrupt(int);             /* ASG 971105 */
extern void MC68000_Clear_Pending_Interrupts(void);   /* ASG 971105 */
extern int  MC68000_GetPC(void);                      /* ASG 971105 */

extern void MC68000_disasm(CPTR, CPTR*, int);

#ifdef A68KEM

extern regstruct regs;

#define MC68000_ICount regs.Icount

#else

extern int MC68000_ICount;                            /* ASG 971105 */

#endif


/* ASG 971105 */
#define MC68000_INT_NONE 0
#define MC68000_IRQ_1    1
#define MC68000_IRQ_2    2
#define MC68000_IRQ_3    3
#define MC68000_IRQ_4    4
#define MC68000_IRQ_5    5
#define MC68000_IRQ_6    6
#define MC68000_IRQ_7    7

#define MC68000_STOP     0x10


#endif
