/***************************************************************************

Atari Dominos machine

If you have any questions about how this driver works, don't hesitate to
ask.  - Mike Balfour (mab22@po.cwru.edu)
***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"

static int dominos_attract = 0;

/***************************************************************************
Read Ports

Dominos looks for the following:
	AAAAAAAA		D				D
	76543210		6				7
	00011000 ($18)	n/a				Player 1 Up
	00011001 ($19)	n/a				Player 1 Right
	00011010 ($1A)	n/a				Player 1 Down
	00011011 ($1B)	n/a				Player 1 Left

	00101000 ($28)	n/a				Player 2 Up
	00101001 ($29)	n/a				Player 2 Right
	00101010 ($2A)	n/a				Player 2 Down
	00101011 ($2B)	n/a				Player 2 Left
	00101100 ($2C)	n/a				Start 1
	00101101 ($2D)	n/a				Start 2
	00101110 ($2E)	n/a				Self Test

	00x10x00		Points0 (DIP)	Points1 (DIP)
	00x10x01		Mode 0 $ (DIP)	Mode 1 $ (DIP)

	01xxxxxx		Coin1			Coin2

We remap our input ports because if we didn't, we'd use a bunch of ports.
***************************************************************************/

int dominos_port_r(int offset)
{
	switch (offset)
	{
		/* IN0 */
		case 0x18:		return ((input_port_1_r(0) & 0x01) << 7);
		case 0x19:		return ((input_port_1_r(0) & 0x02) << 6);
		case 0x1A:		return ((input_port_1_r(0) & 0x04) << 5);
		case 0x1B:		return ((input_port_1_r(0) & 0x08) << 4);
		case 0x1C:		return ((input_port_1_r(0) & 0x10) << 3);
		case 0x1D:		return ((input_port_1_r(0) & 0x20) << 2);
		case 0x1E:		return ((input_port_1_r(0) & 0x40) << 1);
		case 0x1F:		return ((input_port_1_r(0) & 0x80) << 0);
		/* IN1 */
		case 0x28:		return ((input_port_2_r(0) & 0x01) << 7);
		case 0x29:		return ((input_port_2_r(0) & 0x02) << 6);
		case 0x2A:		return ((input_port_2_r(0) & 0x04) << 5);
		case 0x2B:		return ((input_port_2_r(0) & 0x08) << 4);
		case 0x2C:		return ((input_port_2_r(0) & 0x10) << 3);
		case 0x2D:		return ((input_port_2_r(0) & 0x20) << 2);
		case 0x2E:		return ((input_port_2_r(0) & 0x40) << 1);
		case 0x2F:		return ((input_port_2_r(0) & 0x80) << 0);
		/* DSW */
		case 0x10:
		case 0x14:
		case 0x30:
		case 0x34:		return ((input_port_0_r(0) & 0x03) << 6);
		case 0x11:
		case 0x15:
		case 0x31:
		case 0x35:		return ((input_port_0_r(0) & 0x0C) << 4);
		case 0x12:
		case 0x16:
		case 0x32:
		case 0x36:		return ((input_port_0_r(0) & 0x30) << 2);
		case 0x13:
		case 0x17:
		case 0x33:
		case 0x37:		return ((input_port_0_r(0) & 0xC0) << 0);
		/* Just in case */
		default:		return 0xFF;
	}
}

/***************************************************************************
Sync

When reading from SYNC:
   D4 = ATTRACT
   D5 = VRESET
   D6 = VBLANK*
   D7 = some alternating signal!?!

The only one of these I really understand is the VBLANK...
***************************************************************************/
int dominos_sync_r(int offset)
{
		static int ac_line=0x00;

		ac_line=(ac_line+1) % 3;
		if (ac_line==0)
				return ((input_port_4_r(0) & 0x7F) | dominos_attract | 0x80);
		else
				return ((input_port_4_r(0) & 0x7F) | dominos_attract );
}



/***************************************************************************
Attract
***************************************************************************/
void dominos_attract_w(int offset,int value)
{
	dominos_attract = (value & 0x01) << 6;
}

/***************************************************************************
Lamps
***************************************************************************/
void dominos_lamp1_w(int offset,int value)
{
	/* Address Line 0 is the data passed to LAMP1 */
	osd_led_w(0,offset & 0x01);
}

void dominos_lamp2_w(int offset,int value)
{
	/* Address Line 0 is the data passed to LAMP2 */
	osd_led_w(1,offset & 0x01);
}

/***************************************************************************
Sound function
***************************************************************************/
void dominos_tumble_w(int offset, int value)
{
	/* ??? */
	return;
}


