/*
* IRIX dependent code
*/
/*
 * 
 * Addition of new al stuff by Tristram Scott 23/9/98
 * 
 */
#ifdef irix
#define __IRIX_C_
#include "xmame.h"
#include "sound.h"

#ifndef IRIX_NOSOUND
#include <sys/stropts.h>
#include <dmedia/audio.h>
#include <errno.h>

ALport devAudio;
ALconfig devAudioConfig;
#endif
	
int sysdep_init(void) {
#ifndef IRIX_NOSOUND
#ifdef IRIX_HAVE_al
	ALpv pvs[4];
	int alIsBusy = 0;
#else
	long parambuf[4];
#endif
	if (play_sound) {

	    fprintf(stderr_file, "IRIX sound system initializing ...");

#ifdef IRIX_HAVE_al
	    /* first of all, look for anyone using driver */
	    pvs[0].param = AL_MAX_PORTS;
	    pvs[1].param = AL_UNUSED_PORTS;
	    if( alGetParams( AL_SYSTEM,pvs,2) < 0) {
		fprintf(stderr_file, "alGetParams failed: %s\n", alGetErrorString(oserror()));
		exit(1);
	    }
	    fprintf(stderr_file, "Maximum audio port count is %d, current unused count is %d\n",
	    	pvs[0].value.i,pvs[1].value.i);
	    if( pvs[1].value.i < 1) {
	        fprintf(stderr_file, "No unused audio ports, try using -nosound option\n");
		exit(1); 
	    }
	    if( pvs[1].value.i < pvs[0].value.i) {
	        fprintf(stderr_file, "Looks like someone else is using the audio device already.\n");
		pvs[0].param = AL_RATE;
		if( alGetParams( AL_DEFAULT_OUTPUT,pvs,1) < 0) {
		    fprintf(stderr_file, "alGetParams failed: %s\n", alGetErrorString(oserror()));
		    exit(1);
		}
		fprintf(stderr_file, "Current sample rate is %d, we will use that.\n", 
		    pvs[0].value.i);
		options.samplerate = pvs[0].value.i;
		alIsBusy = 1;
	    }

	    /* try to get a configuration descriptor */
	    if ( ( devAudioConfig=alNewConfig() ) == (ALconfig) NULL ){
		fprintf(stderr_file, "Cannot get a config Descriptor.Exiting\n");
		exit(1);
	    }

	    /* channel-specific parameters */	
	    alSetChannels(devAudioConfig,AL_MONO); 		/* mono */
	    alSetQueueSize(devAudioConfig,(int)AUDIO_BUFF_SIZE); /* buffer size */
	    alSetSampFmt(devAudioConfig,AL_SAMPFMT_TWOSCOMP);	/* linear signed */
	    alSetWidth(devAudioConfig,AL_SAMPLE_8);   	/* 8 bits */

	    /* global audio-device parameters */

	    pvs[0].param = AL_MASTER_CLOCK;
	    pvs[0].value.i = AL_CRYSTAL_MCLK_TYPE;
	    pvs[1].param = AL_RATE;
	    pvs[1].value.i = options.samplerate; 
 
	    if( !alIsBusy) {
		if( alSetParams( AL_DEFAULT_OUTPUT,pvs,2) < 0) {
		    fprintf(stderr_file, "Cannot Configure the sound system.Exiting...\n");
		    exit(1);
		}
	    }

	    /* try to get a Audio channel descriptor with pre-calculated params */
	    if ( ( devAudio=alOpenPort("audio_fd","w",devAudioConfig) ) == (ALport) NULL ){
		fprintf(stderr_file, "Cannot get an Audio Channel Descriptor.Exiting\n");
		exit(1);
	    }
#else
	    /* first of all, look for anyone using driver */
	    parambuf[0] = AL_INPUT_COUNT;
	    parambuf[2] = AL_OUTPUT_COUNT;
	    ALgetparams( AL_DEFAULT_DEVICE,parambuf,4);
	    if (parambuf[1] || parambuf[3]) {
		fprintf(stderr_file, "Someone is already using the sound system.Exiting..\n");
		exit(1);
	    }

	    /* try to get a configuration descriptor */
	    if ( ( devAudioConfig=ALnewconfig() ) == (ALconfig) NULL ){
		fprintf(stderr_file, "Cannot get a config Descriptor.Exiting\n");
		exit(1);
	    }

	    /* channel-specific parameters */	
	    ALsetchannels(devAudioConfig,AL_MONO); 		/* mono */
	    ALsetqueuesize(devAudioConfig,(long)AUDIO_BUFF_SIZE); /* buffer size */
	    ALsetsampfmt(devAudioConfig,AL_SAMPFMT_TWOSCOMP);	/* linear signed */
	    ALsetwidth(devAudioConfig,AL_SAMPLE_8);   	/* 8 bits */

	    /* global audio-device parameters */
	    parambuf[0]	= AL_OUTPUT_RATE;	parambuf[1] =	options.samplerate;
	    parambuf[2]	= AL_INPUT_RATE;	parambuf[3] =	options.samplerate;
	    if( ALsetparams( AL_DEFAULT_DEVICE,parambuf,4) < 0) {
		fprintf(stderr_file, "Cannot Configure the sound system.Exiting...\n");
		exit(1);
	    }

	    /* try to get a Audio channel descriptor with pre-calculated params */
	    if ( ( devAudio=ALopenport("audio_fd","w",devAudioConfig) ) == (ALport) NULL ){
		fprintf(stderr_file, "Cannot get an Audio Channel Descriptor.Exiting\n");
		exit(1);
	    }

#endif 
	} /* if (play_sound) */
#endif
	return TRUE;
}

void sysdep_exit(void) {
#ifndef IRIX_NOSOUND
#ifdef IRIX_HAVE_al
	if(play_sound){
		alClosePort(devAudio);
		alFreeConfig(devAudioConfig);
	}
#else
	if(play_sound){
		ALcloseport(devAudio);
		ALfreeconfig(devAudioConfig);
	}
#endif
#endif
}	

long sysdep_get_audio_freespace() {
#ifndef IRIX_NOSOUND
#ifdef IRIX_HAVE_al
	return alGetFillable(devAudio);
#else
	return ALgetfillable(devAudio);
#endif
#else
	return 0;
#endif
}

/* routine to dump audio samples into audio device */
int sysdep_play_audio(byte *buff, int size) {
#ifndef IRIX_NOSOUND
#ifdef IRIX_HAVE_al
	byte *pt=buff;
	/* try only to send samples that no cause blocking */
        long maxsize=alGetFillable(devAudio);
	/* new mixer code works in a unsigned char; driver is signed.... */
	for (;pt<(buff+size);pt++) *pt ^=0x80;
	return alWriteFrames(devAudio,(void *)buff,(size<=maxsize)?size:maxsize);	
#else
	byte *pt=buff;
	/* try only to send samples that no cause blocking */
        long maxsize=ALgetfillable(devAudio);
	/* new mixer code works in a unsigned char; driver is signed.... */
	for (;pt<(buff+size);pt++) *pt ^=0x80;
	return ALwritesamps(devAudio,(void *)buff,(size<=maxsize)?size:maxsize);	
#endif
#endif
}

#endif 
/****** end of IRIX dependent code; DO NOT WRITE BELOW THIS LINE *********/
