/* 
 * update_display_pseudo.c
 *
 * routines to perform the refresh of an XImage
 * this file contains the special cases for 8bpp psuedo color displays.
 */

#ifdef x11
#define __UPDATE_DSP_PSEUDO_C_

#include "xmame.h"

void do_update_truec_dirty_generic(void)
{
	char *pt;
	int x,y;
	int i,j;
	int line;
	long color;
	for (y=0, line=0; line<visual_height; line++, y+=heightscale) {
	   if (!dirty_lines[line].start) continue;
	   x = dirty_lines[line].x * widthscale;
	   for (pt=dirty_lines[line].start; pt<dirty_lines[line].end; pt++, x+=widthscale)
	   {
	      color=xpixel[0xff & *pt];
	      for(j=0;j<heightscale;j++) 
	         for(i=0;i<widthscale;i++) XPutPixel(image,x+i,y+j,color);
	   }
	}
	osd_refresh_dirty_screen();
}

void do_update_truec_generic(void)
{
   int i, line;
   int tmp_x,x,y,px,py;
   long color;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y+=heightscale)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)*widthscale) {
         if (*spt!=*dpt) {
            for (tmp_x=x,i=0;i<sizeof(long);i++,tmp_x+=widthscale)
            {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               for(py=0;py<heightscale;py++) 
                  for(px=0;px<widthscale;px++)
                     XPutPixel(image,tmp_x+px,y+py,color);
            } /* for i */
            *dpt=*spt;
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

void do_update_truec_dirty_scale1(void)
{
	char *pt;
	int line,x;

	for (line=0; line<visual_height; line++) {
	   if (!dirty_lines[line].start) continue;
	   x = dirty_lines[line].x;
	   for (pt=dirty_lines[line].start; pt<dirty_lines[line].end; pt++,x++)
		XPutPixel(image,x,line,xpixel[0xff & *pt]);
	}
	osd_refresh_dirty_screen();
}

void do_update_truec_scale1(void)
{
   int x,y;
   int line, update=0;
   long *end, *spt;
   long *dpt   =(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y++)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long))
      {
         if (*spt!=*dpt) {
            XPutPixel(image,x  ,y,xpixel[0xff & *((char *)spt  )]);
            XPutPixel(image,x+1,y,xpixel[0xff & *((char *)spt+1)]);
            XPutPixel(image,x+2,y,xpixel[0xff & *((char *)spt+2)]);
            XPutPixel(image,x+3,y,xpixel[0xff & *((char *)spt+3)]);
#ifdef linux_alpha  /* 64bit machines, */
            XPutPixel(image,x+4,y,xpixel[0xff & *((char *)spt+4)]);
            XPutPixel(image,x+5,y,xpixel[0xff & *((char *)spt+5)]);
            XPutPixel(image,x+6,y,xpixel[0xff & *((char *)spt+6)]);
            XPutPixel(image,x+7,y,xpixel[0xff & *((char *)spt+7)]);
#endif
            *dpt=*spt;
            update++;
         }
      }
   }
   if (update) osd_refresh_screen();
}

void do_update_truec_dirty_scale2(void)
{
	char *pt;
	int x,y;
	int line;
	long color;
	for (line=0, y=0; line<visual_height; line++, y+=2) {
	   if (!dirty_lines[line].start) continue;
	   x = dirty_lines[line].x << 1;
	   for (pt=dirty_lines[line].start; pt<dirty_lines[line].end; pt++,x+=2)
	   {
	      color=xpixel[0xff & *pt];
	      XPutPixel(image,x,y,color); XPutPixel(image,x+1,y,color);
	      XPutPixel(image,x,y+1,color); XPutPixel(image,x+1,y+1,color);
	   }
	}
	osd_refresh_dirty_screen();
}

void do_update_truec_scale2(void)
{
   int i,line;
   int x,y;
   long color;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y+=2)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)) {
         if (*spt!=*dpt) {
            for (i=0;i<sizeof(long);i++) {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               XPutPixel(image, ((x+i)<<1),   y  , color);
               XPutPixel(image, ((x+i)<<1)+1, y  , color);
               XPutPixel(image, ((x+i)<<1),   y+1, color);
               XPutPixel(image, ((x+i)<<1)+1, y+1, color);
            } /* for i */
            *dpt=*spt; /* mark long as updated */
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

void do_update_truec_dirty_scale3(void)
{
	char *pt;
	int x,y;
	int line;
	long color;
	for (line=0, y=0; line<visual_height; line++, y+=3) {
	   if (!dirty_lines[line].start) continue;
	   x = dirty_lines[line].x * 3;
	   for (pt=dirty_lines[line].start; pt<dirty_lines[line].end; pt++,x+=3)
	   {
	      color = xpixel[0xff & *pt];
	      XPutPixel(image,x,y  ,color); XPutPixel(image,x+1,y  ,color); XPutPixel(image,x+2,y  ,color);
	      XPutPixel(image,x,y+1,color); XPutPixel(image,x+1,y+1,color); XPutPixel(image,x+2,y+1,color);
	      XPutPixel(image,x,y+2,color); XPutPixel(image,x+1,y+2,color); XPutPixel(image,x+2,y+2,color);
	   }
	}
	osd_refresh_dirty_screen();
}

void do_update_truec_scale3(void)
{
   int i,line;
   int tmp_x,x,y;
   long color;
   long *spt, *end;
   long *dpt=(long *)copybuffer;
   for (line=visual.min_y, y=0; line<=visual.max_y; line++, y+=3)
   {
      spt=(long *)( (char *)bitmap->line[line] + visual.min_x);
      end=(long *)( (char *)bitmap->line[line] + visual.min_x + visual_width );
      for (x=0;spt<end;spt++,dpt++,x+=sizeof(long)*3) {
         if (*spt!=*dpt) {
            for (tmp_x=x,i=0; i<sizeof(long); i++,tmp_x+=3) {
               if ( *((char *)spt+i) == *((char *)dpt+i) ) continue;
               /* now perform a byte-by-byte search in current long pt */
               color=xpixel[0xff & *((char *)spt+i)];
               XPutPixel(image,tmp_x,y,  color); XPutPixel(image,tmp_x+1,y  ,color); XPutPixel(image,tmp_x+2,y  ,color);
               XPutPixel(image,tmp_x,y+1,color); XPutPixel(image,tmp_x+1,y+1,color); XPutPixel(image,tmp_x+2,y+1,color);
               XPutPixel(image,tmp_x,y+2,color); XPutPixel(image,tmp_x+1,y+2,color); XPutPixel(image,tmp_x+2,y+2,color);
            } /* for i */
            *dpt=*spt; /* mark long as updated */
         } /* if long is not equal */
      } /* for buffer */
   } /* for line */
   osd_refresh_screen();
}

#endif /* ifdef x11 */
