/*
   CTHUGHA-L 							cth_buffer.h

   Definitions about the buffer-stuff.
*/

#ifndef __CTH_BUFFER_H__
#define __CTH_BUFFER_H__

#if defined(CONST_BUFF) || defined(BUFF_WIDTH) || defined(BUFF_HEIGHT)

    #ifndef BUFF_WIDTH
        #define BUFF_WIDTH	320
    #endif
    #ifndef BUFF_HEIGHT    
        #define BUFF_HEIGHT	200
    #endif

    #define BUFF_BOTTOM	(BUFF_HEIGHT-1)
    #define BUFF_SIZE	(BUFF_WIDTH * BUFF_HEIGHT)

   /*
    * Type of integer used for translation-files.
    *  32-bit interers used only if need.
    */
    #if BUFF_SIZE > 65535
        typedef int tint;	
        typedef unsigned int utint;
    #else
        typedef short tint;
        typedef unsigned short utint;
    #endif

#else

    #define MAX_BUFF_WIDTH	2048
    #define MAX_BUFF_HEIGHT	2048
    extern int BUFF_WIDTH;
    extern int BUFF_HEIGHT;

    extern int buffer_sizes[][2];		/* predefned buffer-sizes */
    extern int nr_buffer_sizes;

    #define BUFF_BOTTOM	(BUFF_HEIGHT-1)
    #define BUFF_SIZE	(BUFF_WIDTH * BUFF_HEIGHT)

#endif

#endif
	
