#include "cthugha.h"
#include "sound.h"
#include "imath.h"

#include <sys/soundcard.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>

/*
 * use the old method for reading the sound
 */
int sound_sync = 0;				/* reset sound after reading */

static int sound_handle;			/* descriptor to dsp_file */
static int sound_fmt = AFMT_U8;	
static unsigned int sound_fragment = 8;
static unsigned int sound_fragment_size = 0;
static int sound_mode = 0;
static char * dsp_name = DEV_DSP;

/*
 * Initialize /dev/dsp
 */
int sound_dsp_init(int mode) {
    printfv(3,"  setting %s...\n", dsp_name);

    sound_mode = mode;

    /* Get sound-device */
    if ( (sound_handle = open(dsp_name, mode) ) < 0) {
 	printfee("Can't open `%s'%s.", 
		 dsp_name,
		 (mode == O_RDONLY) ? " for reading" :
		 (mode == O_WRONLY) ? " for writing" :
		 "");
	return 1;
    }

#if USE_OLDSND == 1

    /* fragment size of 16 bytes (2^4), two fragments (2) */
    sound_fragment = 0x00020004;      
    if ( ioctl(sound_handle, SNDCTL_DSP_SETFRAGMENT, &sound_fragment) < 0 )
        printfee("ioctl: SNDCTL_DSP_SETFRAGMENT failed.");

#else

    /* set sound fragment size and number of fragments */
    sound_fragment = (ilog2(sound_bsize) - 1) | (sound_options->fragments << 16);
    if ( ioctl(sound_handle, SNDCTL_DSP_SETFRAGMENT, &sound_fragment) < 0 )
	printfee("ioctl: SNDCTL_DSP_SETFRAGMENT failed.");
    sound_options->fragments = sound_fragment >> 16;
    sound_fragment_size = 1 << (sound_fragment & 0x7fff);
    if( sound_fragment_size*2*sound_options->channels < sound_bsize) {
	printfv(1, "  sound fragment size is not set big enough.\n");
    }

#endif

    /* set sound format */
    if ( ioctl(sound_handle, SNDCTL_DSP_SETFMT, &sound_fmt) < 0 )
	printfee("ioctl: SNDCTL_DSP_SETFMT failed");

    /* set stereo or mono */
    sound_options->channels --;
    if ( ioctl(sound_handle, SNDCTL_DSP_STEREO, &sound_options->channels) < 0 )
	printfee("ioctl: SNDCTL_DSP_STEREO failed");
    sound_options->channels ++;
			
    /* set sample rate */
    if ( ioctl(sound_handle, SNDCTL_DSP_SPEED, &sound_options->speed) < 0 )
	printfee("ioctl: SNDCTL_DSP_SPEED failed");

    /* set sample size (bits/sample/channel) */
    if ( ioctl(sound_handle, SNDCTL_DSP_SAMPLESIZE, &sound_options->bps) < 0)
	printfee("ioctl: SNDCTL_DSP_SAMPLESIZE failed");

    printfv(3,"    sound fragments    : %d\n", sound_options->fragments);
    printfv(3,"    sound fragment size: %d\n", sound_fragment_size);
    printfv(3,"    number of channels : %d\n", sound_options->channels);
    printfv(3,"    sound buffer size  : %d\n", sound_bsize);
    printfv(3,"    sample rate        : %d\n", sound_options->speed);
    printfv(3,"    sample size        : %d\n", sound_options->bps);
	
    return 0;
}


/*
 *  Update sample rate, mono/stero
 */
int sound_dsp_update() {
    if(sound_fork) {
	*sound_action = sa_update;
	return 0;
    }

    alloc_sound();			/* might be freed */

    if( !sound_use[snddev_dsp_r] && !sound_use[snddev_dsp_w])
	return 0;
	
    sound_dsp_exit();
    sound_dsp_init(sound_mode);

#if 0
    ioctl(sound_handle, SNDCTL_DSP_RESET);
    
    sound_options->channels --;			/* bring to 0, 1 for mono/stereo */
    if ( ioctl(sound_handle, SNDCTL_DSP_STEREO, &sound_options->channels) < 0 )
	printfee("ioctl: SNDCTL_DSP_STEREO failed");
    sound_options->channels ++;			/* bring back to nr. of channels */
		
    if ( ioctl(sound_handle, SNDCTL_DSP_SPEED, &sound_options->speed) < 0 )
	printfee("ioctl: SNDCTL_DSP_SPEED failed");
#endif

    return 0;
}


/*
 * Get sound from sound-card
 *
 * Jan Kujawa <kujawa@kallisti.montana.com> 
 *   helped a lot to do this better.
 */
int sound_dsp_read() {

#if USE_OLDSND == 1

    unsigned char * sbuff;
    int nr_read, i;
    unsigned char sound_buffer[65536];

    /* Important information from Jan Kujawa <kujawa@kallisti.montana.com>
       how to do this correctly */
    for(nr_read = 0, sbuff=sound_buffer; 
        nr_read < sound_bsize*sound_options->channels; nr_read += 32) {
        if( read(sound_handle, sbuff, 16) < 0)
            printfee("sound_read < 0"); 
        sbuff += 16;
        if( read(sound_handle, sbuff, 16) < 0)
            printfee("sound_read < 0");
        sbuff += 16;
    }
    /* this should no longer be necessary */
    if(sound_sync)
        ioctl(sound_handle, SNDCTL_DSP_RESET);   

    /* Bring the read data to the right place */        
    sbuff = sound_buffer;
    if ( sound_options->channels == 2) {
        for(i=0; i < sound_bsize; i++) {
            sound_data[i][1] = (int)(*sbuff ++) - 128;
            sound_data[i][0] = (int)(*sbuff ++) - 128;
        }
    } else {
        for(i=0; i < sound_bsize; i++) {
            sound_data[i][0] = (int)(*sbuff) - 128;
            sound_data[i][1] = (int)(*sbuff ++) - 128;
        }       
    }

#else
    
    int i;
    audio_buf_info bi;
    int nr_read = sound_options->channels * sound_bsize / sound_fragment_size;
    unsigned char sound_buffer[sound_fragment_size * 2 * sound_options->channels];

    /* get number of available fragments */
    if( ioctl(sound_handle, SNDCTL_DSP_GETISPACE, &bi) < 0) {
	printfee("ioctl: SNDCTL_DSP_GETISPACE failed.");
    }

    /* read any extra sound data */
    for(i=0; i < bi.fragments-nr_read; i++ )
	read(sound_handle, sound_buffer, sound_fragment_size);

    /* read the sound data, that will be display */
    if( read(sound_handle, sound_buffer, sound_fragment_size * nr_read) < 0) {
	printfee("reading sound failed."); 
    }

    /* this should no longer be necessary */
    if(sound_sync)
    	ioctl(sound_handle, SNDCTL_DSP_RESET);   

    sound_convert(sound_buffer, sound_options->channels, sound_options->bps);

#endif

    return 0;
}

int sound_dsp_write(unsigned char *data) {

    write(sound_handle, data, sound_options->channels * sound_bsize * sound_options->bps);
    return 0;
}


int sound_dsp_exit() {
    close(sound_handle);
    return 0;
}



