#include "cthugha.h"
#include "sound.h"

#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

char * mixer_names[] = SOUND_DEVICE_NAMES;
int mixer_volumes[SOUND_MIXER_NRDEVICES];

int mixer_idx2dev[SOUND_MIXER_NRDEVICES];
int mixer_nr_names = 0;

static int mixer_max_nr = SOUND_MIXER_NRDEVICES;
static char * mixer_name = DEV_MIXER;

/*
 * check which mixer devices are available
 */
int mixer_init_names() {
    int mixer_des;
    int dev_mask = 0;
    int i;
    static int done = 0;

    if(done)			/* only do this once */
	return 0;
    done = 1;

    if ( (mixer_des = open(mixer_name, O_RDWR)) < 0) {
	printfee("Can not open %s.", mixer_name);
	return 1;
    }

    /* check, which features are actually available */
    if( ioctl(mixer_des, SOUND_MIXER_READ_DEVMASK, &dev_mask) < 0) {
	printfee("Can not get mixer device mask.");
    }
    for(i=0; i < mixer_max_nr; i++) {
	if( (dev_mask & 1) == 0) {
	    printfv(10, "  unavailable mixer device `%s'.\n", mixer_names[i]);
	    mixer_names[i] = NULL;
	} else {
	    mixer_idx2dev[mixer_nr_names] = i;
	    mixer_nr_names ++;
	}
	mixer_volumes[i] = -1;
	    
	dev_mask >>= 1;
    }
    close(mixer_des);

    return 0;
}


int mixer_set_volume(char * name, int volume) {
    int i;

    mixer_init_names();		/* make sure everything is set */

    for(i=0; i < mixer_max_nr; i++)
	if( mixer_names[i] != NULL)
	    if( strcasecmp(mixer_names[i], name) == 0) {
		mixer_volumes[i] = volume;
		i = mixer_max_nr + 1;
	    }
    if(i == mixer_max_nr) {
	printfe("unknown or unsupported mixer setting `%s'.\n", name);
	return 1;
    }
    if(strcasecmp(name, "cd") ==0)
	sound_use[snddev_cd] = 1;

    return 0;
}


/*
 * Initialize /dev/mixer
 */
int sound_set_mixer() {
    int mixer_des;
    int sound_mask = 0;
    int force = 0;
    int i;

    printfv(3,"  setting %s...\n", mixer_name);

    /* open mixer-file */	
    if ( (mixer_des = open(mixer_name, O_RDWR)) < 0) {
	printfee("Can not open %s.", mixer_name);
	return 1;
    }

    /* create sound mask */
    for(i=0; i < mixer_max_nr; i++) {
	if( mixer_volumes[i] > 0) {
	    sound_mask |= (1 << i);
	} else if( mixer_volumes[i] == 0) {
	    force = 1;
	    printfv(3, "    disabling %s as input.\n", mixer_names[i]);
	}
    }
    
    if( sound_mask || force) {
	/* Select input sources */
	if(ioctl(mixer_des,MIXER_WRITE(SOUND_MIXER_RECSRC),&sound_mask) < 0) {
	    printfee("Can not set recording source");
	}

	/* Select input-volumes */
	for(i=0; i < mixer_max_nr; i++) {
	    if(mixer_volumes[i] >= 0) {
		ioctl(mixer_des, MIXER_WRITE(i), &mixer_volumes[i]);
		printfv(3,"    using %s as input (volume: %d).\n", 
			mixer_names[i],  mixer_volumes[i] & 255);
	    }
	}
    }

    /* close mixer-file */
    close( mixer_des);	
	
    return 0;
}

