module Color(
	Color(..), 
	minColor, maxColor, colorName
	) where

data Color = White | Black | Red | Green | Blue | LightBlue | RoyalBlue | Yellow | Brown
  deriving (Eq, Ord, Enum, Ix, Show)

minColor, maxColor :: Color
minColor = White
maxColor = Brown

colorName :: Color -> String
--use one or other depending on whether you have a colour screen or not
colorName c = show c
--colorName c = monochrome c 
 where
  monochrome White     = "white"
  monochrome Black     = "black"
  monochrome Red       = "grey75"
  monochrome Green     = "grey75"
  monochrome Blue      = "grey25"
  monochrome LightBlue = "grey25"
  monochrome RoyalBlue = "grey75"
  monochrome Yellow    = "grey25"
  monochrome Brown     = "grey75"



