{-****************************************************************
  MODULE R_DEFAULTS

    This module uses the Behaviour module to define convenient and
  easy to use behaviours. These aren't very sophisticated, but they
  can be used to quickly animate a movie. For more sophisticated
  animation, a similiar library of sophisticated personalized 
  functions can be created.

******************************************************************-}

module Defaults(
       -- scaling
       scaleunit, 
       huge, big, small, tiny,
       bigger, smaller,

       -- rotating
       rotunit,
       ccw, cw, 

       -- translating
       punit,
       up, down, left, right
       ) where

import Picture(Pic)
import qualified Picture as Pic
{-
	(scale, twist,mov)
-}
import Behaviour(Behaviour)

  -- unit for scaling pictures by.
  -- The scaleunit is in 11th, so that the 12 is actually 12/11'ths
scaleunit :: Int
scaleunit = 12

  -- big scales everything up by the scaleunit (now 12/11ths)
  -- huge scales everything up by twice the scaleunit (24/11ths)
  -- small scales everything down by 10/11ths
  -- tiny scales everything down by 5/11ths
huge, big, small, tiny :: Behaviour
huge  = repeat (Pic.scale (scaleunit*2))
big   = repeat (Pic.scale scaleunit)
small = repeat (Pic.scale 10)
tiny  = repeat (Pic.scale 5)
  
  -- bigger causes the Pics to be scaled up by 12/11ths,24/11ths,36/11ths
  -- and so on, everincreasing.
  -- ADRNote: does nothing of the kind.  
  --    Scales by: 12/11, 144/121, ...
  -- smaller causes the Pics to be scaled downwards in ever decreasing 
  -- amounts.
bigger, smaller :: Behaviour
bigger  = [Pic.scale x | x <- iterate (\x -> (x*scaleunit) `div` 11) 1]
smaller = [Pic.scale x | x <- iterate (\x -> (x*10) `div` 11) 1]


  -- unit of rotation - 10 degrees
rotunit :: Float
rotunit  = pi/18

  -- rotates the Pics by one rotunit more every Pic, either
  -- clockwise (cw) or counterclockwise (ccw)
cw, ccw :: Behaviour
cw  = [Pic.twist x | x <- [0.0,-rotunit..]]
ccw = [Pic.twist x | x <- [0.0,rotunit..]]

  
  -- unit of length within pictures
punit, hf, qt :: Int
punit = 15
hf    = punit `div` 2
qt    = punit `div`4

  -- moves the Pic up, left, right or down by one more unit every Pic.
up, down, left, right :: Behaviour
up    = [Pic.mov (0,y) | y <- [0,punit..]]
down  = [Pic.mov (0,y) | y <- [0,-punit..]] 
left  = [Pic.mov (x,0) | x <- [0,-punit..]] 
right = [Pic.mov (x,0) | x <- [0,punit..]] 
  

