module Movie(
	Movie,
	null, mkMovie, picsOf,
	ht, wid, orig,
	repeat,
        above, rABOVE, beside, rBESIDE,rBESIDE2, over, rOVER,
        overlay, rOVERLAY, put
        ) where

import Prelude hiding (null, repeat)
import Vector
import Picture(Pic)
import qualified Picture
{-
	(
        null, 
	above, beside, beside2, over, overlay,
	put,
        ht, wid, orig
        )
-}
	as Pic

{-
  ADRNote: movies are often infinite lists - but not always
-}
type Movie = [Pic] in
	null, mkMovie, picsOf,
	promote2, promote3, repeat,
	ht, wid, orig

null :: Movie
null = repeat Pic.null

mkMovie :: [Pic] -> Movie
mkMovie ps = ps

picsOf :: Movie -> [Pic]
picsOf ps = ps

  -- ht takes a Movie and returns a list of the heights of the Pics
ht :: Movie -> [Int]
ht = map Pic.ht

  -- wid takes a Movie and returns a list of the widths of the Pics
wid :: Movie -> [Int]
wid  = map Pic.wid

  -- orig takes a Movie and returns a list of vectors that are the
  -- origins of the Pics
orig:: Movie -> [Vec]
orig = map Pic.orig

  -- promote2 takes a function accepting an element and a Pic, and
  -- applies the function to the Movie and list, producing a new Movie
promote2 :: (Pic -> Pic -> Pic) -> Movie -> Movie -> Movie
promote2 = zipWith

promote3 :: (a -> Pic -> Pic -> Pic) -> [a] -> Movie -> Movie -> Movie
promote3 = zipWith3

repeat :: Pic -> Movie
repeat = Prelude.repeat

  -- takes two Movies and put_Movies them Pic.above one another
above :: Movie -> Movie -> Movie
above = promote2 Pic.above

  -- takes two Movies and puts them beside one another
beside:: Movie -> Movie -> Movie
beside = promote2 Pic.beside

  -- same as beside, but with absolute coordinates.
beside2:: Movie -> Movie -> Movie
beside2 = promote2 Pic.beside2

  -- puts one Movie on top of the other Movie
over :: Movie -> Movie -> Movie
over = promote2 Pic.over

  -- just overlays the two Movies by appending the Pics.
overlay :: Movie -> Movie -> Movie
overlay = promote2 Pic.overlay

  -- put_Movie takes a list of Vectors, and puts each Pic of the first Movie
  -- in the location of the corresponding vector, on top  of the Pic of
  -- the second Movie, and returns that list as a new Movie.
put :: [Vec] -> Movie -> Movie -> Movie
put = promote3 Pic.put


  -- takes a list of Movies and puts them all above one another
rABOVE:: [Movie] -> Movie
rABOVE = foldr above null

  -- takes a list of Movies and puts them all beside one another
rBESIDE:: [Movie] -> Movie
rBESIDE = foldr beside null

  -- same as rBESIDE, but with absolute coordinates.
rBESIDE2:: [Movie] -> Movie
rBESIDE2 = foldr beside2 null

  -- takes a list of Movies, and puts the n-th on top of the first
  -- through (n-1)th.
rOVER:: [Movie] -> Movie
rOVER = foldr over null

  -- overlays a list of Movies by appending the Pics
rOVERLAY:: [Movie] -> Movie
rOVERLAY = foldr overlay null




