module Screen(
  screenwid, screenht, 
  botl, botm, botr,
  topl, topm, topr,
  leftm, rightm,

  leftmb, leftmt,
  rightmt, rightmb,
  topml, topmr,
  botml, botmr,
  center
  ) where

import Vector(Vec(..))

  -- Screen Parameters
screenwid :: Int
screenwid = 800
screenht :: Int
screenht  = 800

botl, botm, botr :: Vec
topl, topm, topr :: Vec
leftm, rightm :: Vec

leftmb, leftmt :: Vec
rightmt, rightmb :: Vec
topml, topmr :: Vec
botml, botmr :: Vec
center :: Vec

botl   = ( 0, 0 )
leftm  = ( 0, screenht `div` 2)
topl   = ( 0, screenht )
topm   = ( screenwid `div` 2, screenht )
topr   = ( screenwid, screenht )
rightm = ( screenwid, screenht `div` 2 )
botr   = ( screenwid, 0 )
botm   = ( screenwid `div` 2, 0 )
center = ( screenwid `div` 2, screenht `div` 2 )

leftmb  = ( 0, screenht `div` 4 )
leftmt  = ( 0, (screenht*3) `div` 4 )
topml   = ( screenwid `div` 4, screenht )
topmr   = ( (screenwid*3) `div` 4, screenht )
rightmt = ( screenwid, (screenht*3) `div` 4 )
rightmb = ( screenwid, screenht `div` 4 )
botml   = ( screenwid `div` 4, 0 )
botmr   = ( (screenwid*3) `div` 4, 0 )
