{-*****************************************************************
  MODULE R_SHAPES
  
    This modules produces Pic's of boxes and triangles to help build
  Pic's to animate.    
    
******************************************************************-}

module Shapes (box, tri, circ) where

import Utility
import Picture(Pic)
import qualified Polygon as Poly
import qualified Picture as Pic
import Color
import Vector

  -- box takes the color, width and height of the box and
  -- returns a Pic of a box
box :: Color -> Int -> Int -> Pic
box c width height 
  = Pic.poly c [(0,0),(width,0),(width,height),(0,height),(0,0)]

  -- tri takes a color and three vectors, and returns a Pic of a triangle
  -- with the vectors as vertices
tri:: Color -> Vec -> Vec -> Vec -> Pic
tri c v1 v2 v3 
  = Pic.poly c [v1, v2, v3, v1]


-- circ color radius sides produces a polygon with n sides 
-- and appropriate radius and color centered around (r,r)
circ :: Color -> Int -> Int -> Pic
circ c radius sides 
  = Pic.poly c [ coord a | a <- [0..sides] ]
 where 
  r :: Float
  r = fromIntegral radius

  -- angle (radians) between two sides
  angle :: Float
  angle = 2 * pi / fromIntegral sides

  coord :: Int -> Vec
  coord side = vftov (x+r,y+r)
   where 
    x = r * cos (angle * fromIntegral side)
    y = r * sin (angle * fromIntegral side)
                    
