module Vector(
	Vec(..), VecFloat(..),
	vtovf, vftov,
	vplus, vmin, partway,
	flipx_Vec, flipy_Vec, flip_Vec,
	mid
	) where


type Vec       = (Int,Int)
type VecFloat = (Float,Float)

-- CONVERSION

  -- vtovf takes a vector of integers, and converts it to a vector of floats
vtovf :: Vec -> VecFloat
vtovf (x,y) = (fromIntegral x,fromIntegral y)

  -- vftov takes a vector of floats and converts it to a vector of integers.
  -- It rounds the floats off to do this.
vftov :: VecFloat -> Vec
vftov (x,y) = (round x,round y)


-- VECTOR OPERATIONS:

  -- vector addition
vplus:: Vec -> Vec -> Vec
vplus (a,b) (c,d) = (a+c,b+d)

  -- vector substraction
vmin:: Vec -> Vec -> Vec
vmin (a,b) (c,d) = (a-c,b-d)

  -- finds the midpoint between two vectors
mid:: Vec -> Vec -> Vec
mid (x1,y1) (x2,y2) = (x1+x2 `div` 2, y1+y2 `div` 2)

  -- finds a point p/q along the way between two vectors
partway :: Int -> Int -> Vec -> Vec -> Vec
partway p q (x1,y1) (x2,y2)
        = vplus (x1,y1) ((x2-x1)*p `div` q, (y2-y1)*p `div` q)

  -- flip a vector about x=n (resp. y=n)
flipx_Vec, flipy_Vec :: Int -> Vec -> Vec
flipx_Vec n (x, y) = (2*n-x, y)
flipy_Vec n (x, y) = (x, 2*n-y)

  -- rotate a vector 180 degrees about the point (a, b)
flip_Vec (a,b) (x, y) = (2*a-x, 2*b-y)


