module DownLoadPapers (main) where

{-
A demo of a GUI (last modified: Friday, March 07, 1997)

Erik Meijer (erik@cs.ruu.nl)
-}

import Assoc
import Mime
import HTML
import HTMLWizard
import PrettyHTML
import CgiOut
import Wrapper

main
 = simpleWrapper paperForm

paperForm env
 = case find env "Paper" of
      [paper]  -> deliverPaper paper (find env "media")
      _        -> presentChoice

deliverPaper paper media
 = case media of
      ["ps"]  -> case find psPapers paper of
                   [paper] -> Location{ url = root++"/ps/"++paper++".ps" }
                   _       -> paperNotFound paper "ps"
      ["dvi"] -> case find dviPapers paper of
                   [paper] -> Location{ url = root++"/dvi/"++paper++".dvi" }
                   _       -> paperNotFound paper "dvi"

paperNotFound paper media
 = Content{ mime = page "Paper Not Found" []
                    [ prose "Your requested paper "
                    , format "STRONG"  paper
                    , prose " is not available in "
                    , format "STRONG" media
                    , prose " format! "
                    , href downloadPapers
                        [prose "Please, make another choice."]
                    ]
          }

presentChoice
 = Content{ mime = page "Erik's Papers" []
                    [ h1 "Download my research papers"
                    , gui downloadPapers
                       [ menu "Paper"
                          [ mondrian
                          , bananas
                          , bananas_in_space
                          , henk
                          , parsers
                          , back_to_basics
                          , type_classes
                          ]
                        , (radio `group` "media")  ["ps", "dvi"]
                        , submit "" "Submit", reset "" "Reset"
                        ]
                    ]
           }

downloadPapers
 = "http://www.cse.ogi.edu/~erik/cgi-bin/download.cgi"

mondrian         = "The Design and Implementation of Mondrian"
bananas          = "Functional Programming With Banananas, Lenses and Barded Wire"
bananas_in_space = "Bananas in Space"
henk             = "Henk"
parsers          = "Monadic Parser Combinators"
back_to_basics   = "Back to Basics"
type_classes     = "Type Classes in Haskell 1.4 and beyond"

root
 = "http://www.cse.ogi.edu/~erik/Papers"

psPapers
 = [ (mondrian         , "mondrian")
   , (bananas          , "bananas")
   , (bananas_in_space , "space")
   , (henk             , "henk")
   , (parsers          , "parsing")
   , (back_to_basics   , "basics")
   , (type_classes     , "multi")
   ]

dviPapers
 = [ (mondrian         , "mondrian")
   , (henk             , "henk")
   , (type_classes     , "multi")
   ]
