module GraphicsBrush(
	Brush,
	mkBrush, withBrush,
	createBrush, deleteBrush
	-- blackBrush, whiteBrush,
	) where

import GraphicsTypes
import GraphicsUtilities( bracket, bracket_ )
import qualified Win32

----------------------------------------------------------------
-- The interface
----------------------------------------------------------------

newtype Brush = MkBrush Win32.HBRUSH

mkBrush     :: RGB   -> (Brush -> Picture) -> Picture
withBrush   :: Brush -> Picture -> Picture

createBrush :: RGB   -> IO Brush
deleteBrush :: Brush -> IO ()

----------------------------------------------------------------
-- The implementation
----------------------------------------------------------------

createBrush (RGB r g b) = 
  Win32.createSolidBrush (Win32.rgb r g b) >>= return . MkBrush
deleteBrush (MkBrush b) = 
  Win32.deleteBrush b

mkBrush rgb p = \ hdc ->
  bracket (createBrush rgb) deleteBrush $ \ brush ->
  p brush hdc

withBrush (MkBrush brush) p = \ hdc ->
   bracket_ (Win32.selectBrush hdc brush) (Win32.selectBrush hdc) (p hdc)

----------------------------------------------------------------
-- 
-- -- special cases - these should _never_ be deleted
-- blackBrush :: IO Brush
-- whiteBrush :: IO Brush
-- 
-- blackBrush = Win32.getStockBrush Win32.bLACK_BRUSH >>= return . MkBrush
-- whiteBrush = Win32.getStockBrush Win32.wHITE_BRUSH >>= return . MkBrush
-- 
----------------------------------------------------------------
