#!/bin/sh
# Configure script for Hugs (using Borland bcc16)

# Before we can run the configure script, we have to patch some
# incompatabilities between Unix and Windows:
# 
# o Borland C sends error messages to stdout (instead of stderr).
#   Replacing uses of ">/dev/null" with ">conftest.out" (which is
#   where stderr is normally sent) hacks around this.
#
# o Borland C insists that "-o" options be of the form "-ofoo" 
#   - not -o foo.  
#   And it sometimes just refuses to handle them at all - so we delete
#   "-o hugs.exe" from the generated Makefile.
#
# o Borland C writes input filenames to stderr as it processes them.
#
# o DOS truncates name to 8 characters which confuses conftestval 
#   with the program conftest

sed ../unix/configure >./config.fix            \
  -e "s#/dev/null#conftest.out#"       	       \
  -e "s/-o /-o/g"                      	       \
  -e "s/-v '\^ \*+'/-i error/g"        	       \
  -e "s/conftestval/conftest.val/g"    	       \
  -e "s/test -s conftest/test -s conftest.exe/g"

# Now we override the default values of some environment variables.

set -a # All modified env vars are to be exported!

CC=${CC="bcc"}                  
CPP=${CPP="cpp"}                
# DEBUGFLAGS=${DEBUGFLAGS="-v"}
# LDDEBUGFLAGS=${LDDEBUGFLAGS="-v"}
# OPTFLAGS=${OPTFLAGS="-d -y-"}
DLL_FLAGS=${DLL_FLAGS="-WDE"}   
CFLAGS=${CFLAGS="-tD -ml -j5 -w-pia -w-aus -w-par -w-rvl*"} 
LDFLAGS=${LDFLAGS="-tD -ml"}    

# Run the script

./config.fix --target=dos $*

# Now patch the Makefile - changing "-o foo" to "-ofoo"
# and using an rsp file to overcome command line length problems.

mv ../Makefile ../Makefile.orig

sed ../Makefile.orig >../Makefile -e'
s/-o hugs.exe//g
s/-o runhugs.exe//g
/		  $(CC) $(LDFLAGS) runhugs.obj $(SERVER_OBJECTS) $(LIBS) /c\
		  echo runhugs.obj $(SERVER_OBJECTS) >runhugs.rsp\
		  $(CC) $(LDFLAGS) @runhugs.rsp $(LIBS)
#
/		  $(CC) $(LDFLAGS) $(IOBJECTS)  $(LIBS)  /c\
		  echo $(IOBJECTS) >hugs.rsp\
		  $(CC) $(LDFLAGS) @hugs.rsp  $(LIBS)
#
/		  $(CC) $(LDFLAGS) $(IOBJECTS) win-text.obj $(LIBS)  /c\
		  echo $(IOBJECTS) win-text.obj >hugs.rsp\
		  $(CC) $(LDFLAGS) @hugs.rsp $(LIBS)  
#
'

# End
