.TH lqg 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
lqg - LQG compensator
.SH CALLING SEQUENCE
.nf
[K]=lqg(P,r)
.fi
.SH PARAMETERS
.TP 10
P
: \fVsyslin\fR list (augmented plant) in state-space form
.TP
r
: 1x2 row vector = (number of measurements, number of inputs)  (dimension of
 the 2,2 part of \fVP\fR)
.TP
K
: \fVsyslin\fR list (controller)
.SH DESCRIPTION
\fVlqg\fR  computes the linear optimal LQG (H2) controller for the 
"augmented" plant \fVP=syslin('c',A,B,C,D)\fR (continuous time) or 
\fVP=syslin('d',A,B,C,D)\fR (discrete time).
.LP
The function \fVlqg2stan\fR returns \fVP\fR and \fVr\fR given the
nominal plant, weighting terms and variances of noises.
.LP
\fVK\fR is given by the following ABCD matrices: 
\fV[A+B*Kc+Kf*C+Kf*D*Kc,-Kf,Kc,0]\fR where \fVKc=lqr(P12)\fR
is the controller gain and \fVKf=lqe(P21)\fR is the filter gain.
See example in \fVlqg2stan\fR.
.SH SEE ALSO
lqg2stan, lqr, lqe, h_inf, obscont
.SH AUTHOR
F.D.
