.TH cdff 1 "Dec 1997" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cdff - cumulative distribution function F distribution 
.SH CALLING SEQUENCE
.nf
[P,Q]=cdff("PQ",F,Dfn,Dfd)
[F]=cdff("F",Dfn,Dfd,P,Q);
[Dfn]=cdff("Dfn",Dfd,P,Q,F);
[Dfd]=cdff("Dfd",P,Q,F,Dfn)
.fi 
.SH PARAMETERS
.TP 10
P,Q,F,Dfn,Dfd
: five real vectors of the same size.
.TP
P,Q (Q=1-P)
:  The integral from 0 to F of the f-density.
Input range: [0,1].
.TP
F 
: Upper limit of integration of the f-density.
Input range: [0, +infinity).
Search range: [0,1E300]
.TP
Dfn
: Degrees of freedom of the numerator sum of squares.
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.TP
Dfd
: Degrees of freedom of the denominator sum of squares.
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.SH DESCRIPTION
Calculates any one parameter of the F distribution
given values for the others.
.LP
Formula   26.6.2   of   Abramowitz   and   Stegun,  Handbook  of
Mathematical  Functions (1966) is used to reduce the computation
of the  cumulative  distribution function for the  F  variate to
that of an incomplete beta.
.LP
Computation of other parameters involve a seach for a value that
produces  the desired  value  of P.   The search relies  on  the
monotinicity of P with the other parameter.
.LP
The value of the  cumulative  F distribution is  not necessarily
monotone in  either degrees of freedom.  There  thus may  be two
values  that  provide a given CDF  value.   This routine assumes
monotonicity and will find an arbitrary one of the two values.
.LP
From DCDFLIB: Library of Fortran Routines for Cumulative Distribution
Functions, Inverses, and Other Parameters (February, 1994)
Barry W. Brown, James Lovato and Kathy Russell. The University of
Texas.
