.TH "mtlb_diff" 2 " June 6th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
mtlb_diff - Difference and approximate derivative
.sp
Author: Paulo Goncalves
.sp
Difference and approximate derivative. If x is a matrix, the differences are computed columnwise.
.sp
.sp
.SH Usage
.sp
.ft CR
.nf
[y] = mtlb_diff(x[,order])
.fi 
.ec
.ft P
.sp
.SH Input parameters


.RS

.TP
o 
\fBx\fP : real valued vector or matrix \f(CR[\fPrx,cx\f(CR]\fP

.TP
o 
\fBorder\fP : positive integer specifying the difference order. Default value is \fIorder\fP = 1.
.RE

.SH Output parameters


.RS

.TP
o 
\fBy\fP : real valued vector or matrix \f(CR[\fPrx-order,cx\f(CR]\fP 
y = x(order+1:rx,:) - x(1:rx-order,:) ;
.RE

.SH See also:
.SH Example:
\fI Matrix synthesis: \fP 
.sp
.ft CR
.nf
N = 100 ;
t = 0:N-1 ;
x = sin(2*%pi*0.05*t) ; 
.fi 
.ec
.ft P
.sp
\fI approximate 1-st order derivative\fP 
.sp
.ft CR
.nf
y = mtlb_diff(x) ;
plot2d([t(:) t(:)] , [x(:) [y(:);0]]) ;
.fi 
.ec
.ft P
.sp
