.TH "reynitq" 2 "March 12, 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
reynitq - Reyni exponents estimation
.sp
Author: Christophe Canus
.sp
This routine estimates the Reyni exponents on a partition function.
.sp
.sp
.SH Usage
\f(CR[\fPtq,\f(CR[\fPDq\f(CR]\fP\f(CR]\fP=reynitq(znq,n,q)
.SH Input parameters


.RS

.TP
o 
\fBznq\fP : strictly positive real matrix 
Contains the partition function. 

.TP
o 
\fBn\fP : strictly positive real (integer) vector 
Contains the resolutions.

.TP
o 
\fBq\fP : strictly positive real vector 
Contains the exponents.
.RE

.SH Output parameters


.RS

.TP
o 
\fBtq\fP : real vector \f(CR[\fP1,size(q)\f(CR]\fP
Contains the discrete Legendre Spectrum.

.TP
o 
\fBDq\fP : real vector \f(CR[\fP1,size(q)\f(CR]\fP
Contains the generalized dimensions.
.RE

.SH Description
.SH Parameters 
 
The mass exponents \fItq\fP and the generalized dimensions \fIDq\fP (if
used) are computed on the partition function \fIznq\fP.
The input real matrix \fIznq\fP must be of height size(\fIq\fP) and of
width size(\fIn\fP).
 
The output real vectors \fItq\fP and \fIDq\fP (if used) are of size
size(\fIq\fP).
.SH Algorithm details 
 
The mass exponent function \fItq\fP by least mean square
linear-fit. 
.SH See also
\fBmdzq1d,mdzq2d,linearlt,mdfl1d,mdfl2d\fP.
