.TH genfac3d 2 "October 1995" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
genfac3d - convert 3d datas to four sided facets
.SH CALLING SEQUENCE
.nf
[xx,yy,zz]=genfac3d(x,y,zmat [,mask])
.fi
.SH PARAMETERS
.TP 15
zmat      
: a \fV(mxn)\fR matrix.
.TP
x 
:x axis coordinates vector ( size \fVm\fR )
.TP
y 
:y axis coordinates vector ( size \fVn\fR )
.TP
mask     
: boolean optional matrix with same size as zmat used to select 
entries of zmat to be represented by facets.
.TP
xx,yy,zz 
: Three \fV4x(n-1xm-1)\fR  matrices. \fVxx(:,i),yy(:,i),zz(:,i)\fR are respectively the 
 x-axis,y-axis and z-axis coordinates of the ith facet
.SH DESCRIPTION
Converts 3d data ( two vectors \fVx,y\fR and a matrix \fVz\fR which
code the  surface \fVz(i,j)=f(x(i),y(j))\fR ) to a four sided facets representation.
.SH EXAMPLE
.nf
t = linspace(0,2*%pi,10);
zmat=sin(t')*cos(t);
plot3d(t,t,zmat)
[xx,yy,zz]=genfac3d(t,t,zmat);
plot3d(xx,yy,zz)
plot3d([xx xx],[yy yy],[zz 4+zz])
.fi
.SH SEE ALSO
plot3d, eval3dp
