.TH show_arcs 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
show_arcs - highlights a set of arcs
.SH CALLING SEQUENCE
.nf
show_arcs(p,[sup])
.fi
.SH PARAMETERS
.TP 2
p
: row vector of arc numbers (directed graph) or edge numbers (undirected graph)
.TP 4
sup
: string, superposition flag
.SH DESCRIPTION
\fVshow_arcs\fR highlights the set of arcs or edges \fVp\fR of the
displayed graph in the current Metanet window.
If the optional argument \fVsup\fR is equal to the string 'sup',
the highlighting is superposed on the previous one.

By default, this function works in asynchronous mode (see \fVmetanet_sync\fR).
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
show_graph(g);
t=min_weight_tree(1,g); g1=g; ma=edge_number(g1);
edgecolor=1*ones(1,ma); g1('edge_color')=edgecolor;
edgewidth=1*ones(1,ma); edgewidth(t)=4*ones(t); g1('edge_width')=edgewidth;
for i=8:12,
 edgecolor(t)=i*ones(t); g1('edge_color')=edgecolor;
 unix('sleep 2'); show_graph(g1);
 show_arcs(t);
end;
.fi
.SH SEE ALSO
metanet_sync, show_nodes
