.TH intg G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
intg - definite integral
.SH CALLING SEQUENCE
.nf
[v,err]=intg(a,b,f [,ea [,er])
.fi
.SH PARAMETERS
.TP 10
a,b 
: real numbers
.TP
f
: external (function or list or string)
.TP
ea, er 
: real numbers
.TP 10
ea 
: absolute error required on the result. Default value: 0
.TP
er 
: relative error required on the result. Default value: 1.d-8
.TP
err 
: estimated absolute error on the result.
.SH DESCRIPTION
\fVintg(a,b,f)\fR evaluates the definite integral  from \fVa\fR to
\fVb\fR of \fVf(t)dt\fR.
The evaluation hopefully satisfies following claim for accuracy:
\fVabs(I-v)<= max(ea,er*abs(I))\fR where I stands for the
exact value of the integral.

\fVf\fR is an external :
.LP
If \fVf\fR is function its definition must be as follows
\fV y = f(t) \fR
.LP
If \fVf\fR is a list the list must be as follows:
\fV list(f,x1,x2,...)\fR where \fVf\fR is a function with calling
sequence \fVf(t,x1,x2,...)\fR.
.LP
If \fVf\fR is a string it refers to a the name
of a Fortran subroutine (see source code of \fVfintg.f\fR)
.SH EXAMPLE
.nf
deff('[y]=f(x)','y=x*sin(30*x)/sqrt(1-((x/(2*%pi))^2))')
exact=-2.5432596188;
abs(exact-intg(0,2*%pi,f))
// See file routines/default/Ex-intg.f 
abs(exact-intg(0,2*%pi,'intgex'))
.fi
.SH SEE ALSO
intc, intl


