.TH "TK_GetVar" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
TK_GetVar - Get a tcl/tk variable value
.sp
Author: Bertrand Guiheneuf
.sp
This routine allows to get a tcl/tk variable value. 
.sp
.sp
.SH Usage
valueTK_SetVar(varname)
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBvarname\fP : string character
Contains the name of the tcl/tk variable.
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBvalue\fP : string character
Contains the value of the tcl/tk variable 'varname'.
.if \n(ll>1 .RE
.nr ll -1
.SH Description
When tcl/tk support is enabled in scilab, this routine can be used to retreive
the value of a tcl/tk variable. 
.SH EXAMPLE
.nf
TK_EvalStr('toplevel .foo');
// creates a toplevel TK window. 
TK_EvalStr('entry .foo.e -textvariable tvar');
// create an editable entry
TK_EvalStr('set tvar foobar');
// set the entry value
TK_EvalStr('pack .foo.e');
// pack the entry widget. It appears on the screen.
text=TK_GetVar('tvar')
// retrieve the variable value
// change the entry text and repeat the last command ...
.fi 
.ec
.ft P
.sp
.SH See also
ScilabEval, TK_EvalFile, TK_EvalStr, TK_SetVar
