.TH "uimenu" 2 " 05 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
uimenu - Create a menu or a submenu in a figure
.sp
Author: Bertrand Guiheneuf
.sp
This routine allows to add a menu or a submenu to the menu bar of
a figure
.sp
.sp
.SH Usage
h=uimenu(parent,prop1, val1, prop2, valu2 ...) 
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBparent\fP : integer
Handle of menu's parent 
.nr bi 1
.TP
o 
\fBprop?\fP : string character
name of a propoerty to set up
.nr bi 1
.TP
o 
\fBval??\fP : scilab object
value to affect to the corresponding property
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBh\fP : integer
handle of the corresponding menu
.if \n(ll>1 .RE
.nr ll -1
.SH Description
This allows to create menus in a figure. If 'parent' is a figure, then
the menu item will be added to the menu bar of the figure.
If 'parent' is a menu item , then the new  item will be added to the parent
item, allowing to create cascaded submenu.
The 'callback' property allows to set up the scilab instruction to call
when the item is selected by the user.
The 'label' property allows to set up the text appearing for the item.
.SH EXAMPLE
.nf
f=figure('position', [10 10 300 200]);
// create a figure
m=uimenu(f,'label', 'windows');
// create an item on the menu bar
m1=uimenu(m,'label', 'operations');
m2=uimenu(m,'label', 'quit scilab', 'callback', "exit");
//create two items in the menu "windows"
m11=uimenu(m1,'label', 'new window', 'callback',"xselect()");
m12=uimenu(m1,'label', 'clear  window', 'callback',"xbasc()");
// create a submenu to the item "operations"
close(f);
// close the figure
.fi 
.ec
.ft P
.sp
.SH See also
figure, uicontrol, set, get
