/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1997 AT&T                           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

int
find_selected_cols(xg, cols)
  xgobidata *xg;
  int *cols;
{
  int i, ncols = 0;

  if (xg->is_dotplotting) {
    cols[ncols++] = xg->dotplot_vars.y;
  }
  else if (xg->is_xyplotting) {
    cols[ncols++] = xg->xy_vars.x;
    cols[ncols++] = xg->xy_vars.y;
  }
  else if (xg->is_spinning) {
    cols[ncols++] = xg->spin_vars.x;
    cols[ncols++] = xg->spin_vars.y;
    cols[ncols++] = xg->spin_vars.z;
  }
  else if (xg->is_touring) {
    for (i=0; i<xg->numvars_t; i++)
      cols[ncols++] = xg->tour_vars[i];
  }
  else if (xg->is_corr_touring) {
    for (i=0; i<xg->ncorr_xvars; i++)
      cols[ncols++] = xg->corr_xvars[i];
    for (i=0; i<xg->ncorr_yvars; i++)
      cols[ncols++] = xg->corr_yvars[i];
  }
  return(ncols);
}

void
add_vgroups(xg, cols, ncols)
/*
 * If one of the chosen columns is in a vgroup,
 * add its comrades (unless they're already present)
*/
  xgobidata *xg;
  int *cols;
  int *ncols;
{
  int nc = *ncols;
  int j, k, n;

  for (j=0; j<nc; j++) {
    int vg = xg->vgroup_ids[cols[j]];

    for (k=0; k<xg->ncols_used; k++) {
      if (xg->vgroup_ids[k] == vg && k != cols[j]) {
        /* Got one; if it isn't already in cols, add it */
        Boolean addit = True;
        for (n=0; n<nc; n++) {
          if (cols[n] == k) {
            addit = False;
            break;
          }
        }
        if (addit) cols[(*ncols)++] = k;
        if (*ncols >= xg->ncols_used)
          break;
      }
    }
  }
}
