#!/bin/sh

#
# Change to suit your site
#
HOST=newsfeed.ecrc.net
LOGDIR=/var/adm/news
BINDIR=/usr/local/bin
WWWDIR=/usr/local/apache/newsfeed.ecrc.net/pub/newsfeed.ecrc.net
NUMDAYS=30
FIND=find
CD=cd
RM=rm
LN=ln

#
# Anything below here does NOT need changing!
#
DATE=`date +%y%m%d`
#DATE="970815"
#DATE=$1
LOGFILE=$LOGDIR/news.notice
WWWFILE=$WWWDIR/$DATE.html
WWWCURR=current.html

if [ ! -d $WWWDIR ]; then
	mkdir -p $WWWDIR
fi

date
echo "Running diablo-stats.pl ..."
$CD $WWWDIR
$BINDIR/diablo-stats.pl -v -d $DATE -D $NUMDAYS -s $HOST -l $LOGFILE -o $WWWFILE -w $WWWDIR
$FIND $WWWDIR -type f -mtime +90 | xargs $RM -f 
$RM -f $WWWCURR
$LN -s $DATE.html $WWWCURR

date
echo ""

exit 1

