
/*
 * DREADERD/SUBS.C
 *
 *	Misc subroutines.
 *
 * (c)Copyright 1998, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 */

#include "defs.h"

Prototype char *parseword(char **pptr, char *toks);
Prototype void SetCurrentGroup(Connection *conn, const char *group);
Prototype int shash(const char *s);
Prototype void SanitizeString(char *name);
Prototype int ValidGroupName(char *name);

char *
parseword(char **pptr, char *toks)
{
    char *base = *pptr;
    int i;

    for (i = 0; base[i] && strchr(toks, base[i]) == NULL; ++i)
	;
    if (base[i]) {
	int j;

	base[i] = 0;
	for (j = i + 1; base[j] && strchr(toks, base[j]) != NULL; ++j)
	    ;
	*pptr = base + j;
    } else {
	*pptr = base + i;
	if (i == 0)
	    base = NULL;
    }
    return(base);
}

void
SetCurrentGroup(Connection *conn, const char *group)
{
    zfreeStr(&conn->co_MemPool, &conn->co_GroupName);
    conn->co_GroupName = zallocStr(&conn->co_MemPool, group);
}

int
shash(const char *s)
{
    int hv = 0xAFC32344;

    while (*s) {
	hv = (hv << 5) ^ *s ^ (hv >> 23);
	++s;
    }
    return(hv ^ (hv >> 16));
}

void
SanitizeString(char *name)
{
    for (; *name; ++name) {
	if (*name >= 'a' && *name <= 'z')
	    continue;
	if (*name >= 'A' && *name <= 'Z')
	    continue;
	if (*name >= '0' && *name <= '9')
	    continue;
	if (*name == '\t')
	    *name = ' ';
	if (*name == '@' ||
	    *name == '-' ||
	    *name == '+' ||
	    *name == '_' ||
	    *name == '.' ||
	    *name == ',' ||
	    *name == ' '
	) {
	    continue;
	}
	*name = '?';
    }
}

int 
ValidGroupName(char *name)
{
    int r = 0;

    if (name[0] == 0 || name[0] == '.') {
	r = -1;
    } else {
	for (; *name; ++name) {
	    if (*name >= 'a' && *name <= 'z')
		continue;
	    if (*name >= 'A' && *name <= 'Z')
		continue;
	    if (*name >= '0' && *name <= '9')
		continue;
	    if (*name == '+')
		continue;
	    if (*name == '-')
		continue;
	    if (*name == '.') {
		if (name[-1] == '.' || name[1] == '.' || name[1] == 0)
		    r = -1;
	    }
	}
    }
    return(r);
}


