
/*
 * LIB/CONFIG.H
 *
 *
 * USE_BSTRING	- define if <bstring.h> must be included to get bcopy() and
 *		  related prototypes.
 *
 *
 * NOTE REGARDING USE_SMALL_HASH .. If you wish to set this to continue to
 * use small 1 million entry hash tables, set it in lib/vendor.h.  As of
 * Diablo V1.10, the default dhistory hash table size will be 4 million
 * entries.
 *
 * NOTE REGARDING CHANGING FEATURES:  Change these features in LIB/VENDOR.H,
 * do *NOT* change these features here unless you are editing this file for
 * submission back to me.  When adding special features as defaults, the 
 * operating system version must be explicitly tested.
 *
 * General notes:
 *
 *	IRIX 6.2 or greater, FreeBSD 2.2 or greater, and Sun/Solaris should
 *	be able to handle most mmap/shm features, but they have only been tested
 *	on FreeBSD.  Due to the way the code uses READ+WRITE maps, msync() 
 *	is irrelevant so you don't have to worry about that.
 *
 *	All versions of BSDI including 3.0 are known to have serious mmap
 *	problems even for read-only maps and Diablo may crash the kernel.
 *
 * Special Features:
 *
 *	USE_PCOMMIT_RW_MAP	if mmap() supports shared r+w mmaps, this
 *				causes diablo to update the precommit cache
 *			   	directly rather then with an lseek/write,
 *				which can reduce filesystem contention.
 *
 *	USE_PCOMMIT_SHM		Diablo will use SYSV shared memory for the
 *				precommit cache.  USE_PCOMMIT_RW_MAP is also
 *				required if you set this option (but it will
 *				use SYSV shared memory rather then mmap())
 *
 *	USE_SPAM_RW_MAP		if mmap() supports shared r+w mmaps, this
 *				causes diablo to update the spam cache
 *			   	directly rather then with an lseek/write,
 *				which can reduce filesystem contention.
 *
 *	USE_SPAM_SHM		Diablo will use SYSV shared memory for the
 *				spam cache.  USE_SPAM_RW_MAP is also required
 *				if you set this option (but it will use
 *				SYSV shared memory rather then mmap()).
 *
 *	DO_PCOMMIT_POSTCACHE	use the precommit cache as a recent-history
 *				cache.  Suggested only if USE_PCOMMIT_RW_MAP
 *				or USE_PCOMMIT_SHM are set.
 *
 *	USE_KP_RW_MAP		Use a read+write mmap for key-pair database
 *				operations.
 *
 *	USE_ANON_MMAP		lib/alloc.c uses MAP_ANON mmap's to allocate 
 *				private memory.
 *
 *	USE_ZERO_MMAP		lib/alloc.c uses MAP_PRIVATE on /dev/zero to
 *				allocate private memory.
 *
 *	USE_FALL_MMAP		lib/alloc.c uses MAP_PRIVATE mmaps on a
 *				temporary file to allocate private memory.
 *				(note: the memory winds up being swap-backed
 *				just like MAP_ANON).
 *
 *				If neither option is set, memory is allocated
 *				with malloc()/free() but this is not 
 *				recommended if you run more then 10 feeds.
 */

/*
 * Edit here
 *
 *
 * FreeBSD-3.0 or greater has depreciated sys/dir.h.  Since all FreeBSD 
 * versions support dirent.h we just use it.
 */

#ifdef __FreeBSD__
#if __FreeBSD__ >= 2
#include <osreldate.h>
#if __FreeBSD_version >= 222001
#define USE_SYSV_DIR		1	/* use more portable dirent.h (1)*/
#define USE_PCOMMIT_SHM		1	/* use sharedmem r/w map vs file map */
#define USE_PCOMMIT_RW_MAP	1	/* use r/w map for pcommit cache */
#define USE_SPAM_SHM		1	/* use sharedmem r/w map vs file map */
#define USE_SPAM_RW_MAP		1	/* use r/w map for spam cache	 */
#define USE_KP_RW_MAP		1	/* use r/w map for KPDB		 */
#define USE_ANON_MMAP		1	/* use anonymous mmap for alloc  */
#define DO_PCOMMIT_POSTCACHE	1	/* do precommit post caching	 */
#define HAS_UTIMES		1	/* human readability only	 */
#define HAS_USLEEP		1	/* < 1 second sleeps		 */
#define HAS_PROC_TITLE		1
#endif
#endif
#endif

#ifdef __bsdi__
#include <sys/param.h>
#if _BSDI_VERSION >= 199701
#define USE_KP_RW_MAP		1	/* use r/w map for KPDB		 */
#define USE_SPAM_SHM            1
#define USE_SPAM_RW_MAP         1
#define USE_PCOMMIT_SHM         1
#define USE_PCOMMIT_RW_MAP      1
#define DO_PCOMMIT_POSTCACHE    1
#define USE_FALL_MMAP           1
#else
#error "Upgrade to BSDI3.0 and the first jumbo patch.  mmap is broken on earlier releases"
#endif  /* _BSDI_VERSION >= 199701 */
#endif  /* __bsdi__ */

#ifdef sgi

#define FDPASS_USES_CMSG	0	/* SGI's fd passing is simplistic*/
#define USE_PCOMMIT_SHM		1	/* precommit cache in sysv shared mem*/
#define DO_PCOMMIT_POSTCACHE	1	/* do precommit post caching	 */
#define USE_BSTRING_H		1
#define USE_SYSV_SETPGRP	1
#define USE_SYSV_STATFS		1
#define HAVE_SNPRINTF		0

#define USE_ANON_MMAP		0
#define USE_FALL_MMAP		1

#endif

#ifdef sun

/*
 * NOTE: set SUNOS in the master XMakefile.inc if you are running sunos.
 */

#ifdef SUNOS

/*
 * sunos
 */

#undef  USE_SYSV_SETPGRP
#undef  USE_SYSV_STATFS
#define USE_SYSV_SIGNALS        0

#define USE_SYSV_DIR            1
#define USE_SYS_VFS         	1
#define HAVE_SNPRINTF           0
#define NEED_TERMIOS            1       /* for TIOCNOTTY */
#define USE_ANON_MMAP           0
#define USE_FALL_MMAP           1
#define USE_STRERROR            1
#define USE_MEMMOVE             1

#else

/*
 * solaris
 */

#define USE_PCOMMIT_SHM		1	/* precommit cache in sysv shmem */
#define DO_PCOMMIT_POSTCACHE	1	/* do precommit post caching	 */
#define USE_SYSV_DIR		1
#define USE_SYSV_SETPGRP	1
/*#define USE_SYSV_STATFS		1 */
#define USE_SUN_STATVFS		1
#define USE_SYSV_SIGNALS	1
#define HAVE_SNPRINTF		0
#define NEED_TERMIOS		1	/* for TIOCNOTTY */

#define USE_ANON_MMAP		0
#define USE_FALL_MMAP		1

#endif
#endif

#ifdef __linux__

#define USE_SYSV_SETPGRP	1
#define USE_SYS_VFS		1
#define USE_PCOMMIT_SHM		1	/* use sharedmem r/w map vs file map */
#define USE_PCOMMIT_RW_MAP	1	/* use r/w map for pcommit cache */
#define USE_SPAM_SHM		1	/* use sharedmem r/w map vs file map */
#define USE_SPAM_RW_MAP		1	/* use r/w map for spam cache   */
#define USE_KP_RW_MAP		1	/* use r/w map for KPDB		 */
#define DO_PCOMMIT_POSTCACHE	1	/* do precommit post caching    */
#define USE_ANON_MMAP		1
#define USE_FALL_MMAP		0
#define HAVE_SNPRINTF		1

#endif

/* AIX notes: snprintf() exists in 4.2 and later. */

#ifdef _AIX
#define USE_BSTRING_H           0
#define USE_SYSV_DIR		1
#define USE_SYSV_SETPGRP        1
#define USE_SYSV_STATFS         1
#define USE_SYSV_SIGNALS        1
#define HAVE_SNPRINTF           0
#define USE_ANON_MMAP           1
#define USE_FALL_MMAP           0
#endif

/************************************************************************
 *		CLEANUP - set defaults for unspecified options		*
 *			(DO NOT EDIT BELOW THIS LINE)			*
 ************************************************************************/

#ifndef USE_BSTRING_H
#define USE_BSTRING_H		0
#endif
#ifndef USE_SYSV_DIR
#define USE_SYSV_DIR		0
#endif
#ifndef USE_SYSV_SIGNALS
#define USE_SYSV_SIGNALS	0
#endif
#ifndef USE_SYSV_SETPGRP
#define USE_SYSV_SETPGRP	0
#endif
#ifndef USE_SYSV_STATFS
#define USE_SYSV_STATFS		0
#endif
#ifndef USE_SYS_VFS
#define USE_SYS_VFS		0
#endif
#ifndef HAVE_SNPRINTF
#define HAVE_SNPRINTF		1
#endif
#ifndef USE_ANON_MMAP
#define USE_ANON_MMAP		0
#endif
#ifndef USE_FALL_MMAP
#define USE_FALL_MMAP		1
#endif
#ifndef USE_ZERO_MMAP
#define USE_ZERO_MMAP		0
#endif
#ifndef USE_STRERROR
#define USE_STRERROR		0
#endif
#ifndef USE_MEMMOVE
#define USE_MEMMOVE		0
#endif
#ifndef USE_SMALL_HASH
#define USE_SMALL_HASH		0
#endif
#ifndef USE_LARGE_HASH
#define USE_LARGE_HASH		0
#endif
#ifndef USE_REALLY_LARGE_HASH
#define USE_REALLY_LARGE_HASH	0
#endif
#ifndef USE_SHORT_REMEMBER
#define USE_SHORT_REMEMBER	0
#endif
#ifndef NEED_TERMIOS
#define NEED_TERMIOS		0
#endif
#ifndef USE_PCOMMIT_RW_MAP
#define USE_PCOMMIT_RW_MAP	0
#endif
#ifndef USE_PCOMMIT_SHM
#define USE_PCOMMIT_SHM		0
#endif
#ifndef USE_SPAM_RW_MAP
#define USE_SPAM_RW_MAP		0
#endif
#ifndef USE_KP_RW_MAP
#define USE_KP_RW_MAP		0
#endif
#ifndef HAS_PROC_TITLE
#define HAS_PROC_TITLE		0
#endif
#ifndef USE_SPAM_SHM
#define USE_SPAM_SHM		1	/* required for lib/seq.c */
#endif
#ifndef DO_PCOMMIT_POSTCACHE
#define DO_PCOMMIT_POSTCACHE	0
#endif
/*
 * use the cmsghdr structure for descriptor passing by default.  If this
 * structure doesn't exist, a compilation error will occur which is better
 * then fucking up the descriptor passing.
 */
#ifndef FDPASS_USES_CMSG
#define FDPASS_USES_CMSG	1
#endif
#ifndef ACCEPT_ARG3_TYPE
#define ACCEPT_ARG3_TYPE	int
#endif
#ifndef HAS_UTIMES
#define HAS_UTIMES		0
#endif
#ifndef HAS_USLEEP
#define HAS_USLEEP		0
#endif

#include <lib/vendor.h>

/*
 * location of pgpverify
 */

#ifndef PGP_VERIFY_PATH
#define PGP_VERIFY_PATH		"/news/dbin/pgpverify"
#endif
#ifndef PGP_VERIFY_ARG0
#define PGP_VERIFY_ARG0		"pgpverify"
#endif
#ifndef PGP_PATH
#define PGP_PATH		"/usr/local/bin/pgp"
#endif
#ifndef PGP_ARG0
#define PGP_ARG0		"pgp"
#endif
#ifndef SENDMAIL_PATH
#define SENDMAIL_PATH		"/usr/sbin/sendmail"
#endif
#ifndef SENDMAIL_ARG0
#define SENDMAIL_ARG0		"sendmail"
#endif
#ifndef NEWSMASTER
#define NEWSMASTER		"usenet"
#endif

/*
 * force r+w maps if sysv shared memory is used
 * for the caches.
 */

#if USE_SPAM_SHM
#undef USE_SPAM_RW_MAP
#define USE_SPAM_RW_MAP		1
#endif

#if USE_PCOMMIT_SHM
#undef USE_PCOMMIT_RW_MAP
#define USE_PCOMMIT_RW_MAP	1
#endif

/* #define USE_INTERNAL_SNPRINTF 1 */


