//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGE3F_HXX
#define CARTRIDGE3F_HXX

class Cartridge3F;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 8K cartridge class for Tigervision games.  There are four
  2K banks while two 2K segments are visible to the 2600.  The
  last 2K bank is always mapped into the second segment.  Banks
  can be switched by preforming an STA $3F instruction with the
  bank number in the lower two bits of the acuumulator.
  
  @author  Bradford W. Mott
  @version $Id: Cart3F.hxx,v 1.1 1997/05/17 19:04:12 bwmott Exp $
*/
class Cartridge3F : public Cartridge
{
  public:
    /// Constructor
    Cartridge3F(System& system, uByte* image);
 
    /// Destructor
    virtual ~Cartridge3F();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

    /// Reset to power on state
    virtual void reset();
 
  private:
    // Addressing offsets in ROM image
    uWord myImageOffset[2];

    // 8k ROM Image of the cartridge
    uByte myImage[8192];
};
#endif

