//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef CARTRIDGEFASC_HXX
#define CARTRIDGEFASC_HXX

class CartridgeFASC;

#include "machine.hxx"
#include "Cart.hxx"

/**
  The 12K cartridge class used by CBS' RAM Plus cartridges. There
  are 3 4K banks and 256-bytes of RAM.

  @author  Bradford W. Mott
  @version $Id: CartFASC.hxx,v 1.2 1997/05/17 19:00:04 bwmott Exp $
*/
class CartridgeFASC : public Cartridge
{
  public:
    /// Constructor
    CartridgeFASC(System& system, uByte* image);
 
    /// Destructor
    virtual ~CartridgeFASC();

  public:
    /// Reset to power on state
    void reset();

    /// Answer the byte at the given address
    virtual uByte peek(uWord addr);

    /// Store value in the given address
    virtual void poke(uWord addr, uByte value);

  private:
    // Addressing offset in ROM image
    uWord myImageOffset;

    // Addressing offset in RAM (always zero)
    uWord myRAMOffset;

    // 16K ROM Image of the cartridge
    uByte myImage[12288];

    // 256 bytes of RAM
    uByte myRAM[256]; 
};
#endif

