//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef DEVICE_HXX
#define DEVICE_HXX

class System;

#include "machine.hxx"

/**
  Abstract base class used for devices that are attached to the System
  in the "core" code.

  @author  Bradford W. Mott
  @version $Id: Device.hxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/
class Device
{
  public:
    /// Constructor
    Device(System& system);

    /// Destructor
    virtual ~Device();

  public:
    /// Answer the byte at the given address
    virtual uByte peek(uWord address) = 0;

    /// Change the byte at the given address to the given value
    virtual void poke(uWord address, uByte value) = 0;

  protected:
    /// Reference to the system I'm mapped to
    System& mySystem;
};
#endif

