//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef M6507HIGH_HXX
#define M6507HIGH_HXX

#include <fstream.h>

class M6507High;

#include "machine.hxx"
#include "System.hxx"
#include "M6507.hxx"

extern bool PokePossible;
extern uWord LastOperandAddress;
extern uWord LastOperandOffset;
extern uLong LastOperandCycle;

/**
  This class emulates a 6507 microprocessor.  The memory accesses
  and cycle counts it generates are valid at the sub-instruction
  level and "false" reads are generated (such as the ones produced
  by the Indirect,X addressing when it crosses a page boundary).
  This provides better compatibility for hardware that has side
  effects and for games which are very time sensitive.

  NOTE: The description given above is what this class "should"
  be, however, currently it's just like M6507Low except it keeps 
  information about the last operand fetched for Supercharger support.
 
  @author  Bradford W. Mott
  @version $Id: M6507Hi.hxx,v 1.1 1997/05/17 19:04:13 bwmott Exp $
*/
class M6507High : public M6507
{
  public:
    /// Constructor
    M6507High(System& system);

    /// Destructor
    virtual ~M6507High();

  public:
    /**
      Execute instructions until at least the given number of 
      cycles have passed or execution is halted by someone
    */
    virtual void execute(uLong numberOfCycles);

  private:
    // Answer the uByte at the given address (only lower 8-bits used)
    uWord peek(uWord addr);

    // Answer the uByte at the given address that should be part of
    // an instruction we're trying to execute
    uWord iPeek(uWord addr);

    // Answer the uWord at the given address that should be part of
    // an instruction we're trying to execute
    uWord iDPeek(uWord addr);

    // Write value at the given address.
    void poke(uWord addr, uByte value);
};
#endif

