//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef PROPERTIES_HXX
#define PROPERTIES_HXX

#include "machine.hxx"

/**
  Maintains a collection of property names and values.  Upon
  construction the property object contains some reasonable default
  values for most properties as well as "Cartridge.Image" set to 
  the name of the ROM image and "Cartridge.Id" set to the 
  cartridge's computed identification.

  @author  Bradford W. Mott
  @version $Id: Props.hxx,v 1.2 1997/05/17 19:00:07 bwmott Exp $
*/
class Properties
{
  public:
    /// Construct a property object for the specified ROM image file
    Properties(const char* filename);
 
    /// Destructor
    virtual ~Properties();

  public: 
    /// Answer the value of the property
    const char* find(const char* property) const;

    /// Answer the integer value of the property
    int integer(const char* property) const;

  public:
    /// Answer the value assigned to property
    const char* get(const char* property) const;

    /// Set the value of property to the specified value
    void set(const char* property, const char* value);

  private:
    // Make sure the values assigned to properties are reasonable
    void validate();

    // Autodetect the properties from the given BIN file
    void autodetect(const char* filename);

    // Calculate the Cartridge Id associated with the ROM Image
   void calculateId(const char* file, char* id);

    // Determine the cartridge's type
    const char* cartridgeType(const char* filename, const char* id);

  private:
    struct Property 
    {
      char* keyword;
      char* value;
    };

    // Array of properties
    Property* myProperties;

    // Size of the properties array 
    unsigned int mySize;

    // Number of properties being held
    unsigned int myNumberOfProperties;
};
#endif

