//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef SOUND_HXX
#define SOUND_HXX

#include "machine.hxx"

/**
  Base class that defines the standard API for sound classes.  You
  should derive a new class from this one to create a new sound system.

  @author  Bradford W. Mott
  @version $Id: Snd.hxx,v 1.2 1997/05/17 19:00:07 bwmott Exp $
*/
class Sound
{
  public:
    enum Register { AUDF0, AUDF1, AUDC0, AUDC1, AUDV0, AUDV1 };

  public:
    /**
      Class methods which answers the "best" sound object 
      for the system we're running on
    */
    static Sound* create();

  public:
    /// Constructor
    Sound();
 
    /// Destructor
    virtual ~Sound();

  public: 
    /// Set the given sound register to the specified value
    virtual void set(Sound::Register reg, uByte value);
};
#endif

