//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef MACHINE_HXX
#define MACHINE_HXX

/**
  Various basic types used throughout the program.

  @author Bradford W. Mott
  @version $Id: machine.hxx,v 1.2 1997/05/17 19:00:09 bwmott Exp $
*/

// Bytes should be 8-bits wide
typedef signed char Byte;
typedef unsigned char uByte;

// Words should be 16-bits wide
typedef signed short Word;
typedef unsigned short uWord;

// Longs should be 32-bits wide
typedef int Long;
typedef unsigned int uLong;

// Obsolete (Moving to the types defined above)
typedef signed char byte;
typedef unsigned char ubyte;
typedef signed short word;
typedef unsigned short uword;

// Some compilers don't support the bool type yet :-(
#ifdef DEFINE_BOOL_TYPE
  typedef unsigned char bool;
  #define true  1
  #define false 0
#endif

// For compilers that have bad exception handling support
#ifdef EXCEPTION_FIX
  class Error;
  extern void ExceptionFix(Error& msg);
  extern Error msg;
  #define Throw(A) ExceptionFix(A)
  #define try
  #define throw
  #define catch(A) if(0)
#else
  #define Throw(A) throw A
#endif

// Used for file handling
#if defined UNIX_OS
  #define PATH_SEPARATOR  '/'
#elif (defined(MSDOS_OS) || defined(WIN32))
  #define PATH_SEPARATOR  '\\'
#elif defined MAC_OS
  #define PATH_SEPARATOR  ':'
#elif defined OS_2
  #define PATH_SEPARATOR  '\\'
#endif

#ifdef WIN32
  // Nonstandard extension used: bool, true, false
  #pragma message ("Machine.hxx is defining bool, true, and false")
  #pragma warning (disable:4237)
  typedef unsigned char bool;
  const int true = 1;
  const int false = 0;
#endif

#endif

