/**************************************************************/
/***********tableseg, tablexseg, voscili, vpvoc************/
/*** By Richard Karpen - July-October 1992************/
/************************************************************/
#include <math.h>
#include "cs.h"		
#include "dsputil.h"
#include "fft.h"
#include "pvoc.h"
#include "vpvoc.h"
#include "soundio.h"

static	TABLESEG	*tbladr;
extern	float	esr, ekr, sicvt, pi;

void tblesegset(TABLESEG *p)
{
    TSEG	*segp;
    int	nsegs;
    float	**argp, dur;
    FUNC *nxtfunc, *curfunc;
    long	flength;
    int i;

    tbladr=p;
    nsegs = (p->INCOUNT >> 1);	/* count segs & alloc if nec */

    if ((segp = (TSEG *) p->auxch.auxp) == NULL) {
	auxalloc((long)(nsegs+1)*sizeof(TSEG), &p->auxch);
	p->cursegp = segp = (TSEG *) p->auxch.auxp;
	(segp+nsegs)->cnt = MAXPOS; 
    } 
    argp = p->argums; 
    if ((nxtfunc = ftfind(*argp++)) == NULL)
        return;
    flength = nxtfunc->flen;
    p->outfunc = (FUNC *) mcalloc((long)sizeof(FUNC) + flength*sizeof(float));
    p->outfunc->flen = nxtfunc->flen;
    p->outfunc->lenmask = nxtfunc->lenmask;
    p->outfunc->lobits = nxtfunc->lobits;
    p->outfunc->lomask = nxtfunc->lomask;
    p->outfunc->lodiv = nxtfunc->lodiv;
    for (i=0; i<= flength; i++)
        *(p->outfunc->ftable + i) = 0.0f;
    if (**argp <= 0.0)  return;		/* if idur1 <= 0, skip init  */
    p->cursegp = segp;                      /* else proceed from 1st seg */
    segp--;
    do {
	segp++; 	 	/* init each seg ..  */
	curfunc = nxtfunc;
	dur = **argp++;
	if ((nxtfunc = ftfind(*argp++)) == NULL) return;
	if (dur > 0.0f) {
		segp->d = dur * ekr;
		segp->function =  curfunc;
		segp->nxtfunction = nxtfunc;
		segp->cnt = (long) (segp->d + .5); 
	}
	else break;		/*  .. til 0 dur or done */
    } while (--nsegs);
    segp++;
    segp->d = 0.0f;
    segp->cnt = MAXPOS;     	/* set last cntr to infin */
    segp->function =  nxtfunc;
    segp->nxtfunction = nxtfunc;
}

void ktableseg(TABLESEG *p)
{
    TSEG	*segp;
    float       *curtab, *nxttab,curval, nxtval, durovercnt=0.0f;
    int         i;
    long        flength, upcnt;

    /* RWD fix */
    if (p->auxch.auxp==NULL) {
      initerror("tableseg: not initialized");
      return;
    }
    segp = p->cursegp;
    curtab = segp->function->ftable;
    nxttab = segp->nxtfunction->ftable;
    upcnt = (long)segp->d-segp->cnt;
    if (upcnt > 0) 
      durovercnt = segp->d/upcnt;
    while (--segp->cnt < 0)
      p->cursegp = ++segp;
    flength = segp->function->flen;
    for (i=0; i<flength; i++) {
      curval = *(curtab + i);
      nxtval = *(nxttab + i);
      if (durovercnt > 0.0)
	*(p->outfunc->ftable + i) = (curval + ((nxtval - curval) / durovercnt));
      else
	*(p->outfunc->ftable + i) = curval;
    }
}

void ktablexseg(TABLESEG *p)
{
    TSEG	*segp;
    float       *curtab, *nxttab,curval, nxtval, cntoverdur=0.0f;
    int         i;
    long        flength, upcnt;

    /* RWD fix */
    if (p->auxch.auxp==NULL) {
      initerror("tablexseg: not initialized");
      return;
    }
    segp = p->cursegp;
    curtab = segp->function->ftable;
    nxttab = segp->nxtfunction->ftable;
    upcnt = (long)segp->d-segp->cnt;
    if (upcnt > 0) cntoverdur = upcnt/ segp->d;
    while(--segp->cnt < 0)
      p->cursegp = ++segp;
    flength = segp->function->flen;
    for (i=0; i<flength; i++) {
      curval = *(curtab + i);
      nxtval = *(nxttab + i);
      *(p->outfunc->ftable + i) =
	(curval + ((nxtval - curval) * (cntoverdur*cntoverdur)));
    }
}



void voscset(VOSC *p)
{
    p->tableseg = tbladr;
    if (*p->iphs >= 0)
      p->lphs = ((long)(*p->iphs * fmaxlen)) & PMASK;
}

void voscili(VOSC  *p)
{
    FUNC	*ftp;
    float	v1, fract, *ar, *ampp, *cpsp, *ftab;
    long	phs, lobits;
    int	        nsmps = ksmps;
    TABLESEG    *q = p->tableseg;

    /* RWD fix */
    if (q->auxch.auxp==NULL) {
      initerror("voscili: not initialized");
      return;
    }
    ftp = q->outfunc;
    ftab = ftp->ftable;
    lobits = ftp->lobits;
    phs = p->lphs;
    ampp = p->xamp;
    cpsp = p->xcps;
    ar = p->sr;

    do {
      long inc;
      inc = (long)(*cpsp++ * sicvt);
      fract = PFRAC(phs);
      ftab =ftp->ftable + (phs >> lobits);	 
      v1 = *ftab++;
      *ar++ = (v1 + (*ftab - v1) * fract) * *ampp;
      phs += inc;
      phs &= PMASK;
    }
    while (--nsmps);
    p->lphs = phs;
}


/************************************************************/
/*****************VPVOC**************************************/
/************************************************************/

#define WLN   1		/* time window is WLN*2*ksmps long */

/*  #define OPWLEN	size	*/
#define OPWLEN (2*WLN*ksmps)	/* manifest used for final time wdw */

extern	int	ksmps;
extern	char	errmsg[];
extern  int     odebug;

/* static	int	pdebug = 0; */
/* static	int	dchan = 6; */	/* which channel to examine on debug */

void vpvset(VPVOC *p)
{
    int      i;
    char     pvfilnam[64];
/*     float    *pvp; */
    MEMFIL   *mfp, *ldmemfile(char*);
    PVSTRUCT *pvh;
    int     frInc, chans, size;	/* THESE SHOULD BE SAVED IN PVOC STRUCT */

    p->tableseg = tbladr;

    if (p->auxch.auxp == NULL) {              /* if no buffers yet, alloc now */
        float *fltp;
        auxalloc((long)(PVDATASIZE + PVFFTSIZE*3 + PVWINLEN) * sizeof(float),
		 &p->auxch);
	fltp = (float *) p->auxch.auxp;
	p->lastPhase = fltp;   fltp += PVDATASIZE;    /* and insert addresses */
	p->fftBuf = fltp;      fltp += PVFFTSIZE;
	p->dsBuf = fltp;       fltp += PVFFTSIZE;
	p->outBuf = fltp;      fltp += PVFFTSIZE;
	p->window = fltp;
    }
    if (*p->ifilno == sstrcod)                         /* if strg name given */
        strcpy(pvfilnam, unquote(p->STRARG));          /*   use that         */
    else sprintf(pvfilnam,"pvoc.%d", (int)*p->ifilno); /* else pvoc.filnum   */
    if ((mfp = p->mfp) == NULL
      || strcmp(mfp->filename, pvfilnam) != 0) /* if file not already readin */
	if ( (mfp = ldmemfile(pvfilnam)) == NULL) {
	    sprintf(errmsg,"PVOC cannot load %s", pvfilnam);
	    goto pverr;
	}
    pvh = (PVSTRUCT *)mfp->beginp;
    if (pvh->magic != PVMAGIC) {
	sprintf(errmsg,"%s not a PVOC file (magic %ld)", 
		pvfilnam, pvh->magic );
	goto pverr;
    }
    p->frSiz = pvh->frameSize;
    frInc    = pvh->frameIncr;
    chans    = pvh->channels;
    if ((p->asr = pvh->samplingRate) != esr) { /* & chk the data */
	sprintf(errmsg,"%s''s srate = %8.0f, orch's srate = %8.0f",
		pvfilnam, p->asr, esr);
	warning(errmsg);
    }
    if (pvh->dataFormat != PVFLOAT) {
	sprintf(errmsg,"unsupported PVOC data format %ld in %s",
		pvh->dataFormat, pvfilnam);
	goto pverr;
    }
    if (p->frSiz > PVFRAMSIZE) {
	sprintf(errmsg,"PVOC frame %d bigger than %ld in %s",
		p->frSiz, PVFRAMSIZE, pvfilnam);
	goto pverr;
    }
    if (p->frSiz < PVFRAMSIZE/8) {
	sprintf(errmsg,"PVOC frame %ld seems too small in %s",
		p->frSiz, pvfilnam);
	goto pverr;
    }
    if (chans != 1) {
	sprintf(errmsg,"%d chans (not 1) in PVOC file %s",
	        chans, pvfilnam);
	goto pverr;
    }
    /* Check that pv->frSiz is a power of two too ? */
    p->frPtr = (float *) ((char *)pvh+pvh->headBsize);
    p->baseFr = 0;  /* point to first data frame */
    p->maxFr = -1 + ( pvh->dataBsize / (chans * (p->frSiz+2) * sizeof(float)));
    /* highest possible frame index */
    p->frPktim = ((float)ksmps)/((float)frInc);
    /* factor by which to mult expand phase diffs (ratio of samp spacings) */
    p->frPrtim = esr/((float)frInc);
    /* factor by which to mulitply 'real' time index to get frame index */
    size = pvfrsiz(p);		/* size used in def of OPWLEN ? */
/*  p->scale = 4.*((float)ksmps)/((float)pvfrsiz(p)*(float)pvfrsiz(p)); */
/*    p->scale = 2.*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));	*/
    p->scale = 32768.0f*2.0f*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));
    /* 2*incr/OPWLEN scales down for win ovlp, windo'd 1ce (but 2ce?) */
    /* 1/frSiz is the required scale down before (i)FFT */
    p->prFlg = 1;    /* true */
    p->opBpos = 0;
    p->lastPex = 1.0f;	    /* needs to know last pitchexp to update phase */
    /* Set up time window */
    for (i=0; i < pvdasiz(p); ++i) {  /* or maybe pvdasiz(p) */
     /* p->window[i] = (0.54-0.46*cos(2.0*pi*(float)i/(float)(pvfrsiz(p)))); */
	p->lastPhase[i] = 0.0f;
    }
    if ( (OPWLEN/2 + 1)>PVWINLEN ) {
	sprintf(errmsg, "ksmps of %d needs wdw of %d, max is %d for pv %s\n",
		ksmps, (OPWLEN/2 + 1), PVWINLEN, pvfilnam);
	goto pverr;
    }
    for (i=0; i < OPWLEN/2+1; ++i)    /* time window is OPWLEN long */
        p->window[i] = (0.54f-0.46f*(float)cos(2.0f*pi*(float)i/(float)OPWLEN));
    /* NB : HAMMING */
    for (i=0; i< pvfrsiz(p); ++i)
        p->outBuf[i] = 0.0f;
    MakeSinc( /* p->sncTab */ );  	/* sinctab is same for all instances */
    p->plut = (float *)AssignBasis(NULL, pvfrsiz(p));    /* SET UP NONET FFT */

    return;

pverr:	initerror(errmsg);
    }


void vpvoc(VPVOC *p)
{
    int    n;
/*     float  *samp; */
    float  *ar = p->rslt;
    float  frIndx;
    float  *buf = p->fftBuf;
    float  *buf2 = p->dsBuf;
    int	 asize = pvdasiz(p); /* fix */
    float  *plut = p->plut;
    int    size = pvfrsiz(p);
    int    buf2Size, outlen;
    int    circBufSize = PVFFTSIZE;
    int    specwp = (int)*p->ispecwp;   /* spectral warping flag */
    float  pex;
    TABLESEG *q = p->tableseg;
    long	 i,j ;

    /* RWD fix */
    if (p->auxch.auxp==NULL) {
      initerror("vpvoc: not initialized");
      return;
    }

/*     if (pdebug) { printf("<%7.4f>",*p->ktimpnt); fflush(stdout); } */
    pex = *p->kfmod;
    outlen = (int)(((float)size)/pex);
    /* use outlen to check window/krate/transpose combinations */
    if (outlen>PVFFTSIZE)  /* Maximum transposition down is one octave */
	{		    /* ..so we won't run into buf2Size problems */
	perferror("PVOC transpose too low");
	return;
	}
    if (outlen<2*ksmps)    /* minimum post-squeeze windowlength */
	{
	perferror("PVOC transpose too high");
	return;
	}
    buf2Size = OPWLEN;     /* always window to same length after DS */
    if ((frIndx = *p->ktimpnt * p->frPrtim) < 0)
	{
	perferror("PVOC timpnt < 0");
	return;
	}
    if (frIndx > (float)p->maxFr)  /* not past last one */
	{
	frIndx = (float)p->maxFr;
	if (p->prFlg)
	    {
	    p->prFlg = 0;   /* false */
	    warning("PVOC ktimpnt truncated to last frame");
	    }
	}
    FetchIn(p->frPtr,buf,size,frIndx);
/*    if (frIndx >= p->maxFr)
    	printf("Fetched %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f\n",
    	buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]);  */

/**** Apply "spectral envelope" to magnitudes ********/
	for (i=0, j=0; i<=size; i+=2, j++) 
		buf[i] *= *(q->outfunc->ftable + j);
/***************************************************/
    
    FrqToPhase(buf, asize, pex*(float)ksmps, p->asr,
	   /*a0.0*/(float)(.5 * ( (pex / p->lastPex) - 1) ));
    /* Offset the phase to align centres of stretched windows, not starts */
    RewrapPhase(buf,asize,p->lastPhase);
/**/    if ( specwp == 0 || (p->prFlg)++ == -(int)specwp) /* ?screws up when prFlg used */
        { /* specwp=0 => normal; specwp = -n => just nth frame */
	if (specwp<0) printf("PVOC debug : one frame gets through \n");	/*	*/
    if (specwp>0)
        PreWarpSpec(buf, asize, pex);    /*	    */
    Polar2Rect(buf,size);
/*    if (frIndx >= p->maxFr)
    	printf("Rected %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f\n",
	buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]); */
    buf[1] = 0.0f; buf[size+1] = 0.0f;	/* kill spurious imag at dc & fs/2 */
    FFT2torl((complex *)buf,size,1,/*a pex*/ p->scale, (complex *)plut);
    /* CALL TO NONET FFT */
    PackReals(buf, size);
/*    if (frIndx >= p->maxFr)
    	printf("IFFTed %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f %8.1f %6.1f\n",
	buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7]); */
/*a    ApplyHalfWin(buf, p->window, size);	*/
    if (pex != 1.0)
      UDSample(buf,(.5f*((float)size - pex*(float)buf2Size))/*a*/,
	       buf2, size, buf2Size, pex);
    else
      CopySamps(buf+(int)(.5f*((float)size - pex*(float)buf2Size))/*a*/,
		buf2,buf2Size);
/*a*/    if (specwp>=0) ApplyHalfWin(buf2, p->window, buf2Size);	/* */
/**/  }
      else
        for (n = 0; n<buf2Size; ++n)
          buf2[n] = 0.0f;		/*	*/
    addToCircBuf(buf2, p->outBuf, p->opBpos, ksmps, circBufSize);
    writeClrFromCircBuf(p->outBuf, ar, p->opBpos, ksmps, circBufSize);
    p->opBpos += ksmps;
    if (p->opBpos > circBufSize)     p->opBpos -= circBufSize;
    addToCircBuf(buf2+ksmps,p->outBuf,p->opBpos,buf2Size-ksmps,circBufSize);
    p->lastPex = pex;	     /* needs to know last pitchexp to update phase */
}

