 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                                                                      */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Mon June 30 1997                             */
 /* ------------------------------------------------------------------   */
 /* A functionless scheme visible C++ class for use as a skeleton.       */
 /*                                                                      */
 /************************************************************************/

#include "DummyObject.h"

EST_String SubtypedObject<DummyObject>::type_name(void) const {return "DummyObject";}

#if defined(INCLUDE_LISP)
int SubtypedObject<DummyObject>::s_lisp_type = tc_festival_dummyobject;
#endif

DummyObject::DummyObject(void)
{
}

DummyObject::~DummyObject(void)
{ }

EST_read_status DummyObject::fill_from(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_read_error;}
EST_write_status DummyObject::write_to(FILE *stream, int binary) 
{(void)stream; (void)binary; return misc_write_error;}

void DummyObject::set_filename(EST_String filename)
{(void)filename;}


void DummyObject::property_names(EST_TList<EST_String> &list) const
{
  SubtypedObject<DummyObject>::property_names(list);
}

ValueType DummyObject::property(EST_String property) const
{
  return SubtypedObject<DummyObject>::property(property);
}

int DummyObject::set_property(EST_String property, ValueType value)
{
  return SubtypedObject<DummyObject>::set_property(property, value);
}

#if defined(INCLUDE_LISP)

void DummyObject::lisp_declare(void)
{
  long gc_kind;
  set_gc_hooks(tc_festival_dummyobject,
	       1,
	       NULL,
	       SchemeObject::lisp_gc_mark,
	       NULL,
	       SchemeObject::lisp_gc_free,
	       SchemeObject::lisp_gc_clear_mark,
	       &gc_kind);
  set_print_hooks(tc_festival_dummyobject,
		  DummyObject::lisp_print,
		  DummyObject::lisp_print_string
		  );

  init_subr_2("make_dummyobject", DummyObject::lisp_make,
 "(make_dummyobject TYPE PROPERTIES)\n\
  Make an empty dummyobject of the given type and properties.");
}
#endif

#if defined(INSTANTIATE_TEMPLATES)
#include "SubtypedObject.cc"
template class SubtypedObject<DummyObject>;
#endif
