 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Wed Dec 17 1997                               */
 /* --------------------------------------------------------------------  */
 /* Simple textual catalogue in traditional CSTR format.                  */
 /*                                                                       */
 /*************************************************************************/

#include "EST_String.h"
#include "UnitAux.h"
#include "CstrRawUnitCatalogue.h"
#include "ctype.h"

const int CstrRawUnitCatalogue::s_line_length = 100;

static inline int irint(float f) { return (int)(f+0.5); }
static inline int irint(double f) { return (int)(f+0.5); }

CstrRawUnitCatalogue::CstrRawUnitCatalogue(void): p_entries(500) 
{
    p_num_entries=0; 
}

CstrRawUnitCatalogue::~CstrRawUnitCatalogue(void)
{
}

CstrRawUnitCatalogue::CstrRawItterator::~CstrRawItterator(void)
{ }

UnitName CstrRawUnitCatalogue::CstrRawItterator::next(void)
{ return (const char *)NULL; }

int CstrRawUnitCatalogue::CstrRawItterator::at_end(void) 
{ return 1; }

inline static const char *skip_ws(const char *p)
{
  while (*p != '\0' && isspace(*p))
    p++;
  return p;
}

bool CstrRawUnitCatalogue::recognise(FILE *stream)
{
  (void) stream;
  return TRUE;
}

UnitCatalogue *CstrRawUnitCatalogue::create(void)
{
  return new CstrRawUnitCatalogue();
}


inline static int min_i(int a, int b)
{
  return a<b?a:b;
}

EST_read_status CstrRawUnitCatalogue::fill_from(FILE *stream)
{
    int startp = ftell(stream);
    char buffer[s_line_length];
    int n=0;

    while (fgets(buffer, s_line_length, stream))
	n++;

    fseek(stream, startp, SEEK_SET);

    p_entries.clear();
    p_num_entries=n;

    while (fgets(buffer, s_line_length, stream))
    {
	Entry *entry = new Entry;
	const char *s, *e;
	int field=1, l;
      
	entry->n_segments=0;
      
	for(s=skip_ws(buffer); *s != '\0' && entry->n_segments 
	    <= RUC_MAX_SEGMENTS_PER_UNIT; s=skip_ws(e))
	{
	    e=s;
	    while (*e != '\0' && !isspace(*e))
		e++;
	    l = e-s;
	    int tl;
	    switch(field)
	    {
	    case 1:
		tl = min_i(l, RUC_NAME_LENGTH);
		strncpy(entry->name, s, tl);
		entry->name[tl] = '\0';
		break;
	    case 2:
		tl = min_i(l, RUC_FILENAME_LENGTH);
		strncpy(entry->filename, s, tl);
		entry->filename[tl] = '\0';
		break;
	    default:
		entry->segments[entry->n_segments] = strtod(s, NULL)/1000.0;
		entry->n_segments++;
		break;
	    }
	    field++;
	}

	p_entries.add_item(entry->name, entry);
	lookup(entry->name);
    }

    return format_ok;
}

EST_write_status CstrRawUnitCatalogue::write_to(FILE *stream)
{
    (void)stream;
    return misc_write_error;
}

UnitCatalogue::Itterator *CstrRawUnitCatalogue::itterator(void)
{
    return NULL;
}

struct RawUnitCatalogue::Entry *CstrRawUnitCatalogue::lookup(UnitName name)
{
   CstrRawUnitCatalogue::Entry *e = p_entries.val(name);

   return e;
}

int CstrRawUnitCatalogue::has_entry(UnitName name)
{
    return lookup(name) != NULL;
}


#if defined(INSTANTIATE_TEMPLATES)
#include "../base_class/EST_THash.cc"
template class EST_TStringHash<CstrRawUnitCatalogue::Entry *>;
template class EST_THash<EST_String,CstrRawUnitCatalogue::Entry *>;
template class EST_Hash_Pair<EST_String,CstrRawUnitCatalogue::Entry *>;
#endif
CstrRawUnitCatalogue::Entry *EST_THash<EST_String, CstrRawUnitCatalogue::Entry *>::Dummy_Value = NULL;


